/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.admin.api.rest;

import com.irdstudio.sdk.admin.dao.domain.SubsCodeBase;
import com.irdstudio.sdk.admin.service.facade.SResourceService;
import com.irdstudio.sdk.admin.service.vo.SResourceRightTree;
import com.irdstudio.sdk.admin.service.vo.SResourceRightVO;
import com.irdstudio.sdk.admin.service.vo.SResourceTree;
import com.irdstudio.sdk.admin.service.vo.SResourceVO;
import com.irdstudio.sdk.beans.core.util.StringUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.AbstractController;
import com.irdstudio.sdk.ssm.util.TreeNodeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class SResourceController
extends AbstractController {
    @Autowired
    @Qualifier(value="sResourceServiceImpl")
    private SResourceService sResourceService;

    @RequestMapping(value={"/s/resources"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SResourceVO>> querySResourceAll(SResourceVO vo) {
        List<SResourceVO> outputVo = this.sResourceService.queryAllOwner(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/s/resource/{resourceid}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<SResourceVO> queryByPk(@PathVariable(value="resourceid") String resourceid) {
        SResourceVO inVo = new SResourceVO();
        inVo.setResourceid(new String(resourceid));
        SResourceVO outputVo = this.sResourceService.queryByPk(inVo);
        return this.getResponseData((Object)outputVo);
    }

    @RequestMapping(value={"/s/resource"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody SResourceVO inSResourceVo) {
        int outputVo = this.sResourceService.deleteByPk(inSResourceVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/s/resource"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody SResourceVO inSResourceVo) {
        int outputVo = this.sResourceService.updateByPk(inSResourceVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/s/resource/change/url/subs/code"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateBySubsCode(@RequestBody SubsCodeBase subsCodeBase) {
        int outputVo = this.sResourceService.updateUrlBySubsCode(subsCodeBase);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/s/resource"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertSResource(@RequestBody SResourceVO inSResourceVo) {
        int outputVo = this.sResourceService.insertSResource(inSResourceVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/admin/menu/onelevel"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SResourceVO>> queryOneLevelAll(SResourceVO vo) {
        if (StringUtil.isNullorBank((String)vo.getSystempk())) {
            return ResponseData.create(null, (String)"-1", (String)"\u7cfb\u7edf\u6807\u8bc6\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u83b7\u53d6", (boolean)false);
        }
        vo.setParentid("root");
        List<SResourceVO> outputVo = this.sResourceService.queryAllByCondition(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/admin/menu/submenus"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SResourceVO>> querySubmenusAll(SResourceVO vo) {
        if (StringUtil.isNullorBank((String)vo.getParentid())) {
            return ResponseData.create(null, (String)"-1", (String)"\u83dc\u5355\u6807\u8bc6\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u83b7\u53d6", (boolean)false);
        }
        List<SResourceVO> outputVo = this.sResourceService.queryAllByCondition(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/s/resources/{subsId}/{actorno}"}, method={RequestMethod.POST})
    @ResponseBody
    public List<SResourceTree> queryMenusAll(@PathVariable(value="subsId") String subsId, @PathVariable(value="actorno") String actorno) {
        ArrayList<SResourceTree> outputVo = null;
        List<SResourceVO> result = this.sResourceService.queryAllByActorno(actorno);
        if (Objects.nonNull(result)) {
            outputVo = TreeNodeUtil.getSResourceTree(result, subsId);
        }
        return outputVo;
    }

    @RequestMapping(value={"/s/resource/all/{subsId}"}, method={RequestMethod.POST})
    @ResponseBody
    public List<SResourceTree> queryMenusAll(SResourceVO vo, @PathVariable(value="subsId") String subsId) {
        ArrayList<SResourceTree> outputVo = null;
        List<SResourceVO> result = this.sResourceService.queryAllByCondition(vo);
        if (Objects.nonNull(result) && CollectionUtils.isNotEmpty(outputVo = TreeNodeUtil.getSResourceTree(result, subsId))) {
            for (SResourceTree t : outputVo) {
                if (!CollectionUtils.isNotEmpty(t.getChildren())) continue;
                for (SResourceTree child : t.getChildren()) {
                    child.setState("open");
                }
            }
        }
        return outputVo;
    }

    @RequestMapping(value={"/s/resource/Rights/{roleno}"}, method={RequestMethod.POST})
    @ResponseBody
    public List<SResourceRightTree> queryMenusRights(@PathVariable(value="roleno") String roleno) {
        List<SResourceRightTree> outputVo = null;
        List<SResourceRightVO> result = this.sResourceService.queryMenusRights(roleno);
        if (Objects.nonNull(result)) {
            outputVo = TreeNodeUtil.getSResourceRightTree(result);
        }
        return outputVo;
    }
}

