/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.ssm.util;

import com.irdstudio.sdk.admin.service.vo.SResourceRightTree;
import com.irdstudio.sdk.admin.service.vo.SResourceRightVO;
import com.irdstudio.sdk.admin.service.vo.SResourceTree;
import com.irdstudio.sdk.admin.service.vo.SResourceVO;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class TreeNodeUtil {
    public static ArrayList<SResourceTree> getTree(List<SResourceTree> list, String subsId) {
        ArrayList<SResourceTree> tree = new ArrayList<SResourceTree>();
        for (SResourceTree treeNode : list) {
            if (!subsId.equals(treeNode.getParentId().toLowerCase())) continue;
            treeNode.setChildren(TreeNodeUtil.getChildrenNode(treeNode.getId(), list));
            treeNode.setState("open");
            tree.add(treeNode);
        }
        return tree;
    }

    public static ArrayList<SResourceTree> getChildrenNode(String pid, List<SResourceTree> list) {
        ArrayList<SResourceTree> childrenNode = new ArrayList<SResourceTree>();
        for (SResourceTree treeNode : list) {
            if (!pid.equals(treeNode.getParentId())) continue;
            treeNode.setChildren(TreeNodeUtil.getChildrenNode(treeNode.getId(), list));
            if (CollectionUtils.isNotEmpty(treeNode.getChildren())) {
                treeNode.setState("closed");
            }
            childrenNode.add(treeNode);
        }
        return childrenNode;
    }

    public static ArrayList<SResourceTree> getSResourceTree(List<SResourceVO> resourceVOList, String subsId) {
        ArrayList<SResourceTree> sResourceTrees = new ArrayList<SResourceTree>();
        for (SResourceVO sResourceVO : resourceVOList) {
            SResourceTree sResourceTree = new SResourceTree();
            sResourceTree.setId(sResourceVO.getResourceid());
            sResourceTree.setText(sResourceVO.getCnname());
            sResourceTree.setParentId(sResourceVO.getParentid());
            sResourceTree.setUrl(sResourceVO.getUrl());
            sResourceTrees.add(sResourceTree);
        }
        return TreeNodeUtil.getTree(sResourceTrees, subsId);
    }

    public static List<SResourceRightTree> getSResourceRightTree(List<SResourceRightVO> list) {
        ArrayList<SResourceRightTree> sResourceRightTrees = new ArrayList<SResourceRightTree>();
        for (SResourceRightVO sResourceRightVO : list) {
            SResourceRightTree sResourceRightTree = new SResourceRightTree();
            sResourceRightTree.setId(sResourceRightVO.getId());
            sResourceRightTree.setText(sResourceRightVO.getText());
            sResourceRightTree.setParentId(sResourceRightVO.getParentId());
            sResourceRightTree.setChecked(sResourceRightVO.getChecked());
            sResourceRightTree.setIsBase(sResourceRightVO.getIsBase());
            sResourceRightTrees.add(sResourceRightTree);
        }
        ArrayList<SResourceRightTree> tree = new ArrayList<SResourceRightTree>();
        for (SResourceRightTree treeNode : sResourceRightTrees) {
            if (!"root".equals(treeNode.getParentId().toLowerCase())) continue;
            treeNode.setChildren(TreeNodeUtil.getSResourceRightChildren(treeNode.getId(), sResourceRightTrees));
            if (!treeNode.getChildren().isEmpty()) {
                treeNode.setChecked(null);
            }
            tree.add(treeNode);
        }
        return tree;
    }

    public static ArrayList<SResourceRightTree> getSResourceRightChildren(String pid, List<SResourceRightTree> list) {
        ArrayList<SResourceRightTree> childrenNode = new ArrayList<SResourceRightTree>();
        for (SResourceRightTree treeNode : list) {
            if (!pid.equals(treeNode.getParentId())) continue;
            treeNode.setChildren(TreeNodeUtil.getSResourceRightChildren(treeNode.getId(), list));
            if (!treeNode.getChildren().isEmpty()) {
                treeNode.setChecked(null);
            }
            childrenNode.add(treeNode);
        }
        return childrenNode;
    }
}

