/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.admin.service.impl;

import com.irdstudio.sdk.admin.dao.SResourceDao;
import com.irdstudio.sdk.admin.dao.SResourceactionDao;
import com.irdstudio.sdk.admin.dao.SRolerightDao;
import com.irdstudio.sdk.admin.dao.domain.SResource;
import com.irdstudio.sdk.admin.dao.domain.SResourceRight;
import com.irdstudio.sdk.admin.dao.domain.SubsCodeBase;
import com.irdstudio.sdk.admin.service.facade.SResourceService;
import com.irdstudio.sdk.admin.service.vo.SResourceRightVO;
import com.irdstudio.sdk.admin.service.vo.SResourceVO;
import com.irdstudio.sdk.beans.core.base.FrameworkService;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="sResourceServiceImpl")
public class SResourceServiceImpl
implements SResourceService,
FrameworkService {
    private static Logger logger = LoggerFactory.getLogger(SResourceServiceImpl.class);
    @Autowired
    private SResourceDao sResourceDao;
    @Autowired
    private SResourceactionDao sResourceactionDao;
    @Autowired
    private SRolerightDao sRolerightDao;

    @Override
    public int insertSResource(SResourceVO inSResourceVo) {
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u4e3a:" + inSResourceVo.toString());
        int num = 0;
        try {
            SResource sResource = new SResource();
            this.beanCopy((Object)inSResourceVo, (Object)sResource);
            num = this.sResourceDao.insertSResource(sResource);
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u6761\u6570\u4e3a:" + num);
        return num;
    }

    @Override
    public int deleteByPk(SResourceVO inSResourceVo) {
        logger.debug("\u5f53\u524d\u5220\u9664\u6570\u636e\u6761\u4ef6\u4e3a:" + inSResourceVo.toString());
        int num = 0;
        try {
            SResource sResource = new SResource();
            this.beanCopy((Object)inSResourceVo, (Object)sResource);
            num = this.sResourceDao.deleteByPk(sResource);
            this.sResourceactionDao.deleteBySResourceId(sResource.getResourceid());
            this.sRolerightDao.deleteBySResourceId(sResource.getResourceid());
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + (Object)((Object)inSResourceVo) + "\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public int updateByPk(SResourceVO inSResourceVo) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u4e3a:" + inSResourceVo.toString());
        int num = 0;
        try {
            SResource sResource = new SResource();
            this.beanCopy((Object)inSResourceVo, (Object)sResource);
            num = this.sResourceDao.updateByPk(sResource);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + (Object)((Object)inSResourceVo) + "\u4fee\u6539\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public int updateUrlBySubsCode(SubsCodeBase subsCodeBase) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u4e3a:" + subsCodeBase.toString());
        int num = 0;
        try {
            subsCodeBase.setOldSubsCode("subsCode=" + subsCodeBase.getOldSubsCode());
            subsCodeBase.setNewSubsCode("subsCode=" + subsCodeBase.getNewSubsCode());
            num = this.sResourceDao.updateUrlBySubsCode(subsCodeBase);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + subsCodeBase.getOldSubsCode() + "\u4fee\u6539\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return 0;
    }

    @Override
    public SResourceVO queryByPk(SResourceVO inSResourceVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u53c2\u6570\u4fe1\u606f\u4e3a:" + inSResourceVo.toString());
        try {
            SResource querySResource = new SResource();
            this.beanCopy((Object)inSResourceVo, (Object)querySResource);
            SResource queryRslSResource = this.sResourceDao.queryByPk(querySResource);
            if (Objects.nonNull((Object)queryRslSResource)) {
                SResourceVO outSResourceVo = (SResourceVO)((Object)this.beanCopy((Object)queryRslSResource, (Object)new SResourceVO()));
                logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a:" + outSResourceVo.toString());
                return outSResourceVo;
            }
            logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
        }
        return null;
    }

    @Override
    public List<SResourceVO> queryAllOwner(SResourceVO sResourceVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:" + sResourceVo.toString());
        List list = null;
        try {
            List<SResource> sResources = this.sResourceDao.queryAllOwnerByPage(sResourceVo);
            logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + sResources.size());
            this.pageSet(sResources, sResourceVo);
            list = (List)this.beansCopy(sResources, SResourceVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<SResourceVO> queryAllCurrOrg(SResourceVO sResourceVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:" + sResourceVo.toString());
        List<SResource> sResources = this.sResourceDao.queryAllCurrOrgByPage(sResourceVo);
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + sResources.size());
        List list = null;
        try {
            this.pageSet(sResources, sResourceVo);
            list = (List)this.beansCopy(sResources, SResourceVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<SResourceVO> queryAllCurrDownOrg(SResourceVO sResourceVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u53ca\u4ee5\u4e0b\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:" + sResourceVo.toString());
        List<SResource> sResources = this.sResourceDao.queryAllCurrDownOrgByPage(sResourceVo);
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u53ca\u4ee5\u4e0b\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + sResources.size());
        List list = null;
        try {
            this.pageSet(sResources, sResourceVo);
            list = (List)this.beansCopy(sResources, SResourceVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<SResourceVO> queryAllByCondition(SResourceVO sResourceVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:" + sResourceVo.toString());
        List<SResource> sResources = this.sResourceDao.queryAllByCondition(sResourceVo);
        logger.debug("\u5f53\u524d\u67e5\u8be2\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + sResources.size());
        List list = null;
        try {
            list = (List)this.beansCopy(sResources, SResourceVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<SResourceRightVO> queryMenusRights(String roleno) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:" + roleno);
        List list = null;
        try {
            List<SResourceRight> sResourceRights = this.sResourceDao.queryMenusRights(roleno);
            logger.debug("\u5f53\u524d\u67e5\u8be2\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + sResourceRights.size());
            list = (List)this.beansCopy(sResourceRights, SResourceRightVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<SResourceVO> getAllByParentId(String parentid) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:" + parentid);
        List<SResource> sResources = this.sResourceDao.getAllByParentId(parentid);
        logger.debug("\u5f53\u524d\u67e5\u8be2\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + sResources.size());
        List list = null;
        try {
            list = (List)this.beansCopy(sResources, SResourceVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<SResourceVO> queryAllByActorno(String actorno) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:" + actorno);
        List<SResource> sResources = this.sResourceDao.queryAllByActorno(actorno);
        logger.debug("\u5f53\u524d\u67e5\u8be2\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + sResources.size());
        List list = null;
        try {
            list = (List)this.beansCopy(sResources, SResourceVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }
}

