/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.ssm.mybatis.iterceptor;

import com.alibaba.druid.util.StringUtils;
import com.irdstudio.sdk.beans.core.vo.BaseInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.DefaultReflectorFactory;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.apache.ibatis.scripting.defaults.DefaultParameterHandler;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(method="prepare", type=StatementHandler.class, args={Connection.class, Integer.class}), @Signature(method="query", type=Executor.class, args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class SqlPageInterceptor
implements Interceptor {
    private static Logger logger = LoggerFactory.getLogger(SqlPageInterceptor.class);

    public Object intercept(Invocation invocation) throws Throwable {
        if (invocation.getTarget() instanceof StatementHandler) {
            StatementHandler statementHandler = (StatementHandler)invocation.getTarget();
            MetaObject metaObjectHandler = MetaObject.forObject((Object)statementHandler, (ObjectFactory)SystemMetaObject.DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)SystemMetaObject.DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)new DefaultReflectorFactory());
            MappedStatement mappedStatement = (MappedStatement)metaObjectHandler.getValue("delegate.mappedStatement");
            String mapId = mappedStatement.getId();
            String dbTypeName = (String)metaObjectHandler.getValue("delegate.mappedStatement.configuration.environment.dataSource.dbTypeName");
            if (mapId.matches(".+ByPage$")) {
                ParameterHandler parameterHandler = (ParameterHandler)metaObjectHandler.getValue("delegate.parameterHandler");
                BaseInfo pageInfo = (BaseInfo)parameterHandler.getParameterObject();
                pageInfo.checkAndSetPageInfo();
                String sql = (String)metaObjectHandler.getValue("delegate.boundSql.sql");
                this.queryTotalRecord(pageInfo, pageInfo, mappedStatement, (Connection)invocation.getArgs()[0]);
                String limitSql = sql;
                limitSql = StringUtils.equalsIgnoreCase((String)"oracle", (String)dbTypeName) ? this.buildOraclePageSql(pageInfo, sql) : this.buildPageSql(pageInfo, sql);
                logger.info("\u751f\u6210\u7684\u5206\u9875\u67e5\u8be2sql\u4e3a\uff1a" + limitSql);
                metaObjectHandler.setValue("delegate.boundSql.sql", (Object)limitSql);
            }
        }
        return invocation.proceed();
    }

    public Object plugin(Object arg0) {
        return Plugin.wrap((Object)arg0, (Interceptor)this);
    }

    public void setProperties(Properties arg0) {
    }

    protected String buildPageSql(BaseInfo pageInfo, String sql) {
        int offset = (pageInfo.getPage() - 1) * pageInfo.getSize();
        return sql + " limit " + offset + "," + pageInfo.getSize();
    }

    protected String buildOraclePageSql(BaseInfo pageInfo, String sql) {
        int offset;
        int startRow = offset = (pageInfo.getPage() - 1) * pageInfo.getSize();
        int endRow = offset + pageInfo.getSize();
        StringBuilder sqlBuilder = new StringBuilder(sql.length() + 120);
        if (startRow > 0) {
            sqlBuilder.append("SELECT * FROM ( ");
        }
        if (endRow > 0) {
            sqlBuilder.append(" SELECT TMP_PAGE.*, ROWNUM ROW_ID FROM ( ");
        }
        sqlBuilder.append(sql);
        if (endRow > 0) {
            sqlBuilder.append(" ) TMP_PAGE WHERE ROWNUM <= ");
            sqlBuilder.append(endRow);
        }
        if (startRow > 0) {
            sqlBuilder.append(" ) WHERE ROW_ID > ");
            sqlBuilder.append(startRow);
        }
        return sqlBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void queryTotalRecord(BaseInfo page, Object parameterObject, MappedStatement mappedStatement, Connection connection) throws SQLException {
        BoundSql boundSql = mappedStatement.getBoundSql((Object)page);
        String sql = boundSql.getSql();
        String countSql = this.buildCountSql(sql);
        logger.info("\u751f\u6210\u7684\u67e5\u8be2\u603b\u9875\u6570\u7684sql\u4e3a:" + countSql);
        List parameterMappings = boundSql.getParameterMappings();
        BoundSql countBoundSql = new BoundSql(mappedStatement.getConfiguration(), countSql, parameterMappings, parameterObject);
        DefaultParameterHandler parameterHandler = new DefaultParameterHandler(mappedStatement, parameterObject, countBoundSql);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = connection.prepareStatement(countSql);
            parameterHandler.setParameters(pstmt);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                int totalRecord = rs.getInt(1);
                page.setTotal(totalRecord);
                logger.info("\u67e5\u8be2\u5230\u7684\u603b\u9875\u6570\u4e3a:" + totalRecord);
            }
        }
        catch (Exception e) {
            logger.error("\u6267\u884c\u67e5\u8be2\u603b\u9875\u6570sql\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    logger.error("\u5173\u95edResultSet\u65f6\u5f02\u5e38.", (Throwable)e);
                }
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception e) {
                    logger.error("\u5173\u95edPreparedStatement\u65f6\u5f02\u5e38.", (Throwable)e);
                }
            }
        }
    }

    protected String buildCountSql(String sql) {
        return "select count(1) from (" + sql + ") t";
    }
}

