/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.admin.service.impl;

import com.irdstudio.sdk.admin.dao.SRolerightDao;
import com.irdstudio.sdk.admin.dao.domain.SRoleright;
import com.irdstudio.sdk.admin.service.facade.SRolerightService;
import com.irdstudio.sdk.admin.service.vo.SResourceRightTree;
import com.irdstudio.sdk.admin.service.vo.SRolerightVO;
import com.irdstudio.sdk.beans.core.base.FrameworkService;
import com.irdstudio.sdk.beans.core.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="sRolerightServiceImpl")
public class SRolerightServiceImpl
implements SRolerightService,
FrameworkService {
    private static Logger logger = LoggerFactory.getLogger(SRolerightServiceImpl.class);
    private static final String RESOURCE_DESCRIBE = "\u83dc\u5355\u8bbf\u95ee";
    @Autowired
    private SRolerightDao sRolerightDao;

    @Override
    public int insertSRoleright(SRolerightVO inSRolerightVo) {
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u4e3a:" + inSRolerightVo.toString());
        int num = 0;
        try {
            SRoleright sRoleright = new SRoleright();
            this.beanCopy((Object)inSRolerightVo, (Object)sRoleright);
            num = this.sRolerightDao.insertSRoleright(sRoleright);
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u6761\u6570\u4e3a:" + num);
        return num;
    }

    @Override
    public int deleteByPk(SRolerightVO inSRolerightVo) {
        logger.debug("\u5f53\u524d\u5220\u9664\u6570\u636e\u6761\u4ef6\u4e3a:" + (Object)((Object)inSRolerightVo));
        int num = 0;
        try {
            SRoleright sRoleright = new SRoleright();
            this.beanCopy((Object)inSRolerightVo, (Object)sRoleright);
            num = this.sRolerightDao.deleteByPk(sRoleright);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + (Object)((Object)inSRolerightVo) + "\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public int updateByPk(SRolerightVO inSRolerightVo) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u4e3a:" + inSRolerightVo.toString());
        int num = 0;
        try {
            SRoleright sRoleright = new SRoleright();
            this.beanCopy((Object)inSRolerightVo, (Object)sRoleright);
            num = this.sRolerightDao.updateByPk(sRoleright);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + (Object)((Object)inSRolerightVo) + "\u4fee\u6539\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public SRolerightVO queryByPk(SRolerightVO inSRolerightVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u53c2\u6570\u4fe1\u606f\u4e3a:" + (Object)((Object)inSRolerightVo));
        try {
            SRoleright querySRoleright = new SRoleright();
            this.beanCopy((Object)inSRolerightVo, (Object)querySRoleright);
            SRoleright queryRslSRoleright = this.sRolerightDao.queryByPk(querySRoleright);
            if (Objects.nonNull((Object)queryRslSRoleright)) {
                SRolerightVO outSRolerightVo = (SRolerightVO)((Object)this.beanCopy((Object)queryRslSRoleright, (Object)new SRolerightVO()));
                logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a:" + outSRolerightVo.toString());
                return outSRolerightVo;
            }
            logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
        }
        return null;
    }

    @Override
    public List<SRolerightVO> queryAllOwner(SRolerightVO sRolerightVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:" + sRolerightVo.toString());
        List list = null;
        try {
            List<SRoleright> sRolerights = this.sRolerightDao.queryAllOwnerByPage(sRolerightVo);
            logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + sRolerights.size());
            this.pageSet(sRolerights, sRolerightVo);
            list = (List)this.beansCopy(sRolerights, SRolerightVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<SRolerightVO> queryAllCurrOrg(SRolerightVO sRolerightVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:" + sRolerightVo.toString());
        List<SRoleright> sRolerights = this.sRolerightDao.queryAllCurrOrgByPage(sRolerightVo);
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + sRolerights.size());
        List list = null;
        try {
            this.pageSet(sRolerights, sRolerightVo);
            list = (List)this.beansCopy(sRolerights, SRolerightVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<SRolerightVO> queryAllCurrDownOrg(SRolerightVO sRolerightVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u53ca\u4ee5\u4e0b\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:" + sRolerightVo.toString());
        List<SRoleright> sRolerights = this.sRolerightDao.queryAllCurrDownOrgByPage(sRolerightVo);
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u53ca\u4ee5\u4e0b\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + sRolerights.size());
        List list = null;
        try {
            this.pageSet(sRolerights, sRolerightVo);
            list = (List)this.beansCopy(sRolerights, SRolerightVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<SRolerightVO> queryAllByCondition(SRolerightVO sRolerightVo) {
        List result = null;
        logger.debug("\u5f53\u524d\u67e5\u8be2\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:" + sRolerightVo.toString());
        List<SRoleright> sRolerights = this.sRolerightDao.queryAllByCondition(sRolerightVo);
        logger.debug("\u5f53\u524d\u67e5\u8be2\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + sRolerights.size());
        try {
            result = (List)this.beansCopy(sRolerights, SRolerightVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return result;
    }

    @Override
    public int saveSRoleRight(SRolerightVO sRolerightVO) {
        int result = 0;
        SRoleright sRoleright = new SRoleright();
        this.beanCopy((Object)sRolerightVO, (Object)sRoleright);
        result += this.sRolerightDao.deleteSRoleRight(sRoleright);
        List<String> actIdList = null;
        String actIdStr = sRolerightVO.getActIdStr();
        if (!StringUtils.isEmpty((String)actIdStr)) {
            actIdList = Arrays.asList(actIdStr.split(","));
        }
        if (Objects.nonNull(actIdList) && actIdList.size() > 0) {
            String sourceId = sRoleright.getResourceid();
            String roleNo = sRoleright.getRoleno();
            List<SRoleright> sRoleRightList = this.getParentResActId(sourceId, roleNo);
            for (String actId : actIdList) {
                SRoleright temp = new SRoleright();
                temp.setRoleno(roleNo);
                temp.setResourceid(sourceId);
                temp.setActid(actId);
                sRoleRightList.add(temp);
            }
            result = this.sRolerightDao.insertBatch(sRoleRightList);
        }
        return result;
    }

    @Override
    public int saveSRoleRightTree(List<SResourceRightTree> tree, String roleno) {
        int result = 0;
        SRoleright sRoleright = new SRoleright();
        sRoleright.setRoleno(roleno);
        result = this.sRolerightDao.deleteByPk(sRoleright);
        List<SRoleright> sRolerightList = this.getTreeSRoleRights(tree, roleno);
        result = this.sRolerightDao.insertBatch(sRolerightList);
        return result;
    }

    private List<SRoleright> getTreeSRoleRights(List<SResourceRightTree> tree, String roleno) {
        ArrayList<SRoleright> result = new ArrayList<SRoleright>();
        for (SResourceRightTree item : tree) {
            SRoleright sRoleright = new SRoleright();
            if (item.getIsBase().booleanValue() && item.getChecked().booleanValue()) {
                sRoleright.setRoleno(roleno);
                sRoleright.setResourceid(item.getId());
                sRoleright.setActid("visit");
                if (item.getChildren().size() > 0) {
                    result.addAll(this.getTreeSRoleRights(item.getChildren(), roleno));
                }
                result.add(sRoleright);
                continue;
            }
            if (!item.getChecked().booleanValue()) continue;
            sRoleright.setRoleno(roleno);
            sRoleright.setResourceid(item.getParentId());
            sRoleright.setActid(item.getId());
            result.add(sRoleright);
        }
        return result;
    }

    private List<SRoleright> getParentResActId(String resourceId, String roleNo) {
        ArrayList<SRoleright> result = new ArrayList<SRoleright>();
        List<SRoleright> sRoleRightList = this.sRolerightDao.queryParentResInfo(resourceId, RESOURCE_DESCRIBE, roleNo);
        while (Objects.nonNull(sRoleRightList) && sRoleRightList.size() > 0) {
            SRoleright sRoleright = sRoleRightList.get(0);
            if (StringUtil.isStrNotEmpty((String)sRoleright.getActid())) {
                sRoleright.setRoleno(roleNo);
                result.add(sRoleright);
            }
            sRoleRightList = this.sRolerightDao.queryParentResInfo(sRoleright.getResourceid(), RESOURCE_DESCRIBE, roleNo);
        }
        return result;
    }
}

