/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.ssm.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;

public class FileUtil {
    public static byte[] getContent(String filePath) throws IOException {
        File file = new File(filePath);
        return FileUtil.getContent(file);
    }

    public static byte[] toByteArray(String filename) throws IOException {
        File f = new File(filename);
        return FileUtil.toByteArray(f);
    }

    public static byte[] toByteArrayByChannel(String filename) throws IOException {
        File f = new File(filename);
        if (!f.exists()) {
            throw new FileNotFoundException(filename);
        }
        return FileUtil.toByteArrayByChannel(f);
    }

    public static byte[] getContent(File file) throws IOException {
        int offset;
        long fileSize = file.length();
        if (fileSize > Integer.MAX_VALUE) {
            System.out.println("file too big...");
            return null;
        }
        FileInputStream fi = new FileInputStream(file);
        byte[] buffer = new byte[(int)fileSize];
        int numRead = 0;
        for (offset = 0; offset < buffer.length && (numRead = fi.read(buffer, offset, buffer.length - offset)) >= 0; offset += numRead) {
        }
        if (offset != buffer.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        fi.close();
        return buffer;
    }

    public static byte[] toByteArray(File f) throws IOException {
        if (!f.exists()) {
            throw new FileNotFoundException(f.getName());
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream((int)f.length());
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(f));
            int buf_size = 1024;
            byte[] buffer = new byte[buf_size];
            int len = 0;
            while (-1 != (len = in.read(buffer, 0, buf_size))) {
                bos.write(buffer, 0, len);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            bos.close();
        }
    }

    public static byte[] toByteArrayByChannel(File f) throws IOException {
        if (!f.exists()) {
            throw new FileNotFoundException(f.getName());
        }
        AbstractInterruptibleChannel channel = null;
        FileInputStream fs = null;
        try {
            fs = new FileInputStream(f);
            channel = fs.getChannel();
            ByteBuffer byteBuffer = ByteBuffer.allocate((int)((FileChannel)channel).size());
            while (((FileChannel)channel).read(byteBuffer) > 0) {
            }
            byte[] byArray = byteBuffer.array();
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            try {
                channel.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                fs.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static byte[] toByteArray3(String filename) throws IOException {
        AbstractInterruptibleChannel fc = null;
        try {
            fc = new RandomAccessFile(filename, "r").getChannel();
            MappedByteBuffer byteBuffer = ((FileChannel)fc).map(FileChannel.MapMode.READ_ONLY, 0L, ((FileChannel)fc).size()).load();
            System.out.println(byteBuffer.isLoaded());
            byte[] result = new byte[(int)((FileChannel)fc).size()];
            if (byteBuffer.remaining() > 0) {
                byteBuffer.get(result, 0, byteBuffer.remaining());
            }
            byte[] byArray = result;
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            try {
                fc.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void writeBytesToFile(byte[] bs, String targetFilePath, String targetFileName) throws IOException {
        FileOutputStream out = new FileOutputStream(targetFilePath + targetFileName);
        ByteArrayInputStream is = new ByteArrayInputStream(bs);
        byte[] buff = new byte[1024];
        int len = 0;
        while ((len = is.read(buff)) != -1) {
            ((OutputStream)out).write(buff, 0, len);
        }
        ((InputStream)is).close();
        ((OutputStream)out).close();
    }
}

