/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.ssm.web.filter;

import com.irdstudio.sdk.admin.service.facade.E4AServiceSsm;
import com.irdstudio.sdk.admin.service.vo.AuthInfoVO;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.ssm.session.SessionManager;
import com.irdstudio.sdk.ssm.util.CookiesUtil;
import com.irdstudio.sdk.ssm.vo.UserInfo;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.validation.Assertion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class E4ACasFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(E4ACasFilter.class);
    private SessionManager sessionManager;

    public void init(FilterConfig filterConfig) throws ServletException {
        WebApplicationContext applicationcontext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)filterConfig.getServletContext());
        this.sessionManager = (SessionManager)applicationcontext.getBean("sessionManager", SessionManager.class);
    }

    public void doFilter(ServletRequest req, ServletResponse rep, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)rep;
        response.setHeader("Content-type", "text/html;charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
        String requestPath = request.getServletPath();
        AuthInfoVO authInfo = null;
        try {
            UserInfo userInfo;
            AttributePrincipal principal;
            HttpSession session = request.getSession();
            String sessionId = session.getId();
            Assertion assertion = (Assertion)session.getAttribute("_const_cas_assertion_");
            if (!(assertion == null || (principal = assertion.getPrincipal()) == null || (userInfo = this.sessionManager.getLoginInfo(sessionId)) != null && StringUtils.equals((CharSequence)userInfo.getUserId(), (CharSequence)principal.getName()))) {
                E4AServiceSsm e4aServiceC = (E4AServiceSsm)SpringContextUtils.getBean((String)"e4aServiceC", E4AServiceSsm.class);
                AuthInfoVO authInfoVO = new AuthInfoVO();
                authInfoVO.setSessionId(sessionId);
                authInfoVO.setUsercode(principal.getName());
                authInfo = e4aServiceC.casGetUserInfo(authInfoVO);
                if (authInfo != null && Objects.nonNull(authInfo.getUserInfo())) {
                    CookiesUtil.addCookie(response, "ssoclient", authInfo.getSessionId(), -1);
                    CookiesUtil.addCookie(response, "ssottp", String.valueOf(authInfo.getTimestamp()), -1);
                    CookiesUtil.addCookie(response, "ssomd5", authInfo.getMd5(), -1);
                    CookiesUtil.addCookie(response, "signUserId", authInfo.getUsercode(), -1);
                    this.sessionManager.setLoginInfo(authInfo.getUserInfo(), request);
                }
            }
        }
        catch (Exception e) {
            logger.error("sso client request token check fail: " + e.getMessage(), (Throwable)e);
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void destroy() {
    }

    public static Map<String, String> parseQuerystring(String queryString) {
        String[] params;
        HashMap<String, String> map = new HashMap<String, String>();
        if (queryString == null || queryString.equals("")) {
            return map;
        }
        for (String param : params = queryString.split("&")) {
            try {
                String[] keyValuePair = param.split("=", 2);
                String name = URLDecoder.decode(keyValuePair[0], "UTF-8");
                if (name == "") continue;
                String value = keyValuePair.length > 1 ? URLDecoder.decode(keyValuePair[1].replaceAll("%20", "%2b"), "UTF-8") : "";
                map.put(name, value);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return map;
    }

    public static void main(String[] args) {
        String requestPath = "/static/css/te/test.jpg";
        String passedPath = "/static/**/*.jpg";
        AntPathMatcher matcher = new AntPathMatcher();
        System.out.println(matcher.match(passedPath, requestPath));
    }
}

