/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.ssm.session;

import com.irdstudio.sdk.admin.service.impl.E4AServiceImpl;
import com.irdstudio.sdk.ssm.vo.SMenuFuncOpUserVO;
import com.irdstudio.sdk.ssm.vo.UserInfo;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionManager {
    private static final Logger logger = LoggerFactory.getLogger(E4AServiceImpl.class);
    private String name;
    private Map sessions = new HashMap();
    private Timer timer;
    private int sessionTimeOut = 900000;
    private int sessionCheckInterval = 60000;
    private String access;
    private String alias;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession(HttpSession session) {
        Map map = this.sessions;
        synchronized (map) {
            this.sessions.remove(session.getId());
        }
        Enumeration keys = session.getAttributeNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            session.removeAttribute(key);
        }
    }

    public void removeSession(String sessionId) {
        this.removeSession((HttpSession)this.sessions.get(sessionId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpSession getSession(HttpServletRequest requestObj, boolean createWhenNotCreate) {
        HttpServletRequest request = requestObj;
        HttpSession session = request.getSession(createWhenNotCreate);
        if (session != null) {
            if (createWhenNotCreate) {
                logger.debug("Create new Session:" + session.getId() + " Total session size: " + (this.sessions.size() + 1));
                Map map = this.sessions;
                synchronized (map) {
                    this.sessions.put(session.getId(), session);
                }
            }
            return session;
        }
        return null;
    }

    public void setLoginInfo(UserInfo userInfo, HttpServletRequest requestObj) {
        HttpSession session = this.getSession(requestObj, true);
        session.setAttribute("userInfo", (Object)userInfo);
    }

    public void setLoginInfo(String sessionId, UserInfo userInfo, HttpServletRequest requestObj) {
        HttpSession session = (HttpSession)this.sessions.get(sessionId);
        if (session == null) {
            session = this.getSession(requestObj, true);
            this.sessions.put(session.getId(), session);
            this.sessions.put(sessionId, session);
        }
        session.setAttribute("userInfo", (Object)userInfo);
    }

    public UserInfo getLoginInfo(String sessionId) {
        HttpSession session = (HttpSession)this.sessions.get(sessionId);
        if (session != null) {
            return (UserInfo)session.getAttribute("userInfo");
        }
        return null;
    }

    public void initialize() {
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new SessionCheckTask(), this.sessionTimeOut, (long)this.sessionCheckInterval);
    }

    public String encodeURL(HttpServletRequest request, HttpServletResponse response, String url, String method) {
        return response.encodeURL(url);
    }

    public int getSessionCheckInterval() {
        return this.sessionCheckInterval;
    }

    public void setSessionCheckInterval(int sessionCheckInterval) {
        this.sessionCheckInterval = sessionCheckInterval;
    }

    public int getSessionTimeOut() {
        return this.sessionTimeOut;
    }

    public void setSessionTimeOut(int sessionTimeOut) {
        this.sessionTimeOut = sessionTimeOut;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAppendPostField(HttpServletRequest request, String targetClient) {
        return "";
    }

    public void setId(String value) {
        this.setName(value);
    }

    public int getSessionCount() {
        return this.sessions.size();
    }

    public Map getSessions() {
        return this.sessions;
    }

    public void setSessions(Map sessions) {
        this.sessions = sessions;
    }

    public void terminate() {
        if (this.timer == null) {
            return;
        }
        logger.info("Terminate the SessionManager [" + this.name + "]");
        try {
            this.timer.cancel();
            this.timer = null;
            this.sessions = new HashMap();
        }
        catch (Exception e) {
            logger.error("failed to Terminate the SessionManager [" + this.name + "]", (Throwable)e);
        }
    }

    public void setAlias(String value) {
        this.alias = value;
    }

    public String getAlias() {
        return this.alias;
    }

    public boolean isSingleton() {
        return true;
    }

    public String getAccess() {
        return this.access;
    }

    public void setAccess(String access) {
        this.access = access;
    }

    public void setUserResource(SMenuFuncOpUserVO sMenuFuncOpUserVO, HttpServletRequest requestObj) {
        HttpSession session = this.getSession(requestObj, true);
        session.setAttribute(sMenuFuncOpUserVO.getActorNo(), sMenuFuncOpUserVO.getMenus());
    }

    private class SessionCheckTask
    extends TimerTask {
        private SessionCheckTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object[] keys = null;
            try {
                keys = SessionManager.this.sessions.keySet().toArray();
            }
            catch (Exception e) {
                logger.error("Failed to do session time out check", (Throwable)e);
                return;
            }
            logger.info("Current Session Count: " + keys.length);
            for (int i = 0; i < keys.length; ++i) {
                try {
                    HttpSession session = (HttpSession)SessionManager.this.sessions.get(keys[i]);
                    if (session == null) continue;
                    logger.info("Session Check: " + session.getId());
                    if (System.currentTimeMillis() - session.getLastAccessedTime() <= (long)SessionManager.this.sessionTimeOut) continue;
                    logger.info("Session time out: " + session.getId() + " in [" + SessionManager.this.name + "]");
                    Map map = SessionManager.this.sessions;
                    synchronized (map) {
                        SessionManager.this.sessions.remove(session.getId());
                        continue;
                    }
                }
                catch (Exception e) {
                    logger.error("Failed to do session time out check", (Throwable)e);
                }
            }
        }
    }
}

