/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.admin.service.impl;

import com.irdstudio.sdk.admin.dao.SRoleuserDao;
import com.irdstudio.sdk.admin.dao.domain.SRoleuser;
import com.irdstudio.sdk.admin.service.facade.SRoleuserService;
import com.irdstudio.sdk.admin.service.vo.SRoleuserVO;
import com.irdstudio.sdk.beans.core.base.FrameworkService;
import com.irdstudio.sdk.beans.core.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="sRoleuserServiceImpl")
public class SRoleuserServiceImpl
implements SRoleuserService,
FrameworkService {
    private static Logger logger = LoggerFactory.getLogger(SRoleuserServiceImpl.class);
    @Autowired
    private SRoleuserDao sRoleuserDao;

    @Override
    public int insertSRoleuser(SRoleuserVO inSRoleuserVo) {
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u4e3a:" + inSRoleuserVo.toString());
        int num = 0;
        try {
            SRoleuser sRoleuser = new SRoleuser();
            this.beanCopy((Object)inSRoleuserVo, (Object)sRoleuser);
            num = this.sRoleuserDao.insertSRoleuser(sRoleuser);
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u6761\u6570\u4e3a:" + num);
        return num;
    }

    @Override
    public int deleteByPk(SRoleuserVO inSRoleuserVo) {
        logger.debug("\u5f53\u524d\u5220\u9664\u6570\u636e\u6761\u4ef6\u4e3a:" + inSRoleuserVo.toString());
        int num = 0;
        try {
            SRoleuser sRoleuser = new SRoleuser();
            this.beanCopy((Object)inSRoleuserVo, (Object)sRoleuser);
            num = this.sRoleuserDao.deleteByPk(sRoleuser);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + (Object)((Object)inSRoleuserVo) + "\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public int updateByPk(SRoleuserVO inSRoleuserVo) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u4e3a:" + inSRoleuserVo.toString());
        int num = 0;
        try {
            SRoleuser sRoleuser = new SRoleuser();
            this.beanCopy((Object)inSRoleuserVo, (Object)sRoleuser);
            num = this.sRoleuserDao.updateByPk(sRoleuser);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + (Object)((Object)inSRoleuserVo) + "\u4fee\u6539\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public SRoleuserVO queryByPk(SRoleuserVO inSRoleuserVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u53c2\u6570\u4fe1\u606f\u4e3a:" + inSRoleuserVo.toString());
        try {
            SRoleuser querySRoleuser = new SRoleuser();
            this.beanCopy((Object)inSRoleuserVo, (Object)querySRoleuser);
            SRoleuser queryRslSRoleuser = this.sRoleuserDao.queryByPk(querySRoleuser);
            if (Objects.nonNull((Object)queryRslSRoleuser)) {
                SRoleuserVO outSRoleuserVo = (SRoleuserVO)((Object)this.beanCopy((Object)queryRslSRoleuser, (Object)new SRoleuserVO()));
                logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a:" + outSRoleuserVo.toString());
                return outSRoleuserVo;
            }
            logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
        }
        return null;
    }

    @Override
    public List<SRoleuserVO> queryAllOwner(SRoleuserVO sRoleuserVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:" + sRoleuserVo.toString());
        List list = null;
        try {
            List<SRoleuser> sRoleusers = this.sRoleuserDao.queryAllOwnerByPage(sRoleuserVo);
            logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + sRoleusers.size());
            this.pageSet(sRoleusers, sRoleuserVo);
            list = this.beansCopy(sRoleusers, SRoleuserVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<SRoleuserVO> queryAllCurrOrg(SRoleuserVO sRoleuserVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:" + sRoleuserVo.toString());
        List<SRoleuser> sRoleusers = this.sRoleuserDao.queryAllCurrOrgByPage(sRoleuserVo);
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + sRoleusers.size());
        List list = null;
        try {
            this.pageSet(sRoleusers, sRoleuserVo);
            list = this.beansCopy(sRoleusers, SRoleuserVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<SRoleuserVO> queryAllCurrDownOrg(SRoleuserVO sRoleuserVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u53ca\u4ee5\u4e0b\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:" + sRoleuserVo.toString());
        List<SRoleuser> sRoleusers = this.sRoleuserDao.queryAllCurrDownOrgByPage(sRoleuserVo);
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u53ca\u4ee5\u4e0b\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + sRoleusers.size());
        List list = null;
        try {
            this.pageSet(sRoleusers, sRoleuserVo);
            list = this.beansCopy(sRoleusers, SRoleuserVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<SRoleuserVO> queryAllByCondition(SRoleuserVO sRoleuserVo) {
        List list = null;
        logger.debug("\u5f53\u524d\u67e5\u8be2\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:" + sRoleuserVo.toString());
        try {
            SRoleuser sRoleuser = new SRoleuser();
            this.beanCopy((Object)sRoleuserVo, (Object)sRoleuser);
            List<SRoleuser> sRoleUserList = this.sRoleuserDao.queryAllByCondition(sRoleuser);
            logger.debug("\u5f53\u524d\u67e5\u8be2\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + sRoleUserList.size());
            list = this.beansCopy(sRoleUserList, SRoleuserVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public int setSRoleSUser(SRoleuserVO inSRoleuserVo) {
        logger.debug("\u5f53\u524d\u8bbe\u7f6e\u7528\u6237\u89d2\u8272\u4fe1\u606f\u53c2\u6570\u4e3a:" + inSRoleuserVo.toString());
        int num = 0;
        String actorNo = inSRoleuserVo.getActorno();
        String roleNoStr = inSRoleuserVo.getRoleNostr();
        if (StringUtil.isStrNotEmpty((String)roleNoStr)) {
            if (roleNoStr.contains(",")) {
                ArrayList<SRoleuser> insertSRoleUsers = new ArrayList<SRoleuser>();
                this.getBatchList(actorNo, roleNoStr, insertSRoleUsers);
                num = this.sRoleuserDao.insertBatch(insertSRoleUsers);
            } else {
                SRoleuser sRoleuser = new SRoleuser();
                sRoleuser.setActorno(actorNo);
                sRoleuser.setRoleno(roleNoStr);
                num = this.sRoleuserDao.insertSRoleuser(sRoleuser);
            }
        }
        return num;
    }

    @Override
    public int saveSRolesUser(SRoleuserVO inSRoleuserVo) {
        logger.info("\u6839\u636e\u7528\u6237\u7f16\u53f7\u5220\u9664\u4fe1\u606f\u53c2\u6570\u4e3a:" + inSRoleuserVo.getActorno());
        int result = this.sRoleuserDao.deleteByActorNo(inSRoleuserVo.getActorno());
        logger.info("\u6839\u636e\u7528\u6237\u7f16\u53f7\u5220\u9664\u4fe1\u606f\u5220\u9664\u7684\u6570\u91cf\u4e3a:" + result);
        logger.debug("\u5f53\u524d\u8bbe\u7f6e\u7528\u6237\u89d2\u8272\u4fe1\u606f\u53c2\u6570\u4e3a:" + inSRoleuserVo.toString());
        int num = 0;
        String actorNo = inSRoleuserVo.getActorno();
        String roleNoStr = inSRoleuserVo.getRoleNostr();
        if (StringUtil.isStrNotEmpty((String)roleNoStr)) {
            if (roleNoStr.contains(",")) {
                ArrayList<SRoleuser> insertSRoleUsers = new ArrayList<SRoleuser>();
                this.getBatchList(actorNo, roleNoStr, insertSRoleUsers);
                num = this.sRoleuserDao.insertBatch(insertSRoleUsers);
            } else {
                SRoleuser sRoleuser = new SRoleuser();
                sRoleuser.setActorno(actorNo);
                sRoleuser.setRoleno(roleNoStr);
                num = this.sRoleuserDao.insertSRoleuser(sRoleuser);
            }
        }
        return num;
    }

    @Override
    public int deleteByActorNo(String actorNo) {
        logger.info("\u6839\u636e\u7528\u6237\u7f16\u53f7\u5220\u9664\u4fe1\u606f\u53c2\u6570\u4e3a:" + actorNo);
        int result = this.sRoleuserDao.deleteByActorNo(actorNo);
        logger.info("\u6839\u636e\u7528\u6237\u7f16\u53f7\u5220\u9664\u4fe1\u606f\u5220\u9664\u7684\u6570\u91cf\u4e3a:" + result);
        return result;
    }

    @Override
    public List<SRoleuserVO> queryUserSetRoles(SRoleuserVO sRoleuserVo) {
        List<SRoleuserVO> result = null;
        logger.debug("\u5f53\u524d\u67e5\u8be2\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:" + sRoleuserVo.toString());
        try {
            result = this.sRoleuserDao.queryUserSetRoles(sRoleuserVo);
            logger.debug("\u5f53\u524d\u67e5\u8be2\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + result.size());
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return result;
    }

    @Override
    public int deleteSRolesUser(SRoleuserVO inSRoleuserVo) {
        logger.info("\u5220\u9664\u4fe1\u606f\u53c2\u6570\u4e3a:" + inSRoleuserVo.toString());
        int num = 0;
        String actorNo = inSRoleuserVo.getActorno();
        String roleNoStr = inSRoleuserVo.getRoleNostr();
        ArrayList<SRoleuser> delRoleUserList = new ArrayList<SRoleuser>();
        if (StringUtil.isStrNotEmpty((String)roleNoStr)) {
            if (roleNoStr.contains(",")) {
                this.getBatchList(actorNo, roleNoStr, delRoleUserList);
                num = this.sRoleuserDao.delBatchByPk(delRoleUserList);
            } else {
                SRoleuser sRoleuser = new SRoleuser();
                sRoleuser.setActorno(actorNo);
                sRoleuser.setRoleno(roleNoStr);
                num = this.sRoleuserDao.deleteByPk(sRoleuser);
            }
        }
        return num;
    }

    private void getBatchList(String actorNo, String roleNoStr, List<SRoleuser> result) {
        String[] roleNos;
        for (String roleNo : roleNos = roleNoStr.split(",")) {
            SRoleuser sRoleuser = new SRoleuser();
            sRoleuser.setActorno(actorNo);
            sRoleuser.setRoleno(roleNo);
            result.add(sRoleuser);
        }
    }
}

