/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.admin.service.impl;

import com.alibaba.fastjson.JSON;
import com.irdstudio.sdk.admin.dao.SRoleDao;
import com.irdstudio.sdk.admin.dao.domain.SRole;
import com.irdstudio.sdk.admin.service.facade.SRoleService;
import com.irdstudio.sdk.admin.service.vo.SRoleVO;
import com.irdstudio.sdk.beans.core.base.FrameworkService;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="sRoleServiceImpl")
public class SRoleServiceImpl
implements SRoleService,
FrameworkService {
    private static Logger logger = LoggerFactory.getLogger(SRoleServiceImpl.class);
    @Autowired
    private SRoleDao sRoleDao;

    @Override
    public int insertSRole(SRoleVO inSRoleVo) {
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u4e3a:" + inSRoleVo.toString());
        int num = 0;
        try {
            SRole sRole = new SRole();
            this.beanCopy((Object)inSRoleVo, (Object)sRole);
            num = this.sRoleDao.insertSRole(sRole);
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u6761\u6570\u4e3a:" + num);
        return num;
    }

    @Override
    public int deleteByPk(SRoleVO inSRoleVo) {
        logger.debug("\u5f53\u524d\u5220\u9664\u6570\u636e\u6761\u4ef6\u4e3a:" + (Object)((Object)inSRoleVo));
        int num = 0;
        try {
            SRole sRole = new SRole();
            this.beanCopy((Object)inSRoleVo, (Object)sRole);
            num = this.sRoleDao.deleteByPk(sRole);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + (Object)((Object)inSRoleVo) + "\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public int updateByPk(SRoleVO inSRoleVo) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u4e3a:" + inSRoleVo.toString());
        int num = 0;
        try {
            SRole sRole = new SRole();
            this.beanCopy((Object)inSRoleVo, (Object)sRole);
            num = this.sRoleDao.updateByPk(sRole);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + (Object)((Object)inSRoleVo) + "\u4fee\u6539\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public SRoleVO queryByPk(SRoleVO inSRoleVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u53c2\u6570\u4fe1\u606f\u4e3a:" + (Object)((Object)inSRoleVo));
        try {
            SRole querySRole = new SRole();
            this.beanCopy((Object)inSRoleVo, (Object)querySRole);
            SRole queryRslSRole = this.sRoleDao.queryByPk(querySRole);
            if (Objects.nonNull((Object)queryRslSRole)) {
                SRoleVO outSRoleVo = (SRoleVO)((Object)this.beanCopy((Object)queryRslSRole, (Object)new SRoleVO()));
                logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a:" + outSRoleVo.toString());
                return outSRoleVo;
            }
            logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
        }
        return null;
    }

    @Override
    public List<SRoleVO> queryAllOwner(SRoleVO sRoleVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:" + sRoleVo.toString());
        List list = Collections.emptyList();
        try {
            List<SRole> sRoles = this.sRoleDao.queryAllOwnerByPage(sRoleVo);
            logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + sRoles.size());
            this.pageSet(sRoles, sRoleVo);
            list = this.beansCopy(sRoles, SRoleVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<SRoleVO> queryAllCurrOrg(SRoleVO sRoleVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:" + sRoleVo.toString());
        List<SRole> sRoles = this.sRoleDao.queryAllCurrOrgByPage(sRoleVo);
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + sRoles.size());
        List list = Collections.emptyList();
        try {
            this.pageSet(sRoles, sRoleVo);
            list = this.beansCopy(sRoles, SRoleVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<SRoleVO> queryAllCurrDownOrg(SRoleVO sRoleVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u53ca\u4ee5\u4e0b\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:" + sRoleVo.toString());
        List<SRole> sRoles = this.sRoleDao.queryAllCurrDownOrgByPage(sRoleVo);
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u53ca\u4ee5\u4e0b\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + sRoles.size());
        List list = Collections.emptyList();
        try {
            this.pageSet(sRoles, sRoleVo);
            list = this.beansCopy(sRoles, SRoleVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<SRoleVO> queryAllByCondition(SRoleVO sRoleVo) {
        List list = Collections.emptyList();
        try {
            logger.debug("\u5f53\u524d\u67e5\u8be2\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:" + sRoleVo.toString());
            SRole sRole = new SRole();
            this.beanCopy((Object)sRoleVo, (Object)sRole);
            List<SRole> sRoles = this.sRoleDao.queryAllByCondition(sRole);
            logger.debug("\u5f53\u524d\u67e5\u8be2\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + sRoles.size());
            list = this.beansCopy(sRoles, SRoleVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<SRoleVO> queryUserRoleList(SRoleVO sRoleVo) {
        List list = Collections.emptyList();
        try {
            logger.debug("\u5f53\u524d\u67e5\u8be2\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:" + sRoleVo.toString());
            List<SRole> sRoles = this.sRoleDao.queryUserRoleList(sRoleVo);
            logger.debug("\u5f53\u524d\u67e5\u8be2\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + sRoles.size());
            list = this.beansCopy(sRoles, SRoleVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<SRoleVO> queryAllFilterList(List<String> roleNos) {
        List list = Collections.emptyList();
        try {
            logger.debug("\u5f53\u524d\u67e5\u8be2\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:" + JSON.toJSONString(roleNos));
            List<SRole> sRoles = this.sRoleDao.queryAllFilterList(roleNos);
            logger.debug("\u5f53\u524d\u67e5\u8be2\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + sRoles.size());
            list = this.beansCopy(sRoles, SRoleVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }
}

