/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.ssm.web.cas;

import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.core.vo.UserInfo;
import com.irdstudio.sdk.beans.web.controller.AbstractController;
import com.irdstudio.sdk.ssm.session.SessionManager;
import com.irdstudio.sdk.ssm.web.filter.E4ACasFilter;
import javax.servlet.Filter;
import org.jasig.cas.client.boot.configuration.CasClientConfiguration;
import org.jasig.cas.client.boot.configuration.CasClientConfigurer;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Configuration
@ConditionalOnExpression(value="'${e4a.cas.enable}'=='true'")
public class CasConfiguration {
    @Value(value="${e4a.sessionTimeOut:3600000}")
    private int sessionTimeOut;
    @Value(value="${cas.server-url-prefix:}")
    private String casServerUrl;

    @Bean
    @ConditionalOnMissingBean(name={"sessionManager"})
    public SessionManager sessionManager() {
        SessionManager sessionManager = new SessionManager();
        sessionManager.setSessionTimeOut(this.sessionTimeOut);
        return sessionManager;
    }

    public Filter e4aCasFilter() {
        E4ACasFilter e4AFilter = new E4ACasFilter();
        return e4AFilter;
    }

    @Bean
    @ConditionalOnExpression(value="'${e4a.cas.enable}'=='true'")
    public FilterRegistrationBean e4aCasFilterReg() {
        FilterRegistrationBean reg = new FilterRegistrationBean();
        reg.setFilter(this.e4aCasFilter());
        reg.addInitParameter("casServerUrl", this.casServerUrl);
        reg.addUrlPatterns(new String[]{"/*"});
        reg.setName("e4aFilter");
        reg.setOrder(2);
        return reg;
    }

    @ConditionalOnExpression(value="'${e4a.cas.enable}'=='true'")
    @RestController
    @RequestMapping(value={"/api"})
    public static class UserInfoController
    extends AbstractController {
        @RequestMapping(value={"/s/user/info"}, method={RequestMethod.GET})
        @ResponseBody
        public ResponseData<UserInfo> getSessionUserInfo() {
            ResponseData data = null;
            try {
                UserInfo userInfo = this.getUserInfo();
                data = this.getResponseData(userInfo);
            }
            catch (Exception e) {
                logger.error("\u83b7\u53d6session\u767b\u5f55\u4fe1\u606f\u5931\u8d25" + e.getMessage(), (Throwable)e);
                this.httpResponse.setStatus(401);
            }
            return data;
        }
    }

    @Configuration(value="EnableCas")
    @ConditionalOnExpression(value="'${e4a.cas.enable}'=='true'")
    @Import(value={CasClientConfiguration.class})
    public static class EnableCas
    implements CasClientConfigurer {
        @Value(value="${e4a.allowUrl:**/**/*}")
        private String allowUrl;
        @Value(value="${e4a.ignore-url-pattern-type:com.irdstudio.sdk.ssm.web.cas.AntPathMatcherStrategy}")
        private String ignoreUrlPatternType;

        public void configureAuthenticationFilter(FilterRegistrationBean authenticationFilter) {
            authenticationFilter.getInitParameters().put("ignoreUrlPatternType", this.ignoreUrlPatternType);
            authenticationFilter.getInitParameters().put("ignorePattern", this.allowUrl);
        }
    }
}

