/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.ssm.web.audit;

import com.alibaba.fastjson.JSON;
import com.irdstudio.sdk.admin.service.facade.SAuditOperService;
import com.irdstudio.sdk.admin.service.vo.SAuditOperVO;
import com.irdstudio.sdk.beans.core.spring.ExpressionUtil;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.vo.BaseInfo;
import com.irdstudio.sdk.beans.core.vo.UserInfo;
import com.irdstudio.sdk.ssm.web.audit.AuditOperate;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
public class AuditOperateAspect {
    private static final Logger logger = LoggerFactory.getLogger(AuditOperateAspect.class);
    @Autowired
    private SAuditOperService sAuditOperService;
    @Autowired
    private HttpSession session;

    @Pointcut(value="@annotation(com.irdstudio.sdk.ssm.web.audit.AuditOperate)")
    public void pointcut() {
    }

    @Around(value="pointcut() && @annotation(auditOperate)")
    public Object auditOperateAround(ProceedingJoinPoint pjp, AuditOperate auditOperate) throws Throwable {
        long startTime = Calendar.getInstance().getTimeInMillis();
        try {
            Object result = pjp.proceed();
            long endTime = Calendar.getInstance().getTimeInMillis();
            long costTime = endTime - startTime;
            this.recordOperate(pjp, auditOperate, costTime, null);
            return result;
        }
        catch (Throwable e) {
            long endTime = Calendar.getInstance().getTimeInMillis();
            long costTime = endTime - startTime;
            this.recordOperate(pjp, auditOperate, costTime, e);
            throw e;
        }
    }

    public void recordOperate(ProceedingJoinPoint pjp, AuditOperate auditOperate, long costTime, Throwable e) {
        logger.debug("\u52a8\u6001\u5207\u9762 \u7c7b\u540d\uff1a{}-{}", (Object)pjp.getSignature().getDeclaringType().getSimpleName(), (Object)pjp.getSignature().getName());
        try {
            Object[] args = pjp.getArgs();
            SAuditOperVO logVo = new SAuditOperVO();
            logVo.setOperType(auditOperate.action().getCode());
            logVo.setOperAuditObj(auditOperate.auditType());
            logVo.setOperBizkey(this.parseExp(auditOperate.bizKey(), args, (JoinPoint)pjp, auditOperate));
            if (StringUtils.isBlank((CharSequence)auditOperate.text()) && args != null && args.length > 0) {
                for (Object arg : args) {
                    if (!(arg instanceof BaseInfo)) continue;
                    BaseInfo baseInfo = (BaseInfo)arg;
                    if (StringUtils.isNotBlank((CharSequence)baseInfo.getDlText())) {
                        logVo.setOperDesc(baseInfo.getDlText());
                        continue;
                    }
                    List diffList = baseInfo.diff();
                    ArrayList<String> sb = new ArrayList<String>();
                    if (CollectionUtils.isNotEmpty((Collection)diffList)) {
                        for (BaseInfo.DiffProp diff : diffList) {
                            sb.add(String.format("%s\u4e86 %s %s\u4e3a%s", auditOperate.action().getName(), baseInfo.diffPrefix(), diff.getPropName(), diff.getNewVal()));
                        }
                    }
                    logVo.setOperDesc(StringUtils.join(sb, (String)"\n"));
                }
            } else {
                logVo.setOperDesc(this.parseExp(auditOperate.text(), args, (JoinPoint)pjp, auditOperate));
            }
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            String ip = AuditOperateAspect.getIpAddress(request);
            logVo.setOperIp(ip);
            String client = AuditOperateAspect.getClientInfo(request);
            logVo.setOperClient(client);
            logVo.setOperCostTime(new BigDecimal(costTime));
            if (e == null) {
                logVo.setOperResult(OperResult.Success.getCode());
            } else {
                logVo.setOperResult(OperResult.Failure.getCode());
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                String errorMsg = sw.getBuffer().toString();
                if (errorMsg != null && errorMsg.length() > 60000) {
                    errorMsg = StringUtils.substring((String)errorMsg, (int)0, (int)60000);
                }
                logVo.setOperError(errorMsg);
            }
            logVo.setOperAudit("A");
            String date = CurrentDateUtil.getTodayDate();
            String time = CurrentDateUtil.getCurrentTime();
            logVo.setOperDate(date);
            logVo.setOperTime(time);
            UserInfo userInfo = this.getUserInfo();
            if (userInfo != null) {
                logVo.setOperUser(userInfo.getUserId());
                logVo.setOperUserName(userInfo.getUserName());
            }
            this.sAuditOperService.insert((Object)logVo);
        }
        catch (Exception exception) {
            logger.error("\u5ba1\u8ba1\u64cd\u4f5c\u5207\u9762 \u7c7b\u540d\uff1a{}-{} \u8bb0\u5f55\u5931\u8d25 {}", new Object[]{pjp.getSignature().getDeclaringType().getSimpleName(), pjp.getSignature().getName(), exception.getMessage(), exception});
        }
    }

    public static String getClientInfo(HttpServletRequest request) {
        String client = request.getHeader("User-Agent");
        return client;
    }

    public static String getIpAddress(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    private String parseExp(String exp, Object[] args, JoinPoint pjp, AuditOperate dynamicLog) {
        if (StringUtils.isBlank((CharSequence)exp)) {
            return "";
        }
        try {
            HashMap<String, Object> root = new HashMap<String, Object>();
            root.put("args", args);
            root.put("joinPoint", pjp);
            root.put("dynamicLog", dynamicLog);
            HashMap<String, Method> registerFunc = new HashMap<String, Method>();
            registerFunc.put("transformCode", AuditOperateAspect.class.getMethod("transformCode", String.class, String.class, String.class));
            String result = ExpressionUtil.parse((String)exp, root, registerFunc);
            return result;
        }
        catch (Exception e) {
            logger.error("\u8868\u8fbe\u5f0f\u89e3\u6790\u5931\u8d25 {} {}", (Object)exp, (Object)e.getMessage());
            return exp;
        }
    }

    public final UserInfo getUserInfo() {
        UserInfo userInfo = null;
        try {
            userInfo = (UserInfo)this.session.getAttribute("userInfo");
        }
        catch (ClassCastException e) {
            Object obj = this.session.getAttribute("userInfo");
            String json = JSON.toJSONString((Object)obj);
            userInfo = (UserInfo)JSON.parseObject((String)json, UserInfo.class);
        }
        return userInfo;
    }

    public static String transformCode(String type, String module, String code) {
        String clazz = "";
        clazz = StringUtils.equals((CharSequence)module, (CharSequence)"rdm") ? "com.irdstudio.allinrdm.rdm.types." + type : type;
        try {
            Class<?> enumClazz = Class.forName(clazz);
            Method nameByCode = enumClazz.getMethod("nameByCode", String.class);
            return (String)nameByCode.invoke(null, code);
        }
        catch (Exception e) {
            logger.error("\u6267\u884c\u5f02\u5e38 transformCode {} {} {} {}", new Object[]{type, module, code});
            return code;
        }
    }

    public static enum OperResult {
        Success("S", "\u6210\u529f"),
        Failure("F", "\u5931\u8d25");

        private String code;
        private String name;

        private OperResult(String code, String name) {
            this.code = code;
            this.name = name;
        }

        public String getCode() {
            return this.code;
        }

        public String getName() {
            return this.name;
        }
    }
}

