/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.admin.service.dynamic;

import com.alibaba.fastjson.JSON;
import com.irdstudio.sdk.admin.service.dynamic.DynamicLog;
import com.irdstudio.sdk.admin.service.facade.SDynamicLogService;
import com.irdstudio.sdk.admin.service.vo.SDynamicLogVO;
import com.irdstudio.sdk.beans.core.spring.ExpressionUtil;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.vo.BaseInfo;
import com.irdstudio.sdk.beans.core.vo.UserInfo;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Aspect
public class DynamicLogAspect {
    private static final Logger logger = LoggerFactory.getLogger(DynamicLogAspect.class);
    @Autowired
    protected SDynamicLogService sDynamicLogService;
    @Autowired
    private HttpSession session;

    @Pointcut(value="@annotation(com.irdstudio.sdk.admin.service.dynamic.DynamicLog)")
    public void pointcut() {
    }

    @After(value="pointcut() && @annotation(dynamicLog)")
    public void dynamicLogging(JoinPoint pjp, DynamicLog dynamicLog) throws Throwable {
        logger.debug("\u52a8\u6001\u5207\u9762 \u7c7b\u540d\uff1a{}-{}", (Object)pjp.getSignature().getDeclaringType().getSimpleName(), (Object)pjp.getSignature().getName());
        try {
            Object[] args = pjp.getArgs();
            SDynamicLogVO logVo = new SDynamicLogVO();
            logVo.setDlType1(dynamicLog.moduleCode());
            logVo.setDlType2(dynamicLog.dynamicType().getCode());
            logVo.setDlBizkey(this.parseExp(dynamicLog.bizKey(), args, pjp, dynamicLog));
            if (StringUtils.isBlank((CharSequence)dynamicLog.text()) && args != null && args.length > 0) {
                for (Object arg : args) {
                    if (!(arg instanceof BaseInfo)) continue;
                    BaseInfo baseInfo = (BaseInfo)arg;
                    if (StringUtils.isNotBlank((CharSequence)baseInfo.getDlText())) {
                        logVo.setDlText(this.parseExp(baseInfo.getDlText(), args, pjp, dynamicLog));
                    } else {
                        List diffList = baseInfo.diff();
                        ArrayList<String> sb = new ArrayList<String>();
                        if (CollectionUtils.isNotEmpty((Collection)diffList)) {
                            for (BaseInfo.DiffProp diff : diffList) {
                                sb.add(String.format("%s\u4e86 %s %s\u4e3a%s", dynamicLog.action().getName(), baseInfo.diffPrefix(), diff.getPropName(), diff.getNewVal()));
                            }
                        }
                        logVo.setDlText(StringUtils.join(sb, (String)"\n"));
                    }
                    List indexList = baseInfo.findIndexKeyInfo();
                    if (!CollectionUtils.isNotEmpty((Collection)indexList)) continue;
                    indexList = indexList.stream().map(key -> String.format("#%s#", key)).collect(Collectors.toList());
                    logVo.setIndexKey(StringUtils.join(indexList, (String)","));
                }
            } else {
                logVo.setDlText(this.parseExp(dynamicLog.text(), args, pjp, dynamicLog));
            }
            String date = CurrentDateUtil.getTodayDate();
            String time = CurrentDateUtil.getCurrentTime();
            logVo.setDlDate(date);
            logVo.setDlTime(time);
            UserInfo userInfo = this.getUserInfo();
            if (userInfo != null) {
                logVo.setUserId(userInfo.getUserId());
            }
            this.sDynamicLogService.insert((Object)logVo);
        }
        catch (Exception e) {
            logger.error("\u52a8\u6001\u5207\u9762 \u7c7b\u540d\uff1a{}-{} \u8bb0\u5f55\u5931\u8d25 {}", new Object[]{pjp.getSignature().getDeclaringType().getSimpleName(), pjp.getSignature().getName(), e.getMessage(), e});
        }
    }

    private String parseExp(String exp, Object[] args, JoinPoint pjp, DynamicLog dynamicLog) {
        if (StringUtils.isBlank((CharSequence)exp)) {
            return "";
        }
        try {
            HashMap<String, Object> root = new HashMap<String, Object>();
            root.put("args", args);
            root.put("joinPoint", pjp);
            root.put("dynamicLog", dynamicLog);
            HashMap<String, Method> registerFunc = new HashMap<String, Method>();
            registerFunc.put("transformCode", DynamicLogAspect.class.getMethod("transformCode", String.class, String.class, String.class));
            String result = ExpressionUtil.parse((String)exp, root, registerFunc);
            return result;
        }
        catch (Exception e) {
            logger.error("\u8868\u8fbe\u5f0f\u89e3\u6790\u5931\u8d25 {} {}", (Object)exp, (Object)e.getMessage());
            return exp;
        }
    }

    public final UserInfo getUserInfo() {
        UserInfo userInfo = null;
        try {
            userInfo = (UserInfo)this.session.getAttribute("userInfo");
        }
        catch (ClassCastException e) {
            Object obj = this.session.getAttribute("userInfo");
            String json = JSON.toJSONString((Object)obj);
            userInfo = (UserInfo)JSON.parseObject((String)json, UserInfo.class);
        }
        return userInfo;
    }

    public static String transformCode(String type, String module, String code) {
        String clazz = "";
        clazz = StringUtils.equals((CharSequence)module, (CharSequence)"rdm") ? "com.irdstudio.allinrdm.rdm.portal.types." + type : type;
        try {
            Class<?> enumClazz = Class.forName(clazz);
            Method nameByCode = enumClazz.getMethod("nameByCode", String.class);
            return (String)nameByCode.invoke(null, code);
        }
        catch (Exception e) {
            logger.error("\u6267\u884c\u5f02\u5e38 transformCode {} {} {} {}", new Object[]{type, module, code});
            return code;
        }
    }
}

