/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.ssm.web.filter;

import com.alibaba.fastjson.JSONObject;
import com.irdstudio.sdk.admin.dao.domain.SUser;
import com.irdstudio.sdk.admin.service.vo.AuthInfoVO;
import com.irdstudio.sdk.beans.core.util.MD5Util;
import com.irdstudio.sdk.beans.core.util.StringUtil;
import com.irdstudio.sdk.beans.core.util.URLUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.ssm.session.SessionManager;
import com.irdstudio.sdk.ssm.util.CookiesUtil;
import com.irdstudio.sdk.ssm.util.GsonUtils;
import com.irdstudio.sdk.ssm.vo.UserInfo;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.validation.Assertion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class E4ACasFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(E4ACasFilter.class);
    private SessionManager sessionManager;
    private String casServerUrl;

    public void init(FilterConfig filterConfig) throws ServletException {
        WebApplicationContext applicationcontext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)filterConfig.getServletContext());
        this.sessionManager = (SessionManager)applicationcontext.getBean("sessionManager", SessionManager.class);
        this.casServerUrl = filterConfig.getInitParameter("casServerUrl");
    }

    public void doFilter(ServletRequest req, ServletResponse rep, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)rep;
        response.setHeader("Content-type", "text/html;charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
        String requestPath = request.getServletPath();
        if (StringUtils.endsWithAny((CharSequence)requestPath, (CharSequence[])new CharSequence[]{".js", ".css", ".png", ".git", ".jpg", ".ico", ".ttf"})) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (requestPath.endsWith("/api/logout")) {
            request.getSession().invalidate();
            String service = request.getQueryString();
            String redirectUrl = String.format("%s/logout?service=%s/login?%s", this.casServerUrl, this.casServerUrl, service);
            ResponseData data = new ResponseData();
            data.createData((Object)redirectUrl, "0", "\u8df3\u8f6c", true);
            String outputmessage = GsonUtils.toJson(data);
            try (PrintWriter rsp = response.getWriter();){
                rsp.write(outputmessage);
            }
            return;
        }
        AuthInfoVO authInfo = null;
        HttpSession session = request.getSession();
        String sessionId = session.getId();
        UserInfo userInfo = this.sessionManager.getLoginInfo(sessionId);
        String cookieSignUserId = this.cookieSingUserId(request);
        String fromWx = request.getHeader("ssoclient");
        if (userInfo != null && !StringUtils.equals((CharSequence)userInfo.getUserId(), (CharSequence)cookieSignUserId) && StringUtils.isBlank((CharSequence)fromWx)) {
            session.removeAttribute("_const_cas_assertion_");
            session.removeAttribute("userInfo");
            response.sendRedirect(request.getRequestURI());
            userInfo = null;
            return;
        }
        if (userInfo == null) {
            try {
                Assertion assertion = (Assertion)session.getAttribute("_const_cas_assertion_");
                if (assertion != null) {
                    this.getCasTGCToAttr(request);
                    AttributePrincipal principal = assertion.getPrincipal();
                    if (!(principal == null || (userInfo = this.sessionManager.getLoginInfo(sessionId)) != null && StringUtils.equals((CharSequence)userInfo.getUserId(), (CharSequence)principal.getName()))) {
                        AuthInfoVO authInfoVO = new AuthInfoVO();
                        authInfoVO.setSessionId(sessionId);
                        authInfoVO.setUsercode(principal.getName());
                        authInfo = this.casGetUserInfo(authInfoVO, (Principal)principal);
                        if (authInfo != null && Objects.nonNull(authInfo.getUserInfo())) {
                            CookiesUtil.addCookie(response, "ssoclient", authInfo.getSessionId(), -1);
                            CookiesUtil.addCookie(response, "ssottp", String.valueOf(authInfo.getTimestamp()), -1);
                            CookiesUtil.addCookie(response, "ssomd5", authInfo.getMd5(), -1);
                            CookiesUtil.addCookie(response, "signUserId", authInfo.getUsercode(), -1);
                            CookiesUtil.addCookie(response, "signUserName", authInfo.getUserInfo().getUserName(), -1);
                            this.sessionManager.setLoginInfo(authInfo.getUserInfo(), request);
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error("sso client request token check fail: " + e.getMessage(), (Throwable)e);
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public AuthInfoVO casGetUserInfo(AuthInfoVO authInfoVO, Principal principal) {
        AuthInfoVO authInfo = new AuthInfoVO();
        try {
            AttributePrincipal attributePrincipal = (AttributePrincipal)principal;
            Map principalAttributes = attributePrincipal.getAttributes();
            SUser user = new SUser();
            user.setActorno(authInfoVO.getUsercode());
            user.setActorname(MapUtils.getString((Map)principalAttributes, (Object)"actorname"));
            user.setUsermail(MapUtils.getString((Map)principalAttributes, (Object)"email"));
            user.setState(MapUtils.getString((Map)principalAttributes, (Object)"state"));
            user.setOrgid(MapUtils.getString((Map)principalAttributes, (Object)"orgCode"));
            user.setTelnum(MapUtils.getString((Map)principalAttributes, (Object)"telnum"));
            if (user != null && StringUtil.isNotEmpty((String)user.getActorno())) {
                logger.debug("\u67e5\u8be2\u7528\u6237\u6210\u529f\uff01");
                long timestamp = System.currentTimeMillis();
                UserInfo userInfo = new UserInfo();
                userInfo.setUserId(user.getActorno());
                userInfo.setUserName(user.getActorname());
                userInfo.setAllowOperSys(user.getAllowopersys());
                String jsonStr = JSONObject.toJSONString((Object)userInfo);
                String md5 = MD5Util.getMD5ofStr((String)URLUtil.md5((String)jsonStr, (Long)timestamp, (String)"123456"));
                authInfo.setUsercode(authInfoVO.getUsercode());
                authInfo.setSessionId(authInfoVO.getSessionId());
                authInfo.setTimestamp(timestamp);
                authInfo.setMd5(md5);
                authInfo.setUserInfo(userInfo);
            }
        }
        catch (Exception e) {
            logger.error("\u767b\u5f55\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage(), (Throwable)e);
        }
        return authInfo;
    }

    public void destroy() {
    }

    private void getCasTGCToAttr(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!StringUtils.equals((CharSequence)"TGC", (CharSequence)cookie.getName())) continue;
                request.getSession().setAttribute("TGC", (Object)cookie.getValue());
            }
        }
    }

    public static Map<String, String> parseQuerystring(String queryString) {
        String[] params;
        HashMap<String, String> map = new HashMap<String, String>();
        if (queryString == null || queryString.equals("")) {
            return map;
        }
        for (String param : params = queryString.split("&")) {
            try {
                String[] keyValuePair = param.split("=", 2);
                String name = URLDecoder.decode(keyValuePair[0], "UTF-8");
                if (name == "") continue;
                String value = keyValuePair.length > 1 ? URLDecoder.decode(keyValuePair[1].replaceAll("%20", "%2b"), "UTF-8") : "";
                map.put(name, value);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return map;
    }

    public String cookieSingUserId(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!StringUtils.equals((CharSequence)"signUserId", (CharSequence)cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    public static void main(String[] args) {
        String requestPath = "/static/css/te/test.jpg";
        String passedPath = "/static/**/*.jpg";
        AntPathMatcher matcher = new AntPathMatcher();
        System.out.println(matcher.match(passedPath, requestPath));
    }
}

