/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.ssm.web.filter;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.client.configuration.ConfigurationKeys;
import org.jasig.cas.client.validation.Cas30ProxyReceivingTicketValidationFilter;

public class Cas30TicketValidationFilter
extends Cas30ProxyReceivingTicketValidationFilter {
    private List<String> allowHost;

    protected void initInternal(FilterConfig filterConfig) throws ServletException {
        super.initInternal(filterConfig);
        String allowHostStr = filterConfig.getInitParameter("allowHost");
        if (StringUtils.isNotBlank((CharSequence)allowHostStr)) {
            String[] allowHostArr = StringUtils.split((String)allowHostStr, (String)";");
            this.allowHost = Arrays.asList(allowHostArr);
        } else {
            this.allowHost = Collections.emptyList();
        }
    }

    public String constructServiceUrl(HttpServletRequest request, HttpServletResponse response) {
        String modifiedServiceUrl = super.constructServiceUrl(request, response);
        if (this.isAllowHost(request)) {
            String allowHost = this.getAllowHost(request);
            String serviceName = this.getString(ConfigurationKeys.SERVER_NAME);
            String scheme = StringUtils.startsWith((CharSequence)serviceName, (CharSequence)"https://") ? "https://" : "http://";
            String endString = StringUtils.endsWith((CharSequence)serviceName, (CharSequence)"/") ? "/" : "";
            modifiedServiceUrl = StringUtils.replaceOnce((String)modifiedServiceUrl, (String)serviceName, (String)String.format("%s%s%s", scheme, allowHost, endString));
            return modifiedServiceUrl;
        }
        return modifiedServiceUrl;
    }

    private boolean isAllowHost(HttpServletRequest request) {
        String host = request.getHeader("X-Real-IP");
        return this.allowHost.contains(host);
    }

    private String getAllowHost(HttpServletRequest request) {
        return request.getHeader("X-Real-IP");
    }
}

