/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.admin.api.rest;

import com.irdstudio.sdk.admin.service.facade.SModuleShortcutService;
import com.irdstudio.sdk.admin.service.vo.SModuleShortcutVO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.BaseController;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class SModuleShortcutController
extends BaseController<SModuleShortcutVO, SModuleShortcutService> {
    @RequestMapping(value={"/api/s/module/shortcuts"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SModuleShortcutVO>> querySModuleShortcutAll(SModuleShortcutVO dto) {
        List outputVo = ((SModuleShortcutService)this.getService()).queryListByPage((Object)dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/s/module/shortcuts/usage"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SModuleShortcutVO>> queryUsageListByPage(SModuleShortcutVO dto) {
        List<SModuleShortcutVO> outputVo = ((SModuleShortcutService)this.getService()).queryUsageListByPage(dto);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/s/module/shortcut/{shortcutId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<SModuleShortcutVO> queryByPk(@PathVariable(value="shortcutId") String shortcutId) {
        SModuleShortcutVO inVo = new SModuleShortcutVO();
        inVo.setShortcutId(shortcutId);
        SModuleShortcutVO outputVo = (SModuleShortcutVO)((Object)((SModuleShortcutService)this.getService()).queryByPk((Object)inVo));
        return this.getResponseData((Object)outputVo);
    }

    @RequestMapping(value={"/api/s/module/shortcut"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody SModuleShortcutVO inSModuleShortcutVO) {
        int outputVo = ((SModuleShortcutService)this.getService()).deleteByPk((Object)inSModuleShortcutVO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/s/module/shortcut/cancel"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> cancelCollect(@RequestBody SModuleShortcutVO inSModuleShortcutVO) {
        inSModuleShortcutVO.setShortcutUser(this.getUserInfo().getUserId());
        int outputVo = ((SModuleShortcutService)this.getService()).cancelCollect(inSModuleShortcutVO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/s/module/shortcut"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody SModuleShortcutVO inSModuleShortcutVO) {
        int outputVo = ((SModuleShortcutService)this.getService()).updateByPk((Object)inSModuleShortcutVO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/s/module/shortcut"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertSModuleShortcut(@RequestBody SModuleShortcutVO inSModuleShortcutVO) {
        String now = CurrentDateUtil.getTodayDateEx2();
        String userId = this.getUserInfo().getUserId();
        if (StringUtils.isBlank((CharSequence)inSModuleShortcutVO.getShortcutId())) {
            inSModuleShortcutVO.setShortcutId(UUIDUtil.getShortUUID());
        }
        inSModuleShortcutVO.setShortcutUser(userId);
        inSModuleShortcutVO.setShortcutOpTime(now);
        int outputVo = ((SModuleShortcutService)this.getService()).insert((Object)inSModuleShortcutVO);
        return this.getResponseData(outputVo);
    }
}

