/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.plugins.core.plugin.excel.export;

import com.irdstudio.sdk.plugins.core.plugin.excel.export.ExcelTemplateBuilder;
import com.irdstudio.sdk.plugins.core.plugin.excel.export.ExportSectionXmlConf;
import com.irdstudio.sdk.plugins.core.plugin.excel.export.ExportWriterXmlConf;
import com.irdstudio.sdk.plugins.core.tinycore.jdbc.executor.SafeReleaseUtil;
import com.irdstudio.sdk.plugins.core.tinycore.log.ILogger;
import com.irdstudio.sdk.plugins.core.tinycore.log.TLogger;
import com.irdstudio.sdk.plugins.core.utils.parse.VariableParserUtil;
import com.irdstudio.sdk.plugins.core.utils.vo.VariableValue;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.math.NumberUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class ExcelExportExecutor {
    private String xmlConfigureFile = "";
    private VariableValue vv = null;
    private String templateURL = "";
    private String toFileURL = "";
    private List<ExportSectionXmlConf> esxfList = null;
    private ILogger logger = null;
    private Connection conn = null;

    public ExcelExportExecutor(String xmlConfigureFile, VariableValue vv, Connection conn) {
        this.xmlConfigureFile = xmlConfigureFile;
        this.vv = vv;
        this.logger = TLogger.getLogger("ExcelExport");
        this.conn = conn;
    }

    public ExcelExportExecutor(String xmlConfigureFile, VariableValue vv, Connection conn, ILogger logger) {
        this.xmlConfigureFile = xmlConfigureFile;
        this.vv = vv;
        this.logger = logger;
        this.conn = conn;
    }

    public boolean run() {
        if (this.doInitialize()) {
            return this.doExport();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doExport() {
        boolean flag = true;
        ExcelTemplateBuilder excel = new ExcelTemplateBuilder(this.templateURL);
        for (int i = 0; i < this.esxfList.size(); ++i) {
            ExportSectionXmlConf esxf = this.esxfList.get(i);
            this.logger.info(esxf.getType() + ":" + esxf.getDataSrc());
            Statement st = null;
            ResultSet rs = null;
            try {
                st = this.conn.createStatement();
                rs = st.executeQuery(this.toParseSysVariable(esxf.getDataSrc()));
                int rowIndex = 0;
                while (rs.next()) {
                    for (int j = 0; j < esxf.getWriterList().size(); ++j) {
                        ExportWriterXmlConf ewxf = esxf.getWriterList().get(j);
                        excel.writeIn(rs.getString(ewxf.getValueField()), ewxf.getSheetNo(), ewxf.getRowNo() + rowIndex, ewxf.getCellNo());
                    }
                    ++rowIndex;
                    if ("repeat".equalsIgnoreCase(esxf.getType())) continue;
                }
            }
            catch (SQLException e) {
                try {
                    this.logger.error(e.getMessage());
                    flag = false;
                }
                catch (Throwable throwable) {
                    SafeReleaseUtil.close(rs, st, null);
                    throw throwable;
                }
                SafeReleaseUtil.close(rs, st, null);
                continue;
            }
            SafeReleaseUtil.close(rs, st, null);
            continue;
        }
        excel.saveAsTargetExcel(this.toFileURL);
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doInitialize() {
        String xmlConfigFile = this.xmlConfigureFile;
        this.logger.info(xmlConfigFile);
        boolean flag = true;
        if (xmlConfigFile != null && !"".equals(xmlConfigFile)) {
            SAXBuilder sb = new SAXBuilder();
            Document doc = null;
            try {
                this.esxfList = new ArrayList<ExportSectionXmlConf>();
                doc = sb.build((InputStream)new FileInputStream(xmlConfigFile));
                Element root = doc.getRootElement();
                this.templateURL = root.getAttributeValue("templateURL");
                this.toFileURL = root.getAttributeValue("toFile");
                this.templateURL = this.toParseSysVariable(this.templateURL);
                this.toFileURL = this.toParseSysVariable(this.toFileURL);
                List childs = root.getChildren();
                for (Element element : childs) {
                    if (!"export".equalsIgnoreCase(element.getName())) continue;
                    this.logger.info("\u52a0\u8f7dExport\u914d\u7f6e...");
                    this.esxfList.add(this.loadExportSection(element));
                }
            }
            catch (FileNotFoundException e) {
                this.logger.error("\u6587\u4ef6" + xmlConfigFile + "\u6ca1\u6709\u627e\u5230!");
                this.logger.error(e.getMessage());
                flag = false;
            }
            catch (JDOMException e) {
                this.logger.error("\u8bfbXML\u6587\u4ef6\u5f02\u5e38,\u8bf7\u68c0\u67e5XML\u6587\u4ef6!");
                this.logger.error(e.getMessage());
                flag = false;
            }
            catch (IOException e) {
                this.logger.error("\u8bfbXML\u6587\u4ef6\u5f02\u5e38,\u8bf7\u68c0\u67e5XML\u6587\u4ef6!");
                this.logger.error(e.getMessage());
            }
            finally {
                doc = null;
            }
        }
        return flag;
    }

    private ExportSectionXmlConf loadExportSection(Element element) {
        ExportSectionXmlConf export = new ExportSectionXmlConf();
        export.setDataSrc(element.getAttributeValue("dataSrc"));
        export.setType(element.getAttributeValue("type"));
        export.setDataSrc(element.getAttributeValue("dataSrc"));
        if (element.getChildren().size() > 0) {
            List childs = element.getChildren();
            for (Element tmpElement : childs) {
                if (!"write".equalsIgnoreCase(tmpElement.getName())) continue;
                ExportWriterXmlConf writer = new ExportWriterXmlConf();
                writer.setSheetNo(NumberUtils.toInt((String)tmpElement.getAttributeValue("sheet")));
                writer.setRowNo(NumberUtils.toInt((String)tmpElement.getAttributeValue("row")));
                writer.setCellNo(NumberUtils.toInt((String)tmpElement.getAttributeValue("cell")));
                writer.setValueField(tmpElement.getAttributeValue("value"));
                writer.setDesc(tmpElement.getAttributeValue("desc"));
                export.addWriter(writer);
            }
        }
        return export;
    }

    public String toParseSysVariable(String str) {
        if (str == null || "".equals(str)) {
            return "";
        }
        return VariableParserUtil.parseString(str, this.vv);
    }
}

