/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.plugins.core.plugin.hsf;

import com.irdstudio.sdk.plugins.core.plugin.hsf.PluginServiceConf;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class PluginServiceConfDao {
    Connection conn = null;

    public PluginServiceConfDao(Connection conn) {
        this.conn = conn;
    }

    public PluginServiceConf queryWithKeys(String pluginConfId) throws SQLException {
        PluginServiceConf sc = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM plugin_service_conf WHERE plugin_conf_id=?");
            ps.setString(1, pluginConfId);
            rs = ps.executeQuery();
            if (rs.next()) {
                sc = new PluginServiceConf();
                sc.setPluginConfId(rs.getString("plugin_conf_id"));
                sc.setConfSort(rs.getInt("conf_sort"));
                sc.setServiceId(rs.getString("service_id"));
                sc.setServiceName(rs.getString("service_name"));
                sc.setServiceInterface(rs.getString("service_interface"));
                sc.setServiceMethod(rs.getString("service_method"));
                sc.setVersion(rs.getString("version"));
                sc.setGroup(rs.getString("service_group"));
                sc.setTimeout(rs.getBigDecimal("timeout"));
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryPluginServiceConfWithKeys is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return sc;
    }

    public List<PluginServiceConf> queryWithCond(String szCondition, String szOrderBy) throws SQLException {
        ArrayList<PluginServiceConf> scList = new ArrayList<PluginServiceConf>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM plugin_service_conf " + szCondition + " " + szOrderBy);
            rs = ps.executeQuery();
            while (rs.next()) {
                PluginServiceConf sc = new PluginServiceConf();
                sc.setPluginConfId(rs.getString("plugin_conf_id"));
                sc.setConfSort(rs.getInt("conf_sort"));
                sc.setServiceId(rs.getString("service_id"));
                sc.setServiceName(rs.getString("service_name"));
                sc.setServiceInterface(rs.getString("service_interface"));
                sc.setServiceMethod(rs.getString("service_method"));
                sc.setReturnType(rs.getString("return_type"));
                sc.setParamGroupId(rs.getString("param_group_id"));
                sc.setVersion(rs.getString("version"));
                sc.setGroup(rs.getString("service_group"));
                sc.setTimeout(rs.getBigDecimal("timeout"));
                scList.add(sc);
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryPluginServiceConfWithCond is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return scList;
    }

    protected void close(ResultSet theRs, Statement theStmt, PreparedStatement thePs) {
        try {
            if (theRs != null) {
                theRs.close();
            }
            if (theStmt != null) {
                theStmt.close();
            }
            if (thePs != null) {
                thePs.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

