/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.plugins.core.utils.date;

import com.irdstudio.sdk.plugins.core.utils.date.DateUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateVerify {
    public static boolean isDateTail(String sdate, int cycleOfDate) {
        Date date;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            date = df.parse(sdate);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        String month = sdate.substring(5, 7);
        if (3 == cycleOfDate && month.equals("12")) {
            int lastDayOfMonth = cal.getActualMaximum(6);
            int nowDay = cal.get(6);
            if (nowDay == lastDayOfMonth) {
                return true;
            }
            return true;
        }
        if (4 == cycleOfDate && (month.equals("3") || month.equals("6") || month.equals("9") || month.equals("12"))) {
            int lastDayOfMonth = cal.getActualMaximum(5);
            int nowDay = cal.get(5);
            if (nowDay == lastDayOfMonth) {
                return true;
            }
        } else if (2 == cycleOfDate) {
            int lastDayOfMonth = cal.getActualMaximum(5);
            int nowDay = cal.get(5);
            if (nowDay == lastDayOfMonth) {
                return true;
            }
        } else if (5 == cycleOfDate) {
            int lastDayOfMonth = cal.getActualMaximum(7);
            int nowDay = cal.get(7);
            if (nowDay == lastDayOfMonth) {
                return true;
            }
        }
        return false;
    }

    public static boolean isYear(String year) {
        int j = 0;
        if (year.length() != 4) {
            return false;
        }
        for (int i = 0; i < year.length(); ++i) {
            if (year.charAt(i) >= '0' && year.charAt(i) <= '9') continue;
            return false;
        }
        j = Integer.parseInt(year);
        return j > 0 && j <= 9999;
    }

    public static boolean isMonth(String month) {
        int j = 0;
        if (month.length() != 2) {
            return false;
        }
        for (int i = 0; i < month.length(); ++i) {
            if (month.charAt(i) >= '0' && month.charAt(i) <= '9') continue;
            return false;
        }
        j = Integer.parseInt(month);
        return j >= 1 && j <= 12;
    }

    public static boolean isDayOfMonth(String day) {
        int j = 0;
        if (day.length() != 2) {
            return false;
        }
        for (int i = 0; i < day.length(); ++i) {
            if (day.charAt(i) >= '0' && day.charAt(i) <= '9') continue;
            return false;
        }
        j = Integer.parseInt(day);
        return j >= 1 && j <= 31;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean isYearMonthday(String ymd) {
        int nf = 0;
        int yf = 0;
        int rq = 0;
        int j = 0;
        switch (ymd.length()) {
            case 4: 
            case 6: 
            case 8: {
                break;
            }
            default: {
                return false;
            }
        }
        for (int i = 0; i < ymd.length(); ++i) {
            if (ymd.charAt(i) >= '0' && ymd.charAt(i) <= '9') continue;
            return false;
        }
        j = Integer.parseInt(ymd);
        switch (ymd.length()) {
            case 8: {
                rq = j % 100;
            }
            case 6: {
                yf = j / 100 % 100;
            }
            case 4: {
                nf = j / 10000;
                break;
            }
            default: {
                return false;
            }
        }
        if (nf <= 0 || nf > 9999) {
            return false;
        }
        switch (ymd.length()) {
            case 6: {
                if (yf >= 1 && yf <= 12) return true;
                return false;
            }
            case 8: {
                if (yf < 1 || yf > 12) {
                    return false;
                }
                switch (yf) {
                    case 1: 
                    case 3: 
                    case 5: 
                    case 7: 
                    case 8: 
                    case 10: 
                    case 12: {
                        if (rq >= 1 && rq <= 31) return true;
                        return false;
                    }
                    case 4: 
                    case 6: 
                    case 9: 
                    case 11: {
                        if (rq >= 1 && rq <= 30) return true;
                        return false;
                    }
                    case 2: {
                        if (!(nf % 4 == 0 && (nf % 400 == 0 || nf % 100 != 0) ? rq < 1 || rq > 29 : rq < 1 || rq > 28)) return true;
                        return false;
                    }
                }
                return true;
            }
        }
        return true;
    }

    public static boolean isDate(String szDate) {
        boolean flag = true;
        switch (szDate.length()) {
            case 4: {
                flag = DateVerify.isYear(szDate);
                break;
            }
            case 6: 
            case 8: {
                flag = DateVerify.isYearMonthday(szDate);
                break;
            }
            default: {
                return false;
            }
        }
        return flag;
    }

    public static boolean isDate2(String szDate) {
        String szCvDate = szDate.replaceAll("-", "");
        return DateVerify.isDate(szCvDate);
    }

    public static boolean isEndofMonth(String ymd) {
        boolean flag = true;
        String day = null;
        switch (ymd.length()) {
            case 8: {
                day = ymd;
                flag = DateVerify.isYearMonthday(day);
                break;
            }
            case 10: {
                if (ymd.charAt(4) != '-' && ymd.charAt(7) != '-') {
                    return false;
                }
                day = ymd.substring(0, 4) + ymd.substring(5, 7) + ymd.substring(8, 10);
                flag = DateVerify.isYearMonthday(day);
                break;
            }
            default: {
                return false;
            }
        }
        int nf = Integer.parseInt(day.substring(0, 4));
        int yf = Integer.parseInt(day.substring(4, 6));
        int rq = Integer.parseInt(day.substring(6, 8));
        int nextday = DateUtil.getDate(nf, yf, rq, 1);
        if (flag && nextday % 100 != 1) {
            flag = false;
        }
        return flag;
    }

    public static boolean isEndofYear(String ymd) {
        boolean flag = true;
        String day = null;
        switch (ymd.length()) {
            case 8: {
                day = ymd;
                flag = DateVerify.isYearMonthday(day);
                break;
            }
            case 10: {
                if (ymd.charAt(4) != '-' && ymd.charAt(7) != '-') {
                    return false;
                }
                day = ymd.substring(0, 4) + ymd.substring(5, 7) + ymd.substring(8, 10);
                flag = DateVerify.isYearMonthday(day);
                break;
            }
            default: {
                return false;
            }
        }
        int nf = Integer.parseInt(day.substring(0, 4));
        int yf = Integer.parseInt(day.substring(4, 6));
        int rq = Integer.parseInt(day.substring(6, 8));
        int nextday = DateUtil.getDate(nf, yf, rq, 1);
        if (flag && nextday % 10000 != 101) {
            flag = false;
        }
        return flag;
    }

    public static void main(String[] args) {
        System.out.println(DateVerify.isDate("20130505"));
        System.out.println(DateVerify.isDate2("20130505"));
        System.out.println(DateVerify.isDate2("2013-05-05"));
        System.out.println(DateVerify.isDate2("2013/05/05"));
        System.out.println(DateVerify.isDate2("2013-5-5"));
        System.out.println("2013-05-05".compareTo("2013-05-06"));
        System.out.println("2013-05-05".compareTo("2013-05-05"));
        System.out.println("2013-05-05".compareTo("2013-05-02"));
    }
}

