/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.plugins.core;

import com.irdstudio.sdk.beans.core.util.StringUtil;
import com.irdstudio.sdk.beans.core.util.TimeUtil;
import com.irdstudio.sdk.plugins.core.BatchTaskThread;
import com.irdstudio.sdk.plugins.core.dao.JavaDataJobDao;
import com.irdstudio.sdk.plugins.core.tinycore.jdbc.dbcp.TConnPool;
import com.irdstudio.sdk.plugins.core.tinycore.log.ILogger;
import com.irdstudio.sdk.plugins.core.tinycore.log.LoggerFactory;
import com.irdstudio.sdk.plugins.core.tinycore.log.TLogger;
import com.irdstudio.sdk.plugins.core.tinycore.thread.TThreadPools;
import com.irdstudio.sdk.plugins.core.utils.pub.Convert;
import com.irdstudio.sdk.plugins.core.vo.BatBatchInfoConfig;
import com.irdstudio.sdk.plugins.core.vo.BatBatchStageConfig;
import com.irdstudio.sdk.plugins.core.vo.BatInstBatch;
import com.irdstudio.sdk.plugins.core.vo.BatInstTask;
import com.irdstudio.sdk.plugins.core.vo.BatTaskUnitConfig;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class BatchRunProcess
extends Thread {
    private String batchId = "";
    private String batchSerialNo;
    private BatBatchInfoConfig batchConfig = null;
    private String batchLogPath;
    private BatInstBatch batchInst = null;
    private Map<String, BatTaskUnitConfig> taskConfigMap = null;
    private int runState = 8;
    private int equallyTaskAmount = 0;
    private Integer taskThreadAmount = 0;
    private Connection conn = null;
    private ILogger logger = null;
    private ExecutorService threadPool = null;
    private static final Object taskThreadAmountLock = new Object();

    public BatchRunProcess(String batchSerialNo, BatBatchInfoConfig batchConfig, String batchLogPath) {
        this.batchSerialNo = batchSerialNo;
        this.batchConfig = batchConfig;
        this.batchLogPath = batchLogPath;
    }

    public BatchRunProcess(String batchId) {
        this.batchId = batchId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        JavaDataJobDao dao = null;
        String sql = null;
        ArrayList<Object> values = new ArrayList<Object>();
        try {
            this.conn = TConnPool.getDefaultPool().getConnection();
            dao = new JavaDataJobDao(this.conn, true);
            if (null == this.batchConfig) {
                sql = "select * from bat_batch_info_config where batch_id = ?";
                values.clear();
                values.add(this.batchId);
                this.batchConfig = dao.querySingle(sql, values, BatBatchInfoConfig.class);
            } else {
                this.batchId = this.batchConfig.getBatchId();
            }
            sql = "select * from bat_inst_batch where batch_serial_no = ?";
            values.clear();
            values.add(this.batchSerialNo);
            this.batchInst = dao.querySingle(sql, values, BatInstBatch.class);
            if (this.batchInst == null) {
                throw new SQLException("\u672a\u8bfb\u53d6\u5230\u4e1a\u52a1\u6d41\u8f6c\u5b9e\u4f8b:" + this.batchSerialNo);
            }
            this.threadPool = TThreadPools.getThreadPool(this.batchSerialNo);
            String fullLogFileName = this.batchLogPath + File.separator + this.batchSerialNo + ".log";
            System.err.println(fullLogFileName);
            ILogger fileLogger = LoggerFactory.makeTxtFileLogger(fullLogFileName, true);
            fileLogger.setName(this.batchSerialNo);
            TLogger.registerCategoryLogger(this.batchSerialNo, fileLogger);
            this.logger = TLogger.getLogger(this.batchSerialNo);
            this.logger.info("\u4e1a\u52a1\u6d41\u8f6c[" + this.batchSerialNo + "]\u6279\u6b21\u5f00\u59cb...");
            this.equallyTaskAmount = this.batchConfig.getEquallyTaskAmount();
            this.batchInst.setStartTime(TimeUtil.getCurrentDateTime());
            this.taskConfigMap = new Hashtable<String, BatTaskUnitConfig>();
            sql = "select * from bat_task_unit_config where batch_id = ? and task_use_state = ?";
            values.clear();
            values.add(this.batchId);
            values.add("0");
            List<BatTaskUnitConfig> taskUnitConfigs = dao.queryList(sql, values, BatTaskUnitConfig.class);
            for (BatTaskUnitConfig config : taskUnitConfigs) {
                this.taskConfigMap.put(config.getTaskId(), config);
            }
            sql = "select * from bat_batch_stage_config where batch_id = ? order by stage_order asc";
            values.clear();
            values.add(this.batchId);
            List<BatBatchStageConfig> stageConfigs = dao.queryList(sql, values, BatBatchStageConfig.class);
            String stageId = null;
            for (BatBatchStageConfig stageConfig : stageConfigs) {
                stageId = stageConfig.getStageId();
                this.batchInst.setStageId(stageId);
                sql = "update bat_inst_batch set batch_state = ?, stage_id = ?, stage_name = ? where batch_serial_no = ?";
                values.clear();
                values.add("3");
                values.add(stageId);
                values.add(stageConfig.getStageName());
                values.add(this.batchSerialNo);
                dao.update(sql, values);
                while (!this.doFinishStageAllTask(dao, stageId) && this.runState != 1) {
                    this.logger.info(Thread.currentThread().getName() + " Sleep 10 second!!!");
                    Thread.sleep(10000L);
                }
                if (this.runState != 1) continue;
                sql = "update bat_inst_batch set batch_state = ? where batch_serial_no = ?";
                values.clear();
                values.add("1");
                values.add(this.batchSerialNo);
                dao.update(sql, values);
                break;
            }
            if (this.runState != 1) {
                sql = "update bat_inst_batch set batch_state = ?, end_time = ? where batch_serial_no = ?";
                values.clear();
                values.add("9");
                values.add(TimeUtil.getCurrentDateTime());
                values.add(this.batchSerialNo);
                dao.update(sql, values);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error(e.getMessage());
            sql = "update bat_inst_batch set batch_state = ? where batch_serial_no = ?";
            values.clear();
            values.add("1");
            values.add(this.batchSerialNo);
            dao.update(sql, values);
        }
        finally {
            TConnPool.getDefaultPool().releaseConnection(this.conn);
            TThreadPools.showdownThreadPool(this.batchSerialNo);
            this.logger.info("\u6279\u6b21\u7ed3\u675f..." + Thread.currentThread().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doFinishStageAllTask(JavaDataJobDao dao, String stageId) throws Exception {
        boolean bFinished = true;
        Object object = taskThreadAmountLock;
        synchronized (object) {
            if (this.taskThreadAmount >= this.equallyTaskAmount) {
                this.logger.info("\u8fbe\u5230\u6700\u5927\u5e76\u53d1\u6570--->taskThreadAmount[" + this.taskThreadAmount + "] >= equallyTaskAmount[" + this.taskThreadAmount + "]");
                return false;
            }
        }
        ArrayList<Object> values = new ArrayList<Object>();
        String sql = "select * from bat_inst_task where batch_serial_no = ? and stage_id = ? order by task_run_state desc,task_id asc";
        values.add(this.batchSerialNo);
        values.add(stageId);
        List<BatInstTask> allTaskList = dao.queryList(sql, values, BatInstTask.class);
        if (allTaskList == null || allTaskList.size() == 0) {
            this.logger.info("batch_serial_no [" + this.batchSerialNo + "] stage_id [" + stageId + "] has no task to run!!!");
            return true;
        }
        BatTaskUnitConfig taskConf = null;
        for (BatInstTask taskInst : allTaskList) {
            taskConf = this.taskConfigMap.get(taskInst.getTaskId());
            this.runState = this.getBatchRunStateWithTask(taskInst, taskConf);
            if (this.runState == 1) {
                this.logger.info("batch_serial_no [" + this.batchSerialNo + "] stage_id [" + stageId + "]\u4e0b\u6279\u6b21\u4efb\u52a1\u8fd0\u884c\u5931\u8d25...");
                return false;
            }
            if (this.isTaskCanRun(taskInst, taskConf, dao)) {
                Object object2 = taskThreadAmountLock;
                synchronized (object2) {
                    if (this.taskThreadAmount >= this.equallyTaskAmount) {
                        this.logger.info("\u542f\u52a8\u4e00\u4e2a\u7ebf\u7a0b\u8fd0\u884c\u4efb\u52a1\u65f6\uff0c\u8fbe\u5230\u6700\u5927\u7ebf\u7a0b --> taskThreadAmount[" + this.taskThreadAmount + "] >= equallyTaskAmount[" + this.taskThreadAmount + "]");
                        return false;
                    }
                    Integer n = this.taskThreadAmount;
                    Integer n2 = this.taskThreadAmount = Integer.valueOf(this.taskThreadAmount + 1);
                    this.logger.info(taskInst.getTaskName() + "[" + taskInst.getTaskId() + "]\u542f\u52a8\u7ebf\u7a0b\u5904\u7406...\u4efb\u52a1\u7ebf\u7a0b\u6570\uff1a" + this.taskThreadAmount);
                    BatchTaskThread taskThread = new BatchTaskThread(this.batchInst, taskInst, taskConf, this);
                    if (this.threadPool == null || this.threadPool.isTerminated()) {
                        this.threadPool = TThreadPools.getThreadPool(this.batchSerialNo);
                    }
                    this.threadPool.execute(taskThread);
                    this.logger.info("batch_serial_no [" + this.batchSerialNo + "] " + taskInst.getTaskName() + "[" + taskInst.getTaskId() + "]\u542f\u52a8\u7ebf\u7a0b\u5904\u7406\u6210\u529f...");
                }
                bFinished = false;
                continue;
            }
            bFinished = bFinished && this.isTaskRunSuccess(taskInst);
        }
        return bFinished;
    }

    private boolean isTaskCanRun(BatInstTask taskInst, BatTaskUnitConfig taskConf, JavaDataJobDao dao) throws Exception {
        boolean isCanRun = false;
        int state = Convert.StrToInt(taskInst.getTaskRunState(), 7);
        if ((state == 0 || state == 1) && taskConf != null) {
            isCanRun = StringUtil.isNullorBank((String)taskConf.getPreviousTaskId()) || this.isPreviousTaskOk(taskConf.getPreviousTaskId(), dao);
        }
        return isCanRun;
    }

    private int getBatchRunStateWithTask(BatInstTask taskInst, BatTaskUnitConfig taskConf) {
        int batchState = this.runState;
        int state = Convert.StrToInt(taskInst.getTaskRunState(), 7);
        if (7 == state) {
            int skipTactic = Convert.StrToInt(taskConf.getTaskSkipTactic(), 2);
            if (skipTactic != 0) {
                if (skipTactic == 1) {
                    int interveneState = Convert.StrToInt(taskInst.getTaskInterveneState());
                    if (interveneState != 1) {
                        batchState = 1;
                    }
                } else {
                    batchState = 1;
                }
            }
        } else {
            batchState = 3;
        }
        return batchState;
    }

    private boolean isPreviousTaskOk(String previousTaskId, JavaDataJobDao dao) throws Exception {
        ArrayList<Object> values = new ArrayList<Object>();
        String sql = "select * from bat_inst_task where batch_serial_no = ? and task_id = ?";
        values.add(this.batchSerialNo);
        values.add(previousTaskId);
        BatInstTask taskInst = dao.querySingle(sql, values, BatInstTask.class);
        return this.isTaskRunSuccess(taskInst);
    }

    private boolean isTaskRunSuccess(BatInstTask taskInst) {
        int state = Convert.StrToInt(taskInst.getTaskRunState(), 7);
        int interveneState = Convert.StrToInt(taskInst.getTaskInterveneState(), 0);
        return state == 6 || interveneState == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTaskTheadCalc(int i) {
        Object object = taskThreadAmountLock;
        synchronized (object) {
            this.taskThreadAmount = this.taskThreadAmount + i;
        }
    }
}

