/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.plugins.core.cache;

import com.irdstudio.sdk.plugins.core.annotation.DBColumnField;
import com.irdstudio.sdk.plugins.core.vo.BeanColumnMap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BeanCache {
    private static Map<String, List<BeanColumnMap>> BEAN_TABLE_MAP = new HashMap<String, List<BeanColumnMap>>();
    private static Map<String, List<String>> BEANS_SAME_COLUMN_MAP = new HashMap<String, List<String>>();

    public static List<BeanColumnMap> getBeanTableMap(String className) {
        List<BeanColumnMap> list = null;
        if (BEAN_TABLE_MAP.containsKey(className)) {
            list = BEAN_TABLE_MAP.get(className);
        }
        return list;
    }

    public static List<BeanColumnMap> getBeanColumnMaps(Class<?> clazz) {
        String className = clazz.getSimpleName();
        List<BeanColumnMap> list = BeanCache.getBeanTableMap(className);
        if (Objects.isNull(list) || list.isEmpty()) {
            try {
                Field[] fields = clazz.getDeclaredFields();
                DBColumnField df = null;
                BeanColumnMap beanColumnMap = null;
                String fieldName = null;
                String columnName = null;
                boolean isPk = false;
                boolean isNumber = false;
                for (Field field : fields) {
                    fieldName = field.getName();
                    df = field.getAnnotation(DBColumnField.class);
                    if (df == null) continue;
                    beanColumnMap = new BeanColumnMap();
                    columnName = df.name();
                    isPk = df.isPK();
                    isNumber = df.isNumber();
                    beanColumnMap.setColumnName(columnName);
                    beanColumnMap.setPk(isPk);
                    beanColumnMap.setNumber(isNumber);
                    beanColumnMap.setBeanMemberName(fieldName);
                    beanColumnMap.setDicName(df.dicName());
                    beanColumnMap.setConditionType(df.conditionType().toUpperCase());
                    beanColumnMap.setCanNull(df.canNull());
                    beanColumnMap.setNullMsg(df.nullMsg());
                    if (list == null) {
                        list = new ArrayList<BeanColumnMap>();
                    }
                    list.add(beanColumnMap);
                }
                if (Objects.nonNull(list) && !list.isEmpty()) {
                    BEAN_TABLE_MAP.put(className, list);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public static void setBeanTableMap(String className, List<BeanColumnMap> list) {
        BEAN_TABLE_MAP.put(className, list);
    }

    public static void setTwoBeansSameColumns(String key, List<String> columns) {
        BEANS_SAME_COLUMN_MAP.put(key, columns);
    }

    public static List<String> getTwoBeansSameColumns(String key) {
        if (BEANS_SAME_COLUMN_MAP.containsKey(key)) {
            BEANS_SAME_COLUMN_MAP.get(key);
        }
        return null;
    }
}

