/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.plugins.core.plugin.common;

import com.irdstudio.sdk.plugins.core.plugin.common.SSubsDatasource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSubsDatasourceDao {
    private static final Logger logger = LoggerFactory.getLogger(SSubsDatasourceDao.class);
    Connection conn = null;

    public SSubsDatasourceDao(Connection conn) {
        this.conn = conn;
    }

    public SSubsDatasource queryWithKeys(String subsCode, String subsDsCode) throws SQLException {
        SSubsDatasource dc = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM s_subs_datasource WHERE subs_code=? and subs_ds_code=?");
            ps.setString(1, subsCode);
            ps.setString(2, subsDsCode);
            rs = ps.executeQuery();
            if (rs.next()) {
                dc = new SSubsDatasource();
                dc.setSubsCode(rs.getString("subs_code"));
                dc.setSubsDsCode(rs.getString("subs_ds_code"));
                dc.setSubsDsName(rs.getString("subs_ds_name"));
                dc.setSubsDsType(rs.getString("subs_ds_type"));
                dc.setDsDbName(rs.getString("ds_db_name"));
                dc.setDsConnStr(rs.getString("ds_conn_str"));
                dc.setDsUserId(rs.getString("ds_user_id"));
                dc.setDsUserPwd(rs.getString("ds_user_pwd"));
                dc.setDsSchemaName(rs.getString("ds_schema_name"));
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("querySSubsDatasourceWithKeys is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dc;
    }

    public List<SSubsDatasource> queryAll() throws SQLException {
        ArrayList<SSubsDatasource> dcList = new ArrayList<SSubsDatasource>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM s_subs_datasource ");
            rs = ps.executeQuery();
            while (rs.next()) {
                SSubsDatasource dc = new SSubsDatasource();
                dc.setSubsCode(rs.getString("subs_code"));
                dc.setSubsDsCode(rs.getString("subs_ds_code"));
                dc.setSubsDsName(rs.getString("subs_ds_name"));
                dc.setSubsDsType(rs.getString("subs_ds_type"));
                dc.setDsDbName(rs.getString("ds_db_name"));
                dc.setDsConnStr(rs.getString("ds_conn_str"));
                dc.setDsUserId(rs.getString("ds_user_id"));
                dc.setDsUserPwd(rs.getString("ds_user_pwd"));
                dc.setDsSchemaName(rs.getString("ds_schema_name"));
                dcList.add(dc);
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("querySSubsDatasourceWithCond is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dcList;
    }

    protected void close(ResultSet theRs, Statement theStmt, PreparedStatement thePs) {
        try {
            if (theRs != null) {
                theRs.close();
            }
            if (theStmt != null) {
                theStmt.close();
            }
            if (thePs != null) {
                thePs.close();
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
    }
}

