/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.plugins.core.plugin.common;

import com.irdstudio.sdk.plugins.core.plugin.common.SSubsInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSubsInfoDao {
    private static final Logger logger = LoggerFactory.getLogger(SSubsInfoDao.class);
    Connection conn = null;

    public SSubsInfoDao(Connection conn) {
        this.conn = conn;
    }

    public SSubsInfo querySSubsInfoWithKeys(String subsCode) throws SQLException {
        SSubsInfo dc = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM s_subs_info WHERE subs_code=?");
            ps.setString(1, subsCode);
            rs = ps.executeQuery();
            if (rs.next()) {
                dc = new SSubsInfo();
                dc.setSubsCode(rs.getString("subs_code"));
                dc.setSubsName(rs.getString("subs_name"));
                dc.setSubsDataDate(rs.getString("subs_data_date"));
                dc.setSubsLastDataDate(rs.getString("subs_last_data_date"));
                dc.setSubsLoadDate(rs.getString("subs_load_date"));
                dc.setSubsBatDate(rs.getString("subs_bat_date"));
                dc.setBatchIdPrefix(rs.getString("batch_id_prefix"));
                dc.setRsvDate(rs.getString("rsv_date"));
                dc.setRsvState(rs.getString("rsv_state"));
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("querySSubsInfoWithKeys is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dc;
    }

    protected void close(ResultSet theRs, Statement theStmt, PreparedStatement thePs) {
        try {
            if (theRs != null) {
                theRs.close();
            }
            if (theStmt != null) {
                theStmt.close();
            }
            if (thePs != null) {
                thePs.close();
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
    }
}

