/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.plugins.core.plugin.datajob;

import com.irdstudio.sdk.plugins.core.plugin.datajob.AbstractDataJobPlugin;
import com.irdstudio.sdk.plugins.core.plugin.datajob.PluginJobConf;
import com.irdstudio.sdk.plugins.core.plugin.datajob.PluginJobParam;
import com.irdstudio.sdk.plugins.core.plugin.datajob.PluginJobParamDao;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class DatastageJobPlugin
extends AbstractDataJobPlugin {
    public static final String SEHELLNAME = "execDataStageJob.sh";

    @Override
    public boolean doExecuteJob(PluginJobConf jobConf) {
        this.logger.info("\u6267\u884cDatastage\u4f5c\u4e1a\uff1a" + jobConf.getJobName() + "...");
        String[] jobParams = this.parseDsParams(jobConf);
        boolean bResult = this.callExternCmd(this.binPath + "datastage/" + SEHELLNAME, jobParams);
        return bResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] parseDsParams(PluginJobConf pds) {
        String DSJOB = pds.getJobName();
        StringBuffer jobParamsBuf = new StringBuffer();
        String HostIP = this.context.getVv().getValue("HostIP");
        String HostUser = this.context.getVv().getValue("HostUser");
        String HostPwd = this.context.getVv().getValue("HostPwd");
        String DSPRJ = this.context.getVv().getValue("DSPRJ");
        String DSHOME = this.context.getVv().getValue("DSHOME");
        if (null != pds.getParamGroupId() && !"".equals(pds.getParamGroupId())) {
            Connection conn = null;
            try {
                conn = this.getPluginConnection();
                PluginJobParamDao jobParamDao = new PluginJobParamDao(conn);
                List<PluginJobParam> jobParamList = jobParamDao.queryWithParamGroupId(pds.getParamGroupId());
                for (int i = 0; i < jobParamList.size(); ++i) {
                    jobParamsBuf.append(" -param $").append(jobParamList.get(i).getJobParamName().trim()).append("=").append(this.context.toParseSysVariable(this.toNotNullAndTrim(jobParamList.get(i).getJobParamValue())));
                }
            }
            catch (SQLException e) {
                this.writeFaildLog("\u89e3\u91ca" + pds.getJobName() + "\u4f5c\u4e1a\u53c2\u6570", e.getMessage());
            }
            finally {
                this.closePluginConnection(conn);
            }
        }
        this.logger.info("Data Job Params:" + jobParamsBuf);
        String[] shellParams = new String[]{this.toNotNullAndTrim(DSJOB), this.toNotNullAndTrim(jobParamsBuf.toString()), this.toNotNullAndTrim(HostIP), this.toNotNullAndTrim(HostUser), this.toNotNullAndTrim(HostPwd), this.toNotNullAndTrim(DSPRJ), this.toNotNullAndTrim(DSHOME)};
        return shellParams;
    }
}

