/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.plugins.core.plugin.datajob;

import com.irdstudio.sdk.plugins.core.plugin.datajob.PluginJobParam;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginJobParamDao {
    private static final Logger logger = LoggerFactory.getLogger(PluginJobParamDao.class);
    Connection conn = null;

    public PluginJobParamDao(Connection conn) {
        this.conn = conn;
    }

    public PluginJobParam queryWithKeys(String paramGroupId, String jobParamName) throws SQLException {
        PluginJobParam dc = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM plugin_job_param WHERE param_group_id=?,job_param_name=?");
            ps.setString(1, paramGroupId);
            ps.setString(2, jobParamName);
            rs = ps.executeQuery();
            if (rs.next()) {
                dc = new PluginJobParam();
                dc.setParamGroupId(rs.getString("param_group_id"));
                dc.setJobParamName(rs.getString("job_param_name"));
                dc.setJobParamValue(rs.getString("job_param_value"));
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryPluginJobParamWithKeys is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dc;
    }

    public List<PluginJobParam> queryWithParamGroupId(String dsParams) throws SQLException {
        ArrayList<PluginJobParam> dcList = new ArrayList<PluginJobParam>();
        PluginJobParam dc = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM plugin_job_param WHERE ds_params=?");
            ps.setString(1, dsParams);
            rs = ps.executeQuery();
            while (rs.next()) {
                dc = new PluginJobParam();
                dc.setParamGroupId(rs.getString("param_group_id"));
                dc.setJobParamName(rs.getString("job_param_name"));
                dc.setJobParamValue(rs.getString("job_param_value"));
                dcList.add(dc);
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryWithParamGroupId is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dcList;
    }

    protected void close(ResultSet theRs, Statement theStmt, PreparedStatement thePs) {
        try {
            if (theRs != null) {
                theRs.close();
            }
            if (theStmt != null) {
                theStmt.close();
            }
            if (thePs != null) {
                thePs.close();
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
    }
}

