/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.plugins.core.plugin.excel;

import com.irdstudio.sdk.plugins.core.plugin.AbstractPlugin;
import com.irdstudio.sdk.plugins.core.plugin.excel.PluginExcelConf;
import com.irdstudio.sdk.plugins.core.plugin.excel.PluginExcelConfDao;
import com.irdstudio.sdk.plugins.core.plugin.excel.export.ExcelExportExecutor;
import com.irdstudio.sdk.plugins.core.utils.pub.PathUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class ExcelPlugin
extends AbstractPlugin {
    private List<PluginExcelConf> excelConfList = null;

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        PluginExcelConfDao pecDao = new PluginExcelConfDao(conn);
        this.excelConfList = pecDao.queryWithPluginConfId(szConfIdentify);
        if (this.excelConfList.size() < 1) {
            this.context.setSzLastErrorMsg("\u672a\u8bfb\u53d6\u5230\u914d\u7f6e\u6807\u8bc6\u4e3a\uff1a" + szConfIdentify + "\u7684Excel\u64cd\u4f5c\u914d\u7f6e!");
            return false;
        }
        return true;
    }

    @Override
    public boolean execute() {
        boolean result = true;
        Connection conn = this.getPluginConnection();
        for (int i = 0; i < this.excelConfList.size(); ++i) {
            PluginExcelConf excelConf = this.excelConfList.get(i);
            excelConf.setConfigureFile(PathUtil.getClassRootPath() + this.context.toParseSysVariable(excelConf.getConfigureFile()));
            this.logger.info("\u5f00\u59cb\u6267\u884cExcel\u64cd\u4f5c[" + excelConf.getExcelOperType() + ",\u914d\u7f6e\u6587\u4ef6:" + excelConf.getConfigureFile() + ",\u53c2\u6570\u952e\u503c\u5bf9\uff1a" + excelConf.getParamKeyValue() + "]...");
            String[] params = excelConf.getParamKeyValue().split(",");
            for (int j = 0; j < params.length; ++j) {
                String[] keyValues = params[j].split(":");
                this.context.getVv().addVariable(keyValues[0], keyValues[1]);
            }
            result = new ExcelExportExecutor(excelConf.getConfigureFile(), this.context.getVv(), conn, this.logger).run();
            if (!result && "2".equals(excelConf.getFaildDeal())) {
                this.writeFaildLog("\u6267\u884cExcel\u64cd\u4f5c[" + excelConf.getExcelOperType() + ",\u914d\u7f6e\u6587\u4ef6:" + excelConf.getConfigureFile() + ",\u53c2\u6570\u952e\u503c\u5bf9\uff1a" + excelConf.getParamKeyValue() + "]");
                break;
            }
            this.writeSuccessLog("\u6267\u884cExcel\u64cd\u4f5c[" + excelConf.getExcelOperType() + ",\u914d\u7f6e\u6587\u4ef6:" + excelConf.getConfigureFile() + ",\u53c2\u6570\u952e\u503c\u5bf9\uff1a" + excelConf.getParamKeyValue() + "]");
        }
        this.closePluginConnection(conn);
        return result;
    }
}

