/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.plugins.core.plugin.reform;

import com.irdstudio.sdk.plugins.core.plugin.reform.PluginReformConf;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class PluginReformConfDao {
    Connection conn = null;

    public PluginReformConfDao(Connection conn) {
        this.conn = conn;
    }

    public PluginReformConf queryPluginReformConfWithKeys(String pluginConfId, int confSort) throws SQLException {
        PluginReformConf dc = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM urps.plugin_reform_conf WHERE plugin_conf_id=?,conf_sort=? with ur");
            ps.setString(1, pluginConfId);
            ps.setInt(2, confSort);
            rs = ps.executeQuery();
            if (rs.next()) {
                dc = new PluginReformConf();
                dc.setPluginConfId(rs.getString("plugin_conf_id"));
                dc.setConfSort(rs.getInt("conf_sort"));
                dc.setReformTableSchema(rs.getString("reform_table_schema"));
                dc.setReformTableName(rs.getString("reform_table_name"));
                dc.setReformGroupId(rs.getString("reform_group_id"));
                dc.setReformCycleDay(rs.getInt("reform_cycle_day"));
                dc.setLastReformDate(rs.getString("last_reform_date"));
                dc.setRsvOption(rs.getString("rsv_option"));
                dc.setValidDate(rs.getString("valid_date"));
                dc.setInvalidDate(rs.getString("invalid_date"));
                dc.setLastModifyDate(rs.getString("last_modify_date"));
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryPluginReformConfWithKeys is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dc;
    }

    public List<PluginReformConf> queryPluginReformConfWithCond(String szCondition, String szOrderBy) throws SQLException {
        ArrayList<PluginReformConf> dcList = new ArrayList<PluginReformConf>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM urps.plugin_reform_conf " + szCondition + " " + szOrderBy + " with ur");
            rs = ps.executeQuery();
            while (rs.next()) {
                PluginReformConf dc = new PluginReformConf();
                dc.setPluginConfId(rs.getString("plugin_conf_id"));
                dc.setConfSort(rs.getInt("conf_sort"));
                dc.setReformTableSchema(rs.getString("reform_table_schema"));
                dc.setReformTableName(rs.getString("reform_table_name"));
                dc.setReformGroupId(rs.getString("reform_group_id"));
                dc.setReformCycleDay(rs.getInt("reform_cycle_day"));
                dc.setLastReformDate(rs.getString("last_reform_date"));
                dc.setRsvOption(rs.getString("rsv_option"));
                dc.setValidDate(rs.getString("valid_date"));
                dc.setInvalidDate(rs.getString("invalid_date"));
                dc.setLastModifyDate(rs.getString("last_modify_date"));
                dcList.add(dc);
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryPluginReformConfWithCond is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dcList;
    }

    protected void close(ResultSet theRs, Statement theStmt, PreparedStatement thePs) {
        try {
            if (theRs != null) {
                theRs.close();
            }
            if (theStmt != null) {
                theStmt.close();
            }
            if (thePs != null) {
                thePs.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

