/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.plugins.core.tinycore.jdbc.dbcp;

import com.irdstudio.sdk.plugins.core.tinycore.jdbc.dbcp.base.IConnPool;
import com.irdstudio.sdk.plugins.core.tinycore.jdbc.dbcp.impl.ConnPoolForDruid;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TConnPool {
    private static IConnPool defaultConnPool = null;
    private static ConcurrentMap<String, IConnPool> dbcpMap = new ConcurrentHashMap<String, IConnPool>();

    public static synchronized IConnPool getDefaultPool() {
        if (defaultConnPool == null) {
            TConnPool.initDefaultPool();
        }
        return defaultConnPool;
    }

    private static synchronized void initDefaultPool() {
        if (defaultConnPool == null) {
            defaultConnPool = new ConnPoolForDruid();
        }
    }

    public static synchronized void setDefaultPool(IConnPool connPool) {
        defaultConnPool = connPool;
    }

    public static IConnPool getPoolInst(String dbcpName) {
        return (IConnPool)dbcpMap.get(dbcpName);
    }

    public static void addConnInst(String dbcpName, IConnPool connPool) {
        dbcpMap.put(dbcpName, connPool);
    }

    public static void removeConnInst(String dbcpName) {
        dbcpMap.remove(dbcpName);
    }

    public static Map<String, IConnPool> getDbcpMap() {
        return dbcpMap;
    }
}

