/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.plugins.core.utils;

import com.irdstudio.sdk.plugins.core.utils.PropertiesUtil;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SFtpUtil {
    private static Logger logger = Logger.getLogger(SFtpUtil.class);
    private String sftpServer;
    private int port = 22;
    private String userName;
    private String password;
    public static final String BUSIMG_FILENAMESEPARATOR = "|";
    public static final String NCMIS_ROOT = PropertiesUtil.getApplicationKey("sftp.filepath.ncmis");
    public static final String CHANNEL_ROOT = PropertiesUtil.getApplicationKey("sftp.filepath.channel");
    public static final String YCLOANS_ROOT = PropertiesUtil.getApplicationKey("sftp.filepath.ycloans");

    public static SFtpUtil instance() {
        String ip = PropertiesUtil.getApplicationKey("sftp.ip");
        String port = PropertiesUtil.getApplicationKey("sftp.port");
        String user = PropertiesUtil.getApplicationKey("sftp.user");
        String pwd = PropertiesUtil.getApplicationKey("sftp.pwd");
        return new SFtpUtil(ip, Integer.valueOf(port), user, pwd);
    }

    public SFtpUtil(String sftpServer, int port, String userName, String password) {
        this.sftpServer = sftpServer;
        this.port = port;
        this.userName = userName;
        this.password = password;
    }

    private Session initSession() throws Exception {
        Session sshSession = null;
        try {
            JSch jsch = new JSch();
            sshSession = jsch.getSession(this.userName, this.sftpServer, this.port);
            sshSession.setPassword(this.password);
            Properties sshConfig = new Properties();
            sshConfig.put("StrictHostKeyChecking", "no");
            sshSession.setConfig(sshConfig);
            sshSession.connect();
            logger.info((Object)("SFTP\u670d\u52a1\u5668[" + this.sftpServer + " : " + this.port + "]\u767b\u5f55\u6210\u529f"));
        }
        catch (Exception e) {
            logger.info((Object)"\u767b\u5f55SFTP\u670d\u52a1\u5668IO\u5f02\u5e38", (Throwable)e);
            throw e;
        }
        return sshSession;
    }

    private ChannelSftp initConnection(Session sshSession) throws Exception {
        ChannelSftp sftp = null;
        try {
            Channel channel = sshSession.openChannel("sftp");
            channel.connect();
            sftp = (ChannelSftp)channel;
            logger.info((Object)("\u6210\u529f\u8fde\u63a5SFTP\u670d\u52a1\u5668[" + this.sftpServer + " : " + this.port + "]"));
        }
        catch (Exception e) {
            logger.info((Object)"\u521d\u59cb\u5316SFTP\u670d\u52a1\u5668IO\u5f02\u5e38", (Throwable)e);
        }
        if (sftp != null) {
            sftp.cd("/");
        }
        return sftp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upLoad(String localFileName, String ftpFilePath, String localFilePath) throws Exception {
        Session sshSession = null;
        ChannelSftp sftp = null;
        try {
            sshSession = this.initSession();
            sftp = this.initConnection(sshSession);
            this.makeAndCdDir(sftp, ftpFilePath);
            if (localFileName.indexOf(BUSIMG_FILENAMESEPARATOR) != -1) {
                String[] files = localFileName.split("\\|");
                for (int i = 0; i < files.length; ++i) {
                    this.uploadFile(sftp, localFilePath + File.separator + files[i]);
                }
            } else {
                this.uploadFile(sftp, localFilePath + File.separator + localFileName);
            }
        }
        finally {
            if (sftp != null) {
                this.disconnect(sftp);
            }
            if (sshSession != null) {
                sshSession.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upLoadBatch(String ftpFilePath, List<Map<String, String>> files) throws Exception {
        Session sshSession = null;
        ChannelSftp sftp = null;
        try {
            sshSession = this.initSession();
            sftp = this.initConnection(sshSession);
            this.makeAndCdDir(sftp, ftpFilePath);
            if (files != null && files.size() > 0) {
                for (Map<String, String> map : files) {
                    String path = map.get("path");
                    String fileName = map.get("fileName");
                    this.uploadFile(sftp, path + File.separator + fileName);
                }
            }
        }
        finally {
            if (sftp != null) {
                this.disconnect(sftp);
            }
            if (sshSession != null) {
                sshSession.disconnect();
            }
        }
    }

    private void uploadFile(ChannelSftp sftp, String localFilePathName) throws Exception {
        InputStream input = null;
        try {
            File file = new File(localFilePathName);
            if (!file.isDirectory()) {
                input = new FileInputStream(file);
                sftp.put(input, file.getName());
                logger.info((Object)("\u6587\u4ef6[" + localFilePathName + "]\u6210\u529f\u4e0a\u4f20\u5230SFTP\u670d\u52a1\u5668"));
            }
        }
        catch (IOException ioe) {
            logger.info((Object)("\u4e0a\u4f20\u6587\u4ef6[" + localFilePathName + "]IO\u5f02\u5e38"), (Throwable)ioe);
            throw ioe;
        }
        catch (Exception e) {
            logger.info((Object)("\u4e0a\u4f20\u6587\u4ef6[" + localFilePathName + "]\u5176\u4ed6\u5f02\u5e38"), (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ex) {
                logger.info((Object)"SFTP\u5bf9\u8c61\u5173\u95ed\u5f02\u5e38", (Throwable)ex);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void makeAndCdDir(ChannelSftp sftp, String dir) throws Exception {
        try {
            StringTokenizer toke = new StringTokenizer(dir, "/");
            while (toke.hasMoreElements()) {
                String currentDir = (String)toke.nextElement();
                if (StringUtils.isNotEmpty((CharSequence)currentDir) && currentDir.startsWith("/")) {
                    currentDir = currentDir.substring(1);
                }
                try {
                    sftp.cd(currentDir);
                }
                catch (SftpException e1) {
                    try {
                        sftp.mkdir(currentDir);
                        sftp.cd(currentDir);
                    }
                    catch (SftpException e) {
                        throw new Exception(e);
                        return;
                    }
                }
            }
        }
        catch (Exception e) {
            logger.info((Object)"\u521b\u5efa\u8fdc\u7a0b\u76ee\u5f55\u7ed3\u6784\u5f02\u5e38", (Throwable)e);
            throw e;
        }
    }

    private void disconnect(ChannelSftp sftp) {
        if (sftp != null) {
            if (sftp.isConnected()) {
                sftp.disconnect();
            } else if (sftp.isClosed()) {
                logger.info((Object)"\u8fde\u63a5\u5df2\u7ecf\u5173\u95ed\uff01");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downLoad(String remoteFileName, String ftpFilePath, String localFilePath) throws Exception {
        if (!new File(localFilePath).isDirectory()) {
            this.makeMultiDirectory(localFilePath);
            if (!new File(localFilePath).isDirectory()) {
                logger.info((Object)("\u521b\u5efa\u672c\u5730\u6587\u4ef6\u5939[" + localFilePath + "]\u5931\u8d25"));
                throw new Exception("\u521b\u5efa\u672c\u5730\u6587\u4ef6\u5939[" + localFilePath + "]\u5931\u8d25");
            }
        }
        Session sshSession = null;
        ChannelSftp sftp = null;
        try {
            sshSession = this.initSession();
            sftp = this.initConnection(sshSession);
            this.makeAndCdDir(sftp, ftpFilePath);
            if (remoteFileName.indexOf(BUSIMG_FILENAMESEPARATOR) != -1) {
                String[] files = StringUtils.splitPreserveAllTokens((String)remoteFileName, (String)BUSIMG_FILENAMESEPARATOR);
                for (int i = 0; i < files.length; ++i) {
                    this.downloadFile(sftp, files[i], localFilePath + File.separator + files[i]);
                }
            } else if (remoteFileName.equalsIgnoreCase("*")) {
                logger.info((Object)"--------\u8fdb\u5165\u4e86} else if (remoteFileName.equalsIgnoreCase(*)) \u4e2d{------", null);
                String[] fileNames = this.getAllFilesInPath(sftp);
                for (int i = 0; i < fileNames.length; ++i) {
                    if ("..".equals(fileNames[i].trim()) || ".".equals(fileNames[i].trim())) {
                        logger.info((Object)"-----\u201c..\u201d\u548c\u201c.\u201d\u4e0d\u4e0b\u8f7d-----", null);
                        continue;
                    }
                    try {
                        sftp.cd(fileNames[i]);
                        String[] nextFileNames = this.getAllFilesInPath(sftp);
                        for (int j = 0; j < nextFileNames.length; ++j) {
                            if ("..".equals(nextFileNames[j].trim()) || ".".equals(nextFileNames[j].trim())) {
                                logger.info((Object)"-----\u201c..\u201d\u548c\u201c.\u201d\u4e0d\u4e0b\u8f7d-----", null);
                                continue;
                            }
                            this.downloadFile(sftp, nextFileNames[j], localFilePath + File.separator + nextFileNames[j]);
                        }
                        sftp.cd("..");
                        continue;
                    }
                    catch (Exception e) {
                        this.downloadFile(sftp, fileNames[i], localFilePath + File.separator + fileNames[i]);
                    }
                }
            } else {
                this.downloadFile(sftp, remoteFileName, localFilePath + File.separator + remoteFileName);
            }
        }
        finally {
            if (sftp != null) {
                this.disconnect(sftp);
            }
            if (sshSession != null) {
                sshSession.disconnect();
            }
        }
    }

    private void downloadFile(ChannelSftp sftp, String remoteFileName, String localFilePathName) throws Exception {
        OutputStream output = null;
        try {
            File file = new File(localFilePathName);
            output = new FileOutputStream(file);
            sftp.get(remoteFileName, output);
            logger.info((Object)("\u6587\u4ef6[" + remoteFileName + "]\u6210\u529f\u4eceSFTP\u670d\u52a1\u5668\u4e0b\u8f7d"));
        }
        catch (IOException ex) {
            logger.info((Object)("\u4e0b\u8f7d\u6587\u4ef6[" + remoteFileName + "]IO\u5f02\u5e38"), (Throwable)ex);
            throw ex;
        }
        catch (SftpException e) {
            logger.info((Object)("\u6587\u4ef6[" + remoteFileName + "]\u4e0d\u5b58\u5728"), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.info((Object)("\u4e0b\u8f7d\u6587\u4ef6[" + remoteFileName + "]\u5176\u4ed6\u5f02\u5e38"), (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (output != null) {
                    output.flush();
                    output.close();
                }
            }
            catch (IOException ex) {
                logger.info((Object)"SFTP\u5bf9\u8c61\u5173\u95ed\u5f02\u5e38", (Throwable)ex);
            }
        }
    }

    private void makeMultiDirectory(String path) {
        if (!new File(path).isDirectory()) {
            String[] dirStrArray = StringUtils.splitPreserveAllTokens((String)path, (String)File.separator);
            StringBuffer dirStr = new StringBuffer(dirStrArray[0]);
            for (int i = 0; i < dirStrArray.length - 1; ++i) {
                boolean flag;
                dirStr.append(File.separator);
                dirStr.append(dirStrArray[i + 1]);
                dirStr.append(File.separator);
                if (new File(dirStr.toString()).isDirectory() || (flag = new File(dirStr.toString()).mkdirs())) continue;
                logger.info((Object)(dirStr + "\u521b\u5efa\u76ee\u5f55\u5f02\u5e38"), (Throwable)new Exception(dirStr + "\u521b\u5efa\u76ee\u5f55\u5f02\u5e38"));
            }
        }
    }

    private String[] getAllFilesInPath(ChannelSftp sftp) throws Exception {
        String[] names = null;
        String curPath = null;
        try {
            ChannelSftp.LsEntry entry;
            int i;
            curPath = sftp.pwd();
            Vector files = sftp.ls(".");
            logger.info((Object)("--------\u603b\u5171\u6709" + files.size() + "\u4e2a\u6587\u4ef6------"), null);
            for (i = 0; i < files.size(); ++i) {
                logger.info((Object)"--------\u8fdb\u5165for\u5faa\u73af\u4e2d\u4e86\uff01------", null);
                entry = (ChannelSftp.LsEntry)files.get(i);
                if ("..".equals(entry.getFilename().trim()) || ".".equals(entry.getFilename().trim())) {
                    logger.info((Object)"------------\u8fdb\u5165\u201c..\u201d\u548c\u201c.\u201d\u7684 if else \u5224\u65ad\u4e2d", null);
                    files.removeElementAt(i);
                }
                logger.info((Object)("\u6587\u4ef6\u540d\u79f0\u4e3a:" + entry.getFilename()), null);
            }
            names = new String[files.size()];
            for (i = 0; i < files.size(); ++i) {
                entry = (ChannelSftp.LsEntry)files.get(i);
                names[i] = entry.getFilename();
            }
        }
        catch (Exception e) {
            logger.info((Object)("\u83b7\u53d6\u8def\u5f84[" + curPath + "]\u4e0b\u7684\u5168\u90e8\u6587\u4ef6\u51fa\u73b0IO\u5f02\u5e38"), (Throwable)e);
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downLoad(HashMap<String, String> downFileMap, String ftpFilePath, String localFilePath) throws Exception {
        if (!new File(localFilePath).isDirectory()) {
            this.makeMultiDirectory(localFilePath);
            if (!new File(localFilePath).isDirectory()) {
                logger.info((Object)("\u521b\u5efa\u672c\u5730\u6587\u4ef6\u5939[" + localFilePath + "]\u5931\u8d25"));
                throw new Exception("\u521b\u5efa\u672c\u5730\u6587\u4ef6\u5939[" + localFilePath + "]\u5931\u8d25");
            }
        }
        Session sshSession = null;
        ChannelSftp sftp = null;
        try {
            sshSession = this.initSession();
            sftp = this.initConnection(sshSession);
            this.makeAndCdDir(sftp, ftpFilePath);
            String localName = null;
            String remoteName = null;
            Iterator<Map.Entry<String, String>> iter = downFileMap.entrySet().iterator();
            Map.Entry<String, String> entry = null;
            while (iter.hasNext()) {
                boolean flag;
                entry = iter.next();
                remoteName = entry.getKey();
                localName = entry.getValue();
                File pFile = new File(localFilePath + File.separator + localName).getParentFile();
                if (!pFile.exists() && !(flag = pFile.mkdirs())) {
                    throw new Exception("\u521b\u5efa\u7236\u76ee\u5f55[" + pFile.getAbsolutePath() + "]\u5931\u8d25");
                }
                pFile = null;
                this.downloadFile(sftp, remoteName, localFilePath + File.separator + localName);
            }
        }
        finally {
            if (sftp != null) {
                this.disconnect(sftp);
            }
            if (sshSession != null) {
                sshSession.disconnect();
            }
        }
    }

    public void copyFile(String fileName, String fromPath, String tragetPath) throws Exception {
        ChannelExec execChannel;
        block10: {
            String cmd1 = "cd " + fromPath + ";";
            String cmd2 = "cp " + fileName + " " + tragetPath;
            Session sshSession = null;
            ChannelSftp sftp = null;
            execChannel = null;
            try {
                sshSession = this.initSession();
                Channel channel = sshSession.openChannel("exec");
                sftp = this.initConnection(sshSession);
                if (sftp != null) {
                    sftp.cd("/");
                }
                this.checkFileIsExist(fileName, fromPath, sftp);
                this.makeAndCdDir(sftp, tragetPath);
                execChannel = (ChannelExec)channel;
                execChannel.setCommand(cmd1 + cmd2);
                logger.info((Object)("\u6267\u884c\u6307\u4ee4[" + cmd1 + cmd2 + "]"));
                execChannel.connect();
                if (sftp != null) {
                    this.disconnect(sftp);
                }
                if (sshSession == null) break block10;
            }
            catch (Exception e) {
                try {
                    logger.info((Object)e.getMessage());
                    throw new Exception("\u590d\u5236\u6587\u4ef6\u5f02\u5e38");
                }
                catch (Throwable throwable) {
                    if (sftp != null) {
                        this.disconnect(sftp);
                    }
                    if (sshSession != null) {
                        sshSession.disconnect();
                    }
                    if (execChannel != null) {
                        execChannel.disconnect();
                    }
                    throw throwable;
                }
            }
            sshSession.disconnect();
        }
        if (execChannel != null) {
            execChannel.disconnect();
        }
    }

    public void checkFileIsExist(String fileName, String fromPath, ChannelSftp sftp) throws SftpException {
        boolean isExist = false;
        try {
            StringTokenizer toke = new StringTokenizer(fromPath, "/");
            while (toke.hasMoreElements()) {
                String currentDir = (String)toke.nextElement();
                if (StringUtils.isNotEmpty((CharSequence)currentDir) && currentDir.startsWith("/")) {
                    currentDir = currentDir.substring(1);
                }
                try {
                    sftp.cd(currentDir);
                }
                catch (SftpException e1) {
                    logger.info((Object)e1.getMessage());
                    throw new SftpException(0, currentDir + "\u76ee\u5f55\u4e0d\u5b58\u5728");
                }
            }
            Vector files = sftp.ls(".");
            for (int i = 0; i < files.size(); ++i) {
                ChannelSftp.LsEntry entry = (ChannelSftp.LsEntry)files.get(i);
                if (!fileName.equals(entry.getFilename())) continue;
                isExist = true;
            }
            if (!isExist) {
                throw new SftpException(0, fromPath + "\u76ee\u5f55\u4e0b\u590d\u5236\u6765\u6e90\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
            }
        }
        catch (SftpException e) {
            logger.info((Object)e.getMessage());
            throw new SftpException(0, e.getMessage());
        }
    }
}

