/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.plugins.core;

import com.irdstudio.sdk.plugins.core.dao.JavaDataJobDao;
import com.irdstudio.sdk.plugins.core.tinycore.jdbc.dbcp.TConnPool;
import com.irdstudio.sdk.plugins.core.tinycore.jdbc.executor.SafeReleaseUtil;
import com.irdstudio.sdk.plugins.core.vo.FlowConfMaster;
import com.irdstudio.sdk.plugins.core.vo.FlowConfNode;
import com.irdstudio.sdk.plugins.core.vo.FlowInstMaster;
import com.irdstudio.sdk.plugins.core.vo.SSubsInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;

public class BatchDataUtil {
    public static synchronized FlowConfNode getFlowConfNode(Connection conn, String taskId) throws Exception {
        if (StringUtils.isBlank((CharSequence)taskId)) {
            throw new SQLException("\u4efb\u52a1\u7f16\u53f7\u4e3a\u7a7a\uff01");
        }
        JavaDataJobDao dao = new JavaDataJobDao(conn, true);
        String sql = "select * from flow_conf_node where task_id = ?";
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(taskId);
        FlowConfNode flowConfNode = dao.querySingle(sql, values, FlowConfNode.class);
        return flowConfNode;
    }

    public static synchronized FlowConfMaster getFlowConfMaster(Connection conn, String batchId) throws Exception {
        JavaDataJobDao dao = new JavaDataJobDao(conn, true);
        String sql = "select * from flow_conf_master where batch_id = ?";
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(batchId);
        FlowConfMaster config = dao.querySingle(sql, values, FlowConfMaster.class);
        return config;
    }

    public static synchronized FlowInstMaster getFlowInstMaster(Connection conn, String batchSerialNo) throws Exception {
        JavaDataJobDao dao = new JavaDataJobDao(conn, true);
        String sql = "select * from flow_inst_master where batch_serial_no = ?";
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(batchSerialNo);
        FlowInstMaster batch = dao.querySingle(sql, values, FlowInstMaster.class);
        return batch;
    }

    public static synchronized SSubsInfo getSSubsInfo(Connection conn, String subsCode) throws Exception {
        JavaDataJobDao dao = new JavaDataJobDao(conn, true);
        String sql = "select * from s_subs_info where subs_code = ?";
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(subsCode);
        SSubsInfo info = dao.querySingle(sql, values, SSubsInfo.class);
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTaskSkiped(String taskId) {
        Connection conn;
        ResultSet rs;
        PreparedStatement ps;
        boolean isSkiped;
        block5: {
            isSkiped = false;
            ps = null;
            rs = null;
            String state = "";
            conn = null;
            try {
                conn = TConnPool.getDefaultPool().getConnection();
                ps = conn.prepareStatement("SELECT task_intervene_state FROM flow_inst_node WHERE task_id=?");
                ps.setString(1, taskId);
                rs = ps.executeQuery();
                if (rs.next()) {
                    state = rs.getString("task_intervene_state");
                }
                if (state == null || !state.equals("1") && !state.equals("3")) break block5;
                isSkiped = true;
            }
            catch (SQLException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    SafeReleaseUtil.close(rs, null, ps);
                    TConnPool.getDefaultPool().releaseConnection(conn);
                    throw throwable;
                }
                SafeReleaseUtil.close(rs, null, ps);
                TConnPool.getDefaultPool().releaseConnection(conn);
            }
        }
        SafeReleaseUtil.close(rs, null, ps);
        TConnPool.getDefaultPool().releaseConnection(conn);
        return isSkiped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTaskState(String taskId) {
        Connection conn;
        String state;
        ResultSet rs;
        PreparedStatement ps;
        block4: {
            ps = null;
            rs = null;
            state = "";
            conn = null;
            try {
                conn = TConnPool.getDefaultPool().getConnection();
                ps = conn.prepareStatement("SELECT task_intervene_state FROM flow_inst_node WHERE task_id=?");
                ps.setString(1, taskId);
                rs = ps.executeQuery();
                if (!rs.next()) break block4;
                state = rs.getString("task_intervene_state");
            }
            catch (SQLException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    SafeReleaseUtil.close(rs, null, ps);
                    TConnPool.getDefaultPool().releaseConnection(conn);
                    throw throwable;
                }
                SafeReleaseUtil.close(rs, null, ps);
                TConnPool.getDefaultPool().releaseConnection(conn);
            }
        }
        SafeReleaseUtil.close(rs, null, ps);
        TConnPool.getDefaultPool().releaseConnection(conn);
        return state;
    }
}

