/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.plugins.core.assembly.imdbcp.datasource;

import com.irdstudio.sdk.plugins.core.assembly.imdbcp.datasource.DataSourceParm;
import com.irdstudio.sdk.plugins.core.assembly.imdbcp.encode.CustomConnection;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class DriverDataSource
implements DataSource {
    private DataSourceParm connParm;

    public DriverDataSource(DataSourceParm parm) {
        this.connParm = parm;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(this.connParm.getUser(), this.connParm.getPassword());
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        try {
            Class.forName(this.connParm.getDriver());
        }
        catch (ClassNotFoundException e) {
            throw new SQLException("\u6570\u636e\u5e93\u9a71\u52a8\u4e0d\u5b58\u5728\uff01");
        }
        Properties extendParm = (Properties)this.connParm.getExtendProperties().clone();
        extendParm.setProperty("user", username);
        extendParm.setProperty("password", password);
        Connection _con = DriverManager.getConnection(this.connParm.getUrl(), extendParm);
        CustomConnection _cscon = new CustomConnection(_con, this.connParm.getCharSet(), this.connParm.getEncodeType());
        return _cscon;
    }

    public void close() throws SQLException {
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return DriverManager.getLogWriter();
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return DriverManager.getLoginTimeout();
    }

    @Override
    public void setLogWriter(PrintWriter arg0) throws SQLException {
        DriverManager.setLogWriter(arg0);
    }

    @Override
    public void setLoginTimeout(int arg0) throws SQLException {
        DriverManager.setLoginTimeout(arg0);
    }

    public DataSourceParm getConnectionParm() {
        return this.connParm;
    }

    public void setConnectionParm(DataSourceParm connParm) {
        this.connParm = connParm;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }
}

