/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.plugins.core.plugin.check;

import com.irdstudio.sdk.plugins.core.plugin.check.PluginCheckConf;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginCheckConfDao {
    private static final Logger logger = LoggerFactory.getLogger(PluginCheckConfDao.class);
    Connection conn = null;

    public PluginCheckConfDao(Connection conn) {
        this.conn = conn;
    }

    public PluginCheckConf queryPluginCheckConfWithKeys(String pluginConfId, int confSort) throws SQLException {
        PluginCheckConf dc = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM urps.plugin_check_conf WHERE plugin_conf_id=?,conf_sort=? with ur");
            ps.setString(1, pluginConfId);
            ps.setInt(2, confSort);
            rs = ps.executeQuery();
            if (rs.next()) {
                dc = new PluginCheckConf();
                dc.setPluginConfId(rs.getString("plugin_conf_id"));
                dc.setConfSort(rs.getInt("conf_sort"));
                dc.setCheckItemName(rs.getString("check_item_name"));
                dc.setCheckItemSql(rs.getString("check_item_sql"));
                dc.setCheckSucCondition(rs.getString("check_suc_condition"));
                dc.setCheckErrDesc(rs.getString("check_err_desc"));
                dc.setCheckFaildDeal(rs.getString("check_faild_deal"));
                dc.setValidDate(rs.getString("valid_date"));
                dc.setInvalidDate(rs.getString("invalid_date"));
                dc.setLastModifyDate(rs.getString("last_modify_date"));
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryPluginCheckConfWithKeys is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dc;
    }

    public List<PluginCheckConf> queryPluginCheckConfWithPluginConfId(String pluginConfId) throws SQLException {
        ArrayList<PluginCheckConf> dcList = new ArrayList<PluginCheckConf>();
        PluginCheckConf dc = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM urps.plugin_check_conf WHERE plugin_conf_id=? order by conf_sort with ur");
            ps.setString(1, pluginConfId);
            rs = ps.executeQuery();
            while (rs.next()) {
                dc = new PluginCheckConf();
                dc.setPluginConfId(rs.getString("plugin_conf_id"));
                dc.setConfSort(rs.getInt("conf_sort"));
                dc.setCheckItemName(rs.getString("check_item_name"));
                dc.setCheckItemSql(rs.getString("check_item_sql"));
                dc.setCheckSucCondition(rs.getString("check_suc_condition"));
                dc.setCheckErrDesc(rs.getString("check_err_desc"));
                dc.setCheckFaildDeal(rs.getString("check_faild_deal"));
                dc.setValidDate(rs.getString("valid_date"));
                dc.setInvalidDate(rs.getString("invalid_date"));
                dc.setLastModifyDate(rs.getString("last_modify_date"));
                dcList.add(dc);
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryPluginCheckConfWithKeys is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dcList;
    }

    protected void close(ResultSet theRs, Statement theStmt, PreparedStatement thePs) {
        try {
            if (theRs != null) {
                theRs.close();
            }
            if (theStmt != null) {
                theStmt.close();
            }
            if (thePs != null) {
                thePs.close();
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
    }
}

