/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.plugins.core.plugin.common;

import com.irdstudio.sdk.plugins.core.plugin.common.FlowConfVariable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowConfVariableDao {
    private static final Logger logger = LoggerFactory.getLogger(FlowConfVariableDao.class);
    Connection conn = null;

    public FlowConfVariableDao(Connection conn) {
        this.conn = conn;
    }

    public FlowConfVariable queryFlowConfVariableWithKeys(String paramCode) throws SQLException {
        FlowConfVariable dc = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM flow_conf_variable WHERE param_code=?");
            ps.setString(1, paramCode);
            rs = ps.executeQuery();
            if (rs.next()) {
                dc = new FlowConfVariable();
                dc.setParamCode(rs.getString("param_code"));
                dc.setParamName(rs.getString("param_name"));
                dc.setParamValue(rs.getString("param_value"));
                dc.setParamScope(rs.getString("param_scope"));
                dc.setSubsCode(rs.getString("subs_code"));
                dc.setPluginId(rs.getInt("plugin_id"));
                dc.setRemark(rs.getString("remark"));
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryFlowConfVariableWithKeys is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dc;
    }

    public List<FlowConfVariable> queryAll() throws SQLException {
        ArrayList<FlowConfVariable> dcList = new ArrayList<FlowConfVariable>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM flow_conf_variable");
            rs = ps.executeQuery();
            while (rs.next()) {
                FlowConfVariable dc = new FlowConfVariable();
                dc.setParamCode(rs.getString("param_code"));
                dc.setParamName(rs.getString("param_name"));
                dc.setParamValue(rs.getString("param_value"));
                dc.setParamScope(rs.getString("param_scope"));
                dc.setSubsCode(rs.getString("subs_code"));
                dc.setPluginId(rs.getInt("plugin_id"));
                dc.setRemark(rs.getString("remark"));
                dcList.add(dc);
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryFlowConfVariableWithCond is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dcList;
    }

    protected void close(ResultSet theRs, Statement theStmt, PreparedStatement thePs) {
        try {
            if (theRs != null) {
                theRs.close();
            }
            if (theStmt != null) {
                theStmt.close();
            }
            if (thePs != null) {
                thePs.close();
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
    }
}

