/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.plugins.core.plugin.common;

import com.irdstudio.sdk.plugins.core.plugin.common.PluginConfSysupd;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginConfSysupdDao {
    private static final Logger logger = LoggerFactory.getLogger(PluginConfSysupdDao.class);
    Connection conn = null;

    public PluginConfSysupdDao(Connection conn) {
        this.conn = conn;
    }

    public PluginConfSysupd queryWithKeys(String pluginConfId, int confSort) throws SQLException {
        PluginConfSysupd dc = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM plugin_conf_sysupd WHERE plugin_conf_id=? and conf_sort=?");
            ps.setString(1, pluginConfId);
            ps.setInt(2, confSort);
            rs = ps.executeQuery();
            if (rs.next()) {
                dc = new PluginConfSysupd();
                dc.setPluginConfId(rs.getString("plugin_conf_id"));
                dc.setConfSort(rs.getInt("conf_sort"));
                dc.setSysupdAction(rs.getString("sysupd_action"));
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryPluginConfSysupdWithKeys is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dc;
    }

    public List<PluginConfSysupd> queryWithPluginConfId(String pluginConfId) throws SQLException {
        ArrayList<PluginConfSysupd> dcList = new ArrayList<PluginConfSysupd>();
        PluginConfSysupd dc = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM plugin_conf_sysupd WHERE plugin_conf_id=? order by conf_sort");
            ps.setString(1, pluginConfId);
            rs = ps.executeQuery();
            while (rs.next()) {
                dc = new PluginConfSysupd();
                dc.setPluginConfId(rs.getString("plugin_conf_id"));
                dc.setConfSort(rs.getInt("conf_sort"));
                dc.setSysupdAction(rs.getString("sysupd_action"));
                dcList.add(dc);
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryWithPluginConfId is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dcList;
    }

    protected void close(ResultSet theRs, Statement theStmt, PreparedStatement thePs) {
        try {
            if (theRs != null) {
                theRs.close();
            }
            if (theStmt != null) {
                theStmt.close();
            }
            if (thePs != null) {
                thePs.close();
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
    }
}

