/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.plugins.core.plugin.excel;

import com.irdstudio.sdk.plugins.core.plugin.datapack.PluginDatapackConfDao;
import com.irdstudio.sdk.plugins.core.plugin.excel.PluginExcelConf;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginExcelConfDao {
    private static final Logger logger = LoggerFactory.getLogger(PluginDatapackConfDao.class);
    Connection conn = null;

    public PluginExcelConfDao(Connection conn) {
        this.conn = conn;
    }

    public PluginExcelConf queryWithKeys(String pluginConfId, int confSort) throws SQLException {
        PluginExcelConf dc = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM plugin_excel_conf WHERE plugin_conf_id=? and conf_sort=?");
            ps.setString(1, pluginConfId);
            ps.setInt(2, confSort);
            rs = ps.executeQuery();
            if (rs.next()) {
                dc = new PluginExcelConf();
                dc.setPluginConfId(rs.getString("plugin_conf_id"));
                dc.setConfSort(rs.getInt("conf_sort"));
                dc.setExcelOperType(rs.getString("excel_oper_type"));
                dc.setConfigureFile(rs.getString("configure_file"));
                dc.setParamKeyValue(rs.getString("param_key_value"));
                dc.setFaildDeal(rs.getString("faild_deal"));
                dc.setLastModifyDate(rs.getString("last_modify_date"));
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryPluginExcelConfWithKeys is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dc;
    }

    public List<PluginExcelConf> queryWithPluginConfId(String pluginConfId) throws SQLException {
        ArrayList<PluginExcelConf> dcList = new ArrayList<PluginExcelConf>();
        PluginExcelConf dc = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM plugin_excel_conf WHERE plugin_conf_id=? order by conf_sort");
            ps.setString(1, pluginConfId);
            rs = ps.executeQuery();
            while (rs.next()) {
                dc = new PluginExcelConf();
                dc.setPluginConfId(rs.getString("plugin_conf_id"));
                dc.setConfSort(rs.getInt("conf_sort"));
                dc.setExcelOperType(rs.getString("excel_oper_type"));
                dc.setConfigureFile(rs.getString("configure_file"));
                dc.setParamKeyValue(rs.getString("param_key_value"));
                dc.setFaildDeal(rs.getString("faild_deal"));
                dc.setLastModifyDate(rs.getString("last_modify_date"));
                dcList.add(dc);
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryPluginExcelConfWithKeys is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dcList;
    }

    protected void close(ResultSet theRs, Statement theStmt, PreparedStatement thePs) {
        try {
            if (theRs != null) {
                theRs.close();
            }
            if (theStmt != null) {
                theStmt.close();
            }
            if (thePs != null) {
                thePs.close();
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
    }
}

