/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.plugins.core.plugin.sc;

import com.irdstudio.sdk.plugins.core.plugin.AbstractPlugin;
import com.irdstudio.sdk.plugins.core.plugin.sc.PluginScData;
import com.irdstudio.sdk.plugins.core.plugin.sc.PluginScDataDao;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class ScPlugin
extends AbstractPlugin {
    private List<PluginScData> dsList;
    private String shellDir;

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        PluginScDataDao dsDao = new PluginScDataDao(conn);
        this.dsList = dsDao.queryPluginScDataWithCond(" where plugin_conf_id='" + szConfIdentify + "'", "order by conf_sort");
        this.shellDir = this.binPath + "db2shell/";
        if (this.dsList.size() < 1) {
            this.context.setSzLastErrorMsg("\u672a\u8bfb\u53d6\u5230\u914d\u7f6e\u6807\u8bc6\u4e3a\uff1a" + szConfIdentify + "\u7684\u8f6c\u5b58\u6e05\u6570\u914d\u7f6e!");
            return false;
        }
        return true;
    }

    @Override
    public boolean execute() {
        boolean flag = true;
        for (int i = 0; i < this.dsList.size(); ++i) {
            PluginScData pds = this.dsList.get(i);
            if (this.isInValidConf(this.context.getCurrentDataDate(), pds.getValidDate(), pds.getInvalidDate())) continue;
            this.logger.info("........................................................................");
            this.logger.info("\u51c6\u5907\u8c03\u7528\u8f6c\u5b58\u6e05\u6570\u5904\u7406\uff1a" + pds.getScDesc() + "...");
            String[] cmdForSc = this.getFullScCmd(pds);
            boolean bResult = this.callExternCmd(cmdForSc);
            if (bResult) {
                this.writeSuccessLog("\u6267\u884c\u8f6c\u5b58\u6e05\u6570:" + pds.getScDesc());
                continue;
            }
            this.writeFaildLog("\u6267\u884c\u8f6c\u5b58\u6e05\u6570:" + pds.getScDesc());
            if ("1".equals(pds.getScFaildDeal())) continue;
            flag = false;
            break;
        }
        return flag;
    }

    private String[] getFullScCmd(PluginScData pds) {
        String dbName = this.context.getDataSourceInfo().getDsDbName();
        String dbUser = this.context.getDataSourceInfo().getDsUserId();
        String dbPwd = this.context.getDataSourceInfo().getDsUserPwd();
        String dbSchema = this.context.getDataSourceInfo().getDsSchemaName();
        String pathTmpData = this.context.getVv().getValue("path_tmpdata");
        String dataDate = this.context.getCurrentDataDate();
        String opType = pds.getOpType().toUpperCase();
        String opSql = pds.getOpSql();
        String writeTable = pds.getWirteTable();
        String day = "1 ";
        day = String.valueOf(this.getDay(dataDate));
        String[] cmdParams = null;
        if ("LDCRIST".equals(opType)) {
            cmdParams = new String[]{this.shellDir + "loadCursorForTask.sh", dbName, dbUser, dbPwd, dbSchema, opSql, writeTable, "insert"};
        } else if ("LDCRRPL".equals(opType)) {
            cmdParams = new String[]{this.shellDir + "loadCursorForTask.sh", dbName, dbUser, dbPwd, dbSchema, opSql, writeTable, "replace"};
        } else if ("LDCRMTAB".equals(opType)) {
            cmdParams = new String[]{this.shellDir + "loadCursorForMonthTab.sh", dbName, dbUser, dbPwd, dbSchema, opSql, writeTable, day};
        } else if ("LDFLIST".equals(opType)) {
            cmdParams = new String[]{this.shellDir + "loadFileForTask.sh", dbName, dbUser, dbPwd, dbSchema, opSql, writeTable, "insert", pathTmpData};
        } else if ("LDFLRPL".equals(opType)) {
            cmdParams = new String[]{this.shellDir + "loadFileForTask.sh", dbName, dbUser, dbPwd, dbSchema, opSql, writeTable, "replace", pathTmpData};
        } else if ("CLRTABDAT".equals(opType)) {
            cmdParams = new String[]{this.shellDir + "clearTableData.sh", dbName, dbUser, dbPwd, dbSchema, opSql};
        } else if ("DELPATM".equals(opType)) {
            cmdParams = new String[]{this.shellDir + "detachMonthPartion.sh", dbName, dbUser, dbPwd, dbSchema, writeTable, this.getMindate(pds, dataDate) + " "};
        }
        return cmdParams;
    }

    public String rpl(String str) {
        String tmp_str = "null";
        if (str != null) {
            tmp_str = tmp_str.replaceAll(" ", "");
        }
        return tmp_str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMindate(PluginScData pds, String sjrq) {
        Connection conn = null;
        String mindate = "";
        try {
            conn = this.getPluginConnection();
            PluginScDataDao dsDao = new PluginScDataDao(conn);
            mindate = dsDao.getMindate(sjrq, pds.getSaveM());
        }
        catch (SQLException e) {
            this.context.setSzLastErrorMsg(e.getMessage());
            e.printStackTrace();
        }
        finally {
            this.closePluginConnection(conn);
        }
        return mindate;
    }

    public int getDay(String sjrq) {
        return Integer.parseInt(sjrq.substring(9, 10));
    }
}

