/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.plugins.core.tinycore.jdbc.util;

import com.irdstudio.sdk.plugins.core.tinycore.jdbc.executor.SafeReleaseUtil;
import com.irdstudio.sdk.plugins.core.tinycore.jdbc.meta.MetaTable;
import com.irdstudio.sdk.plugins.core.tinycore.log.TLogger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class TableMove {
    private String srcTableName = "";
    private String destTableName = "";
    private Connection conn = null;
    private MetaTable srcMetaTable = null;
    private MetaTable destMetaTable = null;
    private String condition = " where 1=2";
    private Map<String, Object> map = new HashMap<String, Object>();

    public TableMove(Connection conn, String srcTableName, String destTableName) throws SQLException {
        this.conn = conn;
        this.srcMetaTable = MetaTable.getInstWithTable(conn, srcTableName);
        this.destMetaTable = MetaTable.getInstWithTable(conn, destTableName);
        this.srcTableName = srcTableName;
        this.destTableName = destTableName;
        this.addFullMapping();
    }

    public TableMove(Connection conn, String srcTableName, String destTableName, boolean isAutoFullMapping) throws SQLException {
        this.conn = conn;
        this.srcMetaTable = MetaTable.getInstWithTable(conn, srcTableName);
        this.destMetaTable = MetaTable.getInstWithTable(conn, destTableName);
        this.srcTableName = srcTableName;
        this.destTableName = destTableName;
        if (isAutoFullMapping) {
            this.addFullMapping();
        }
    }

    public void setCondition(String cond) {
        if (StringUtils.isNotBlank((CharSequence)cond)) {
            this.condition = " " + cond;
        }
    }

    public void addFieldMapping(String destField, Object srcField) {
        if (this.map.get(destField = destField.toUpperCase()) != null) {
            this.map.remove(destField);
        }
        this.map.put(destField, srcField);
    }

    public void addValueMapping(String destField, Object srcValue) {
        if (this.map.get(destField) != null) {
            this.map.remove(destField);
        }
        if (srcValue instanceof String) {
            this.map.put(destField, "'" + srcValue + "'");
        } else {
            this.map.put(destField, srcValue);
        }
    }

    public void addFullMapping() throws SQLException {
        try {
            if (!this.srcMetaTable.isTableExist()) {
                throw new Exception("\u6e90\u8868\u3010" + this.srcTableName + "\u3011\u4e0d\u5b58\u5728\uff01");
            }
            if (!this.destMetaTable.isTableExist()) {
                throw new Exception("\u76ee\u6807\u8868\u3010" + this.destTableName + "\u3011\u4e0d\u5b58\u5728\uff01");
            }
            int srcFieldCount = this.srcMetaTable.fieldCount;
            String[] srcFields = this.srcMetaTable.fields;
            int[] srcFieldLengths = this.srcMetaTable.fieldLengths;
            int[] srcFieldTypes = this.srcMetaTable.fieldTypes;
            int destFieldCount = this.destMetaTable.fieldCount;
            String[] destFields = this.destMetaTable.fields;
            int[] destFieldLengths = this.destMetaTable.fieldLengths;
            int[] destFieldTypes = this.destMetaTable.fieldTypes;
            String[] destSigns = this.destMetaTable.signs;
            for (int i = 0; i < destFieldCount; ++i) {
                String destField = destFields[i];
                int destFieldLength = destFieldLengths[i];
                int destFieldType = destFieldTypes[i];
                String srcSign = destSigns[i];
                for (int j = 0; j < srcFieldCount; ++j) {
                    String srcField = srcFields[j];
                    int srcFieldLength = srcFieldLengths[j];
                    int srcFieldType = srcFieldTypes[j];
                    if (!srcField.equals(destField) || srcFieldLength != destFieldLength || srcFieldType != destFieldType) continue;
                    this.map.put(destField, srcField);
                    break;
                }
                if (this.map.get(destField) != null) continue;
                if (StringUtils.isNotBlank((CharSequence)srcSign)) {
                    this.map.put(destField, "''");
                    continue;
                }
                this.map.put(destField, 0);
            }
        }
        catch (Exception e) {
            TLogger.getLogger("util").info("\u6e90\u8868\u4e0e\u76ee\u6807\u4e4b\u95f4\u8fdb\u884c\u5168\u5b57\u6bb5\u6620\u5c04\u9519\u8bef\uff1a\n" + e.getMessage());
            throw new SQLException("addFullMapping is Wrong!" + e.getMessage());
        }
    }

    private String generateInsertSql() {
        StringBuffer sql = new StringBuffer("insert into " + this.destTableName + " (");
        StringBuffer destSqlStr = new StringBuffer();
        StringBuffer srcSqlStr = new StringBuffer();
        for (int i = 0; i < this.destMetaTable.fieldCount; ++i) {
            String destField = this.destMetaTable.fields[i];
            destSqlStr.append(destField);
            srcSqlStr.append(this.map.get(destField));
            if (i == this.destMetaTable.fields.length - 1) continue;
            destSqlStr.append(",");
            srcSqlStr.append(",");
        }
        sql.append(destSqlStr).append(" ) select ");
        sql.append(srcSqlStr).append(" from ").append(this.srcTableName);
        sql.append(this.condition);
        TLogger.getLogger("util").info(sql.toString());
        return sql.toString();
    }

    public boolean executeCopy() throws SQLException {
        PreparedStatement ps = null;
        boolean executeFlag = false;
        try {
            ps = this.conn.prepareStatement(this.generateInsertSql());
            ps.execute();
            executeFlag = true;
        }
        catch (SQLException e) {
            try {
                throw new SQLException("executeCopy is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                SafeReleaseUtil.close(ps);
                throw throwable;
            }
        }
        SafeReleaseUtil.close(ps);
        return executeFlag;
    }

    public boolean executeCut() throws SQLException {
        PreparedStatement ps = null;
        boolean executeFlag = false;
        try {
            if (this.executeCopy()) {
                TLogger.getLogger("util").info("delete from " + this.srcTableName + this.condition);
                ps = this.conn.prepareStatement("delete from " + this.srcTableName + this.condition);
                executeFlag = ps.execute();
            }
        }
        catch (SQLException e) {
            throw new SQLException("executeCut is Wrong!" + e.getMessage());
        }
        finally {
            SafeReleaseUtil.close(ps);
        }
        return executeFlag;
    }
}

