/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.plugins.core.utils.date;

import com.irdstudio.sdk.plugins.core.utils.date.DateConvert;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateCalculate {
    public static Date getLastDateOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, cal.getActualMaximum(5));
        return cal.getTime();
    }

    public static int months(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(date1);
        cal2.setTime(date2);
        return 12 * (cal2.get(1) - cal1.get(1)) + cal2.get(2) - cal1.get(2);
    }

    public static int days(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(date1);
        cal2.setTime(date2);
        int days = (int)((cal2.getTimeInMillis() - cal1.getTimeInMillis()) / 1000L / 60L / 60L / 24L);
        if (days == 0 && date2.before(date1)) {
            days = -1;
        }
        return days;
    }

    public static Date addDays(Date date, int days) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, days);
        return cal.getTime();
    }

    public static Date addMonths(Date date, int months) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, months);
        return cal.getTime();
    }

    public static Date getLastDayOfYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(2, 11);
        cal.set(5, 31);
        return cal.getTime();
    }

    public static Date getFirstDateOfNextMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, 1);
        cal.set(5, 1);
        return cal.getTime();
    }

    public static Date getFirstDateOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, 1);
        return cal.getTime();
    }

    public static Date getFirstDateOfMonth(int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(2, month - 1);
        cal.set(5, 1);
        return cal.getTime();
    }

    public static Date getLastDayOfNextYear(Date date) {
        Date _date = DateCalculate.getLastDayOfYear(date);
        Calendar cal = Calendar.getInstance();
        cal.setTime(_date);
        cal.add(1, 1);
        return cal.getTime();
    }

    public static Date getFirstDayOfYear() {
        Calendar cal = Calendar.getInstance();
        cal.set(2, 0);
        cal.set(6, 1);
        return cal.getTime();
    }

    public static Date getNextThreeMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (cal.get(2) >= 8) {
            cal.set(2, 11);
        } else {
            cal.add(2, 3);
        }
        cal.set(5, 1);
        cal.set(5, cal.getActualMaximum(5));
        return cal.getTime();
    }

    public static Date getLastDateOfMonth(int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(2, month - 1);
        cal.set(5, 1);
        cal.set(5, cal.getActualMaximum(5));
        return DateCalculate.getLastDateOfMonth(cal.getTime());
    }

    public static int getMonthOfDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(2) + 1;
    }

    public static int getDayOfDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(5);
    }

    public static int getYearOfDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(1);
    }

    public static BigDecimal computeIntervalMills(String startTime, String endTime, String format) {
        Calendar cal = Calendar.getInstance();
        long startMills = 0L;
        long endMills = 0L;
        try {
            cal.setTime(new SimpleDateFormat(format).parse(startTime));
            startMills = cal.getTimeInMillis();
            cal.setTime(new SimpleDateFormat(format).parse(endTime));
            endMills = cal.getTimeInMillis();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return new BigDecimal(endMills - startMills).divide(BigDecimal.valueOf(1000.0));
    }

    public static BigDecimal computeIntervalMills(String startTime, String endTime) {
        return DateCalculate.computeIntervalMills(startTime, endTime, "yyyy-MM-dd HH:mm:ss");
    }

    public static Date getMaxDate(Date date1, Date date2) {
        return date1.after(date2) ? date1 : date2;
    }

    public static boolean equals(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(date1);
        cal2.setTime(date2);
        return cal1.get(1) == cal2.get(1) && cal1.get(2) == cal2.get(2) && cal1.get(5) == cal2.get(5);
    }

    public static void main(String[] args) {
        System.out.println(DateCalculate.addDays(new Date(), 1));
        System.out.println("\u65e5\u671f+1:" + DateConvert.toString(DateCalculate.addDays(DateConvert.toDateWithSeparate1("2013-02-28"), 1)));
        System.out.println("\u65e5\u671f-1:" + DateConvert.toString(DateCalculate.addDays(DateConvert.toDateWithSeparate1("2013-02-28"), -1)));
        System.out.println("\u65e5\u671f-1:" + DateConvert.toString(DateCalculate.addDays(DateConvert.toDateWithSeparate1("2013-03-01"), -1)));
        System.out.println("\u65e5\u671f+1:" + DateConvert.toString(DateCalculate.addDays(DateConvert.toDateWithSeparate1("2012-02-28"), 1)));
        System.out.println("\u65e5\u671f+1:" + DateConvert.toString(DateCalculate.addDays(DateConvert.toDateWithSeparate1("2012-02-29"), 1)));
        System.out.println("\u65e5\u671f-1:" + DateConvert.toString(DateCalculate.addDays(DateConvert.toDateWithSeparate1("2012-03-01"), -1)));
    }
}

