/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinpaas.console.dmcenter.api.rest;

import com.irdstudio.allinpaas.console.dmcenter.common.util.CurrentDateUtil;
import com.irdstudio.allinpaas.console.dmcenter.common.util.KeyUtil;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.DiagramBaseInfoService;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.DiagramBaseInfoVO;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.AbstractController;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class DiagramBaseInfoController
extends AbstractController {
    @Autowired
    @Qualifier(value="diagramBaseInfoService")
    private DiagramBaseInfoService diagramBaseInfoService;

    @RequestMapping(value={"/diagram/base/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<DiagramBaseInfoVO>> queryDiagramBaseInfoAll(DiagramBaseInfoVO vo) {
        List<DiagramBaseInfoVO> outputVo = this.diagramBaseInfoService.queryAllOwner(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/diagram/base/info/{diagramId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<DiagramBaseInfoVO> queryByPk(@PathVariable(value="diagramId") String diagramId) {
        DiagramBaseInfoVO inVo = new DiagramBaseInfoVO();
        inVo.setDiagramId(diagramId);
        DiagramBaseInfoVO outputVo = this.diagramBaseInfoService.queryByPk(inVo);
        return this.getResponseData((Object)outputVo);
    }

    @RequestMapping(value={"/diagram/base/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody DiagramBaseInfoVO inDiagramBaseInfoVo) {
        int outputVo = this.diagramBaseInfoService.deleteByPk(inDiagramBaseInfoVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/diagram/base/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody DiagramBaseInfoVO inDiagramBaseInfoVo) {
        int outputVo = this.diagramBaseInfoService.updateByPk(inDiagramBaseInfoVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/diagram/base/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertDiagramBaseInfo(@RequestBody DiagramBaseInfoVO inDiagramBaseInfoVo) {
        this.setUserInfoToVO((Object)inDiagramBaseInfoVo);
        inDiagramBaseInfoVo.setDiagramId(KeyUtil.createUUIDKey());
        inDiagramBaseInfoVo.setCreateUser(this.getUserInfo().getUserId());
        inDiagramBaseInfoVo.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = this.diagramBaseInfoService.insertDiagramBaseInfo(inDiagramBaseInfoVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/diagram/base/info/flowdata"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Map<String, Object>> queryBpmBaseInfoFlowData(@RequestBody DiagramBaseInfoVO inDiagramBaseInfoVo) {
        Map<String, Object> res = this.diagramBaseInfoService.queryDiagramData(inDiagramBaseInfoVo);
        return this.getResponseData(res);
    }

    @RequestMapping(value={"/diagram/base/info/saveflowdata"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Boolean> queryBpmBaseInfoFlowData(@RequestBody Map<String, Object> flowData) {
        Boolean res = this.diagramBaseInfoService.saveDiagramData(flowData);
        return this.getResponseData(res);
    }
}

