/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinpaas.console.dmcenter.api.rest;

import com.irdstudio.allinpaas.console.dmcenter.common.annotations.DictDevLogAnno;
import com.irdstudio.allinpaas.console.dmcenter.common.enums.CategoryPackagePrefix;
import com.irdstudio.allinpaas.console.dmcenter.common.enums.DictLogChangeType;
import com.irdstudio.allinpaas.console.dmcenter.common.enums.PackageLevel;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.DictCategoryInfoService;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.DictCategoryInfoVO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.AbstractController;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class DictCategoryInfoController
extends AbstractController {
    @Autowired
    @Qualifier(value="dictCategoryInfoServiceImpl")
    private DictCategoryInfoService dictCategoryInfoService;

    @RequestMapping(value={"/dict/category/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<DictCategoryInfoVO>> queryDictCategoryInfoAll(DictCategoryInfoVO vo) {
        List<DictCategoryInfoVO> outputVo = this.dictCategoryInfoService.queryAllOwner(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/dict/category/info/{packageId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<DictCategoryInfoVO> queryByPk(@PathVariable(value="packageId") String packageId) {
        DictCategoryInfoVO inVo = new DictCategoryInfoVO();
        inVo.setPackageId(packageId);
        DictCategoryInfoVO outputVo = this.dictCategoryInfoService.queryByPk(inVo);
        return this.getResponseData((Object)outputVo);
    }

    @DictDevLogAnno(action=DictLogChangeType.Delete, logCatalog="category", itemId="${args[0].packageId}", itemCode="${old.packageCode}", itemName="${old.packageName}")
    @RequestMapping(value={"/dict/category/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody DictCategoryInfoVO inDictCategoryInfoVo) {
        int outputVo = this.dictCategoryInfoService.deleteByPk(inDictCategoryInfoVo);
        return this.getResponseData(outputVo);
    }

    @DictDevLogAnno(action=DictLogChangeType.Update, logCatalog="category", itemId="${args[0].packageId}", itemCode="${args[0].packageCode}", itemName="${args[0].packageName}")
    @RequestMapping(value={"/dict/category/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody DictCategoryInfoVO inDictCategoryInfoVo) {
        this.setUserInfoToVO((Object)inDictCategoryInfoVo);
        inDictCategoryInfoVo.setLastModifyUser(inDictCategoryInfoVo.getLoginUserId());
        inDictCategoryInfoVo.setLastModifyTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = this.dictCategoryInfoService.updateByPk(inDictCategoryInfoVo);
        return this.getResponseData(outputVo);
    }

    @DictDevLogAnno(action=DictLogChangeType.Add, logCatalog="category", itemId="${args[0].packageId}", itemCode="${args[0].packageCode}", itemName="${args[0].packageName}")
    @RequestMapping(value={"/dict/category/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertDictCategoryInfo(@RequestBody DictCategoryInfoVO inDictCategoryInfoVo) {
        this.setUserInfoToVO((Object)inDictCategoryInfoVo);
        if (StringUtils.isBlank((CharSequence)inDictCategoryInfoVo.getPackageId())) {
            String prefix = CategoryPackagePrefix.Theme.getCode();
            if (StringUtils.equals((CharSequence)inDictCategoryInfoVo.getPackageLevel(), (CharSequence)PackageLevel.Theme.getCode())) {
                prefix = CategoryPackagePrefix.Theme.getCode();
            } else if (StringUtils.equals((CharSequence)inDictCategoryInfoVo.getPackageLevel(), (CharSequence)PackageLevel.FirstLevel.getCode())) {
                prefix = CategoryPackagePrefix.FirstLevel.getCode();
            } else if (StringUtils.equals((CharSequence)inDictCategoryInfoVo.getPackageLevel(), (CharSequence)PackageLevel.SecondLevel.getCode())) {
                prefix = CategoryPackagePrefix.SecondLevel.getCode();
            } else if (StringUtils.equals((CharSequence)inDictCategoryInfoVo.getPackageLevel(), (CharSequence)PackageLevel.ThirdLevel.getCode())) {
                prefix = CategoryPackagePrefix.ThirdLevel.getCode();
            }
            inDictCategoryInfoVo.setPackageId(this.dictCategoryInfoService.getSequencePackageId(prefix));
        }
        inDictCategoryInfoVo.setCreateUser(inDictCategoryInfoVo.getLoginUserId());
        inDictCategoryInfoVo.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = this.dictCategoryInfoService.insertDictCategoryInfo(inDictCategoryInfoVo);
        return this.getResponseData(outputVo);
    }
}

