/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinpaas.console.dmcenter.api.rest;

import com.irdstudio.allinpaas.console.dmcenter.common.annotations.DictDevLogAnno;
import com.irdstudio.allinpaas.console.dmcenter.common.enums.DictLogChangeType;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.DictIndexInfoService;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.DictIndexInfoVO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.AbstractController;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class DictIndexInfoController
extends AbstractController {
    @Autowired
    @Qualifier(value="dictIndexInfoServiceImpl")
    private DictIndexInfoService dictIndexInfoService;

    @RequestMapping(value={"/dict/index/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<DictIndexInfoVO>> queryDictIndexInfoAll(DictIndexInfoVO vo) {
        List<DictIndexInfoVO> outputVo = this.dictIndexInfoService.queryAllOwner(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/dict/index/info/{idxId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<DictIndexInfoVO> queryByPk(@PathVariable(value="idxId") String idxId) {
        DictIndexInfoVO inVo = new DictIndexInfoVO();
        inVo.setIdxId(idxId);
        DictIndexInfoVO outputVo = this.dictIndexInfoService.queryByPk(inVo);
        return this.getResponseData((Object)outputVo);
    }

    @DictDevLogAnno(action=DictLogChangeType.Delete, logCatalog="index", itemId="${args[0].idxId}", itemName="${old.idxName}", itemCommName="${old.idxCommName}")
    @RequestMapping(value={"/dict/index/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody DictIndexInfoVO inDictIndexInfoVo) {
        int outputVo = this.dictIndexInfoService.deleteByPk(inDictIndexInfoVo);
        return this.getResponseData(outputVo);
    }

    @DictDevLogAnno(action=DictLogChangeType.Update, logCatalog="index", itemId="${args[0].idxId}", itemName="${args[0].idxName}", itemCommName="${args[0].idxCommName}")
    @RequestMapping(value={"/dict/index/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody DictIndexInfoVO inDictIndexInfoVo) {
        this.setUserInfoToVO((Object)inDictIndexInfoVo);
        inDictIndexInfoVo.setLastModifyUser(inDictIndexInfoVo.getLoginUserId());
        inDictIndexInfoVo.setLastModifyTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = this.dictIndexInfoService.updateByPk(inDictIndexInfoVo);
        return this.getResponseData(outputVo);
    }

    @DictDevLogAnno(action=DictLogChangeType.Add, logCatalog="index", itemId="${args[0].idxId}", itemName="${old.idxName}", itemCommName="${old.idxCommName}")
    @RequestMapping(value={"/dict/index/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertDictIndexInfo(@RequestBody DictIndexInfoVO inDictIndexInfoVo) {
        this.setUserInfoToVO((Object)inDictIndexInfoVo);
        if (StringUtils.isBlank((CharSequence)inDictIndexInfoVo.getIdxId())) {
            inDictIndexInfoVo.setIdxId(UUIDUtil.getUUID());
        }
        inDictIndexInfoVo.setCreateUser(inDictIndexInfoVo.getLoginUserId());
        inDictIndexInfoVo.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = this.dictIndexInfoService.insertDictIndexInfo(inDictIndexInfoVo);
        return this.getResponseData(outputVo);
    }
}

