/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinpaas.console.dmcenter.api.rest;

import com.irdstudio.allinpaas.console.dmcenter.service.facade.DictItemExtService;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.DictItemExtVO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.AbstractController;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class DictItemExtController
extends AbstractController {
    @Autowired
    @Qualifier(value="dictItemExtServiceImpl")
    private DictItemExtService dictItemExtService;

    @RequestMapping(value={"/dict/item/exts"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<DictItemExtVO>> queryDictItemExtAll(DictItemExtVO vo) {
        List<DictItemExtVO> outputVo = this.dictItemExtService.queryAllOwner(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/dict/item/ext/{extId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<DictItemExtVO> queryByPk(@PathVariable(value="extId") String extId) {
        DictItemExtVO inVo = new DictItemExtVO();
        inVo.setExtId(extId);
        DictItemExtVO outputVo = this.dictItemExtService.queryByPk(inVo);
        return this.getResponseData((Object)outputVo);
    }

    @RequestMapping(value={"/dict/item/ext"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody DictItemExtVO inDictItemExtVo) {
        int outputVo = this.dictItemExtService.deleteByPk(inDictItemExtVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/dict/item/ext"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody DictItemExtVO inDictItemExtVo) {
        int outputVo = this.dictItemExtService.updateByPk(inDictItemExtVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/dict/item/ext"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertDictItemExt(@RequestBody DictItemExtVO inDictItemExtVo) {
        this.setUserInfoToVO((Object)inDictItemExtVo);
        if (StringUtils.isBlank((CharSequence)inDictItemExtVo.getExtId())) {
            inDictItemExtVo.setExtId(UUIDUtil.getUUID());
        }
        inDictItemExtVo.setCreateUser(inDictItemExtVo.getLoginUserId());
        inDictItemExtVo.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = this.dictItemExtService.insertDictItemExt(inDictItemExtVo);
        return this.getResponseData(outputVo);
    }
}

