/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinpaas.console.dmcenter.api.rest;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.irdstudio.allinpaas.console.dmcenter.common.annotations.DictDevLogAnno;
import com.irdstudio.allinpaas.console.dmcenter.common.enums.AccessLevel;
import com.irdstudio.allinpaas.console.dmcenter.common.enums.CatePackageType;
import com.irdstudio.allinpaas.console.dmcenter.common.enums.CategoryPackagePrefix;
import com.irdstudio.allinpaas.console.dmcenter.common.enums.DictLogChangeType;
import com.irdstudio.allinpaas.console.dmcenter.common.enums.PackageLevel;
import com.irdstudio.allinpaas.console.dmcenter.common.enums.PublishState;
import com.irdstudio.allinpaas.console.dmcenter.common.enums.SuitType;
import com.irdstudio.allinpaas.console.dmcenter.common.util.CurrentDateUtil;
import com.irdstudio.allinpaas.console.dmcenter.common.util.KeyUtil;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.DictCategoryInfoService;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.DictDevLogService;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.DictItemInfoService;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.DictOptionEnumService;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.DictOptionInfoService;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.ModelTableFieldService;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.PubDatatypeService;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.PubDbmsDatatypeService;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.DictCategoryInfoVO;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.DictDevLogVO;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.DictItemInfoVO;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.DictOptionEnumVO;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.DictOptionInfoVO;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.DictOptionVO;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.ModelTableFieldVO;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.PubDatatypeVO;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.PubDbmsDatatypeVO;
import com.irdstudio.allinpaas.executor.core.plugin.datarefactor.AnalysisTableMatchItemTask;
import com.irdstudio.allinpaas.executor.core.plugin.docs.git.queue.DocTemplateRepoPullQueueExecutor;
import com.irdstudio.sdk.beans.core.util.ResourceCloseUtil;
import com.irdstudio.sdk.beans.core.util.TimeUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.core.vo.UserInfo;
import com.irdstudio.sdk.beans.web.controller.AbstractController;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api"})
public class DictItemInfoController
extends AbstractController {
    @Autowired
    @Qualifier(value="dictItemInfoService")
    private DictItemInfoService dictItemInfoService;
    @Autowired
    @Qualifier(value="dictOptionInfoService")
    private DictOptionInfoService dictOptionInfoService;
    @Autowired
    @Qualifier(value="dictOptionEnumService")
    private DictOptionEnumService dictOptionEnumService;
    @Autowired
    @Qualifier(value="dictCategoryInfoServiceImpl")
    private DictCategoryInfoService dictCategoryInfoService;
    @Autowired
    @Qualifier(value="modelTableFieldService")
    private ModelTableFieldService modelTableFieldService;
    @Autowired
    @Qualifier(value="pubDbmsDatatypeService")
    private PubDbmsDatatypeService pubDbmsDatatypeService;
    @Autowired
    @Qualifier(value="pubDatatypeService")
    private PubDatatypeService pubDatatypeService;
    @Autowired
    @Qualifier(value="dictDevLogServiceImpl")
    private DictDevLogService dictDevLogService;
    @Value(value="${tdp.docs.path}")
    private String DOCS_PATH;
    private final int loadPageSize = 500;

    @DictDevLogAnno(action=DictLogChangeType.Add, logCatalog="item", itemId="${args[0].itemId}", itemCode="${args[0].itemCode}", itemName="${args[0].itemName}")
    @PostMapping(value={"/dict/item/info"})
    @ResponseBody
    public ResponseData<Integer> insertDictItemInfo(@RequestBody DictItemInfoVO inDictItemInfoVo) {
        if (StringUtils.isBlank((String)inDictItemInfoVo.getItemId())) {
            inDictItemInfoVo.setItemId(KeyUtil.createUUIDKey());
        }
        inDictItemInfoVo.setCreateUser(this.getUserInfo().getUserId());
        inDictItemInfoVo.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = this.dictItemInfoService.insertDictItemInfo(inDictItemInfoVo);
        return this.getResponseData(outputVo);
    }

    @DictDevLogAnno(action=DictLogChangeType.Add, logCatalog="item", itemId="${args[0].itemId}", itemCode="${args[0].fieldCode}", itemName="${args[0].fieldName}")
    @PostMapping(value={"/dict/item/info/field"})
    @ResponseBody
    public ResponseData<String> insertDictItemInfoFormField(@RequestParam(value="projectId") String projectId, @RequestBody ModelTableFieldVO fieldVO) {
        List<PubDbmsDatatypeVO> pubDbmsDatatypeVOS = this.pubDbmsDatatypeService.queryDbmsTypeByModelTableInfoObjectId(fieldVO.getObjectId());
        DictItemInfoVO inDictItemInfoVO = new DictItemInfoVO();
        inDictItemInfoVO.setItemName(fieldVO.getFieldName());
        List<DictItemInfoVO> exists = this.dictItemInfoService.queryAllByLevelOne(inDictItemInfoVO);
        if (CollectionUtils.isNotEmpty(exists)) {
            ResponseData resp = this.getResponseData("");
            resp.setMessage("\u8be5\u6570\u636e\u9879\u5df2\u5b58\u5728");
            return resp;
        }
        String itemId = this.dictItemInfoService.querySeqWithPrefix(projectId);
        inDictItemInfoVO.setItemId(itemId);
        inDictItemInfoVO.setItemCode(fieldVO.getFieldCode());
        Integer itemDataType = null;
        for (PubDbmsDatatypeVO pdd : pubDbmsDatatypeVOS) {
            if (!StringUtils.equals((String)pdd.getDbmsDatatypeCode(), (String)fieldVO.getFieldType())) continue;
            itemDataType = pdd.getDatatypeId();
        }
        inDictItemInfoVO.setItemDataType(itemDataType);
        inDictItemInfoVO.setItemDataLength(fieldVO.getFieldLength());
        inDictItemInfoVO.setItemDataPrecision(fieldVO.getFieldPrecision());
        inDictItemInfoVO.setProjectId(projectId);
        inDictItemInfoVO.setAccessLevel(AccessLevel.PrivateLevel.getCode());
        inDictItemInfoVO.setPublishState(PublishState.Draft.getCode());
        inDictItemInfoVO.setCreateUser(this.getUserInfo().getUserId());
        inDictItemInfoVO.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = this.dictItemInfoService.insertDictItemInfo(inDictItemInfoVO);
        ResponseData resp = this.getResponseData(itemId);
        resp.setMessage(outputVo == 1 ? "\u521b\u5efa\u6210\u529f" : "\u521b\u5efa\u5931\u8d25");
        return resp;
    }

    @DictDevLogAnno(action=DictLogChangeType.Delete, logCatalog="item", itemId="${args[0].itemId}", itemCode="${old.itemCode}", itemName="${old.itemName}")
    @DeleteMapping(value={"/dict/item/info"})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody DictItemInfoVO inDictItemInfoVo) {
        int outputVo = this.dictItemInfoService.deleteByPk(inDictItemInfoVo);
        return this.getResponseData(outputVo);
    }

    @DictDevLogAnno(action=DictLogChangeType.Update, logCatalog="item", itemId="${args[0].itemId}", itemCode="${args[0].itemCode}", itemName="${args[0].itemName}")
    @PutMapping(value={"/dict/item/info"})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody DictItemInfoVO inDictItemInfoVo) {
        int outputVo = this.dictItemInfoService.updateByPk(inDictItemInfoVo);
        return this.getResponseData(outputVo);
    }

    @GetMapping(value={"/dict/item/info/{itemId}"})
    @ResponseBody
    public ResponseData<DictItemInfoVO> queryByPk(@PathVariable(value="itemId") String itemId) {
        DictItemInfoVO inVo = new DictItemInfoVO();
        inVo.setItemId(itemId);
        DictItemInfoVO outputVo = this.dictItemInfoService.queryByPk(inVo);
        return this.getResponseData((Object)outputVo);
    }

    @RequestMapping(value={"/my/dict/item/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<DictItemInfoVO>> queryMyDictItemInfoAll(DictItemInfoVO vo) {
        List<DictItemInfoVO> outputVo = null;
        this.setUserInfoToVO((Object)vo);
        outputVo = this.dictItemInfoService.queryAllByLevelOne(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/dict/item/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<DictItemInfoVO>> queryPublicDictItemInfoAll(DictItemInfoVO vo) {
        List<DictItemInfoVO> outputVo = null;
        this.setUserInfoToVO((Object)vo);
        outputVo = this.dictItemInfoService.queryAllByLevelTwo(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/dict/item/info/clear/cached"}, method={RequestMethod.GET})
    public void clearItemCached() {
        AnalysisTableMatchItemTask.clearItemCached();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/dict/item/info/template"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Boolean> excelTemplateDownload(HttpServletResponse response) {
        ResponseData responseData;
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        try {
            int bytesRead;
            DocTemplateRepoPullQueueExecutor.syncRun();
            String templateRootPath = DocTemplateRepoPullQueueExecutor.getDocTemplatePath();
            File file = new File(templateRootPath + File.separator + "xlsx" + File.separator + "\u6570\u636e\u6807\u51c6_\u57fa\u7840\u6570\u636e\u6807\u51c6.xlsx");
            response.setContentType("application/vnd.ms-excel;charset=utf-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + new String("\u6570\u636e\u6807\u51c6_\u57fa\u7840\u6570\u636e\u6807\u51c6.xlsx".getBytes(), "iso-8859-1"));
            ServletOutputStream out = response.getOutputStream();
            bis = new BufferedInputStream(new FileInputStream(file));
            bos = new BufferedOutputStream((OutputStream)out);
            byte[] buff = new byte[2048];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                bos.write(buff, 0, bytesRead);
            }
            responseData = this.getResponseData(true);
            ResourceCloseUtil.closeInputStream((InputStream)bis);
        }
        catch (Exception e) {
            logger.error("\u4e0b\u8f7dexcel\u6a21\u578b\u5f02\u5e38", (Throwable)e);
            ResponseData responseData2 = this.getResponseData(false);
            return responseData2;
        }
        finally {
            ResourceCloseUtil.closeInputStream(bis);
            ResourceCloseUtil.closeOutputStream(bos);
        }
        ResourceCloseUtil.closeOutputStream((OutputStream)bos);
        return responseData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/dict/item/info/onlyItem/template"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Boolean> excelItemTemplateDownload(HttpServletResponse response) {
        ResponseData responseData;
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        try {
            int bytesRead;
            DocTemplateRepoPullQueueExecutor.syncRun();
            String templateRootPath = DocTemplateRepoPullQueueExecutor.getDocTemplatePath();
            File file = new File(templateRootPath + File.separator + "xlsx" + File.separator + "dictItemInfoTemplate.xlsx");
            response.setContentType("application/vnd.ms-excel;charset=utf-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + new String("\u6807\u51c6\u6570\u636e\u9879.xlsx".getBytes(), "iso-8859-1"));
            ServletOutputStream out = response.getOutputStream();
            bis = new BufferedInputStream(new FileInputStream(file));
            bos = new BufferedOutputStream((OutputStream)out);
            byte[] buff = new byte[2048];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                bos.write(buff, 0, bytesRead);
            }
            responseData = this.getResponseData(true);
            ResourceCloseUtil.closeInputStream((InputStream)bis);
        }
        catch (Exception e) {
            logger.error("\u4e0b\u8f7dexcel\u6a21\u578b\u5f02\u5e38", (Throwable)e);
            ResponseData responseData2 = this.getResponseData(false);
            return responseData2;
        }
        finally {
            ResourceCloseUtil.closeInputStream(bis);
            ResourceCloseUtil.closeOutputStream(bos);
        }
        ResourceCloseUtil.closeOutputStream((OutputStream)bos);
        return responseData;
    }

    @PostMapping(value={"/dict/item/info/onlyItem/excel"})
    @ResponseBody
    public ResponseData<String> uploadOnlyItemExcel(@RequestParam(value="excelUploadType") String excelUploadType, @RequestParam(value="accessLevel") String accessLevel, @RequestParam(value="projectId", required=false) String projectId, @RequestPart(value="file") MultipartFile file) {
        try {
            ArrayList list = new ArrayList();
            UserInfo userInfo = this.getUserInfo();
            String userId = userInfo.getUserId();
            String nowTime = CurrentDateUtil.getTodayDateEx2();
            PubDatatypeVO pubDatatype = new PubDatatypeVO();
            pubDatatype.setSize(1000);
            List<PubDatatypeVO> dataTypeList = this.pubDatatypeService.queryAllByLevelOne(pubDatatype);
            HashMap<String, PubDatatypeVO> dataTypeMap = new HashMap<String, PubDatatypeVO>();
            if (CollectionUtils.isNotEmpty(dataTypeList)) {
                for (PubDatatypeVO dt : dataTypeList) {
                    dataTypeMap.put(dt.getDatatypeId().toString(), dt);
                }
            }
            PubDbmsDatatypeVO dataTypeParam = new PubDbmsDatatypeVO();
            dataTypeParam.setDbmsId(425);
            dataTypeParam.setSize(1000);
            List<PubDbmsDatatypeVO> dbmsDataTypeList = this.pubDbmsDatatypeService.queryAllByLevelOne(dataTypeParam);
            HashMap<String, PubDbmsDatatypeVO> dbmsDataTypeMap = new HashMap<String, PubDbmsDatatypeVO>();
            if (CollectionUtils.isNotEmpty(dbmsDataTypeList)) {
                for (PubDbmsDatatypeVO dbmsDt : dbmsDataTypeList) {
                    PubDatatypeVO dt = (PubDatatypeVO)((Object)dataTypeMap.get(dbmsDt.getDatatypeId().toString()));
                    if (dt == null) {
                        dt = new PubDatatypeVO();
                    }
                    String datatypeName = dt.getDatatypeName();
                    dbmsDt.setDatatypeName(datatypeName);
                    dbmsDataTypeMap.put(String.format("%s-%s", datatypeName, dbmsDt.getDbmsDatatypeCode()), dbmsDt);
                    dbmsDataTypeMap.put(dbmsDt.getDbmsDatatypeCode().toLowerCase(), dbmsDt);
                }
            }
            String createTime = TimeUtil.getCurrentDateTime();
            ExcelReader excelReader = EasyExcel.read((InputStream)file.getInputStream()).build();
            DictItemExcelReadListener itemListener = new DictItemExcelReadListener(dbmsDataTypeMap);
            ReadSheet itemSheet = ((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcel.readSheet((Integer)0).registerReadListener((ReadListener)itemListener)).headRowNumber(Integer.valueOf(1))).build();
            excelReader.read(new ReadSheet[]{itemSheet});
            if (itemListener.getItemList().size() > 0) {
                ArrayList<DictCategoryInfoVO> cataList = new ArrayList<DictCategoryInfoVO>();
                HashMap<String, DictCategoryInfoVO> cataMap = new HashMap<String, DictCategoryInfoVO>();
                for (DictItemInfoVO item : itemListener.getItemList()) {
                    DictCategoryInfoVO cata3;
                    DictCategoryInfoVO cata2;
                    String subjectId = item.getSubjectId();
                    String cataId1 = item.getCataId1();
                    String cataId2 = item.getCataId2();
                    String cataId3 = item.getCataId3();
                    DictCategoryInfoVO subjectCata = (DictCategoryInfoVO)((Object)cataMap.get(subjectId));
                    DictCategoryInfoVO cata1 = (DictCategoryInfoVO)((Object)cataMap.get(cataId1));
                    if (cata1 == null) {
                        cata1 = new DictCategoryInfoVO();
                        cata1.setPackageLevel(PackageLevel.FirstLevel.getCode());
                        cata1.setPackageName(cataId1);
                        cata1.setPackageDesc(cataId1);
                        cata1.setCreateUser(userId);
                        cata1.setCreateTime(nowTime);
                        cata1.setPackageType(CatePackageType.Theme.getCode());
                        String packageId = this.dictCategoryInfoService.getSequencePackageId(CategoryPackagePrefix.FirstLevel.getCode());
                        int order = NumberUtils.toInt((String)packageId.substring(CategoryPackagePrefix.FirstLevel.getCode().length()), (int)1);
                        cata1.setOrderValue(order);
                        cata1.setPackageId(packageId);
                        cata1.setPackageCode(packageId);
                        cataList.add(cata1);
                        cataMap.put(cataId1, cata1);
                    }
                    if ((cata2 = (DictCategoryInfoVO)((Object)cataMap.get(cataId2))) == null) {
                        cata2 = new DictCategoryInfoVO();
                        cata2.setPackageLevel(PackageLevel.SecondLevel.getCode());
                        cata2.setPackageName(cataId2);
                        cata2.setPackageDesc(cataId2);
                        cata2.setCreateUser(userId);
                        cata2.setCreateTime(nowTime);
                        cata2.setPackageType(CatePackageType.Theme.getCode());
                        String packageId = this.dictCategoryInfoService.getSequencePackageId(CategoryPackagePrefix.SecondLevel.getCode());
                        int order = NumberUtils.toInt((String)packageId.substring(CategoryPackagePrefix.SecondLevel.getCode().length()), (int)1);
                        cata2.setOrderValue(order);
                        cata2.setPackageId(packageId);
                        cata2.setPackageCode(packageId);
                        cata2.setPackageAbvId(cata1.getPackageId());
                        cataList.add(cata2);
                        cataMap.put(cataId2, cata2);
                    }
                    if ((cata3 = (DictCategoryInfoVO)((Object)cataMap.get(cataId3))) == null) {
                        cata3 = new DictCategoryInfoVO();
                        cata3.setPackageLevel(PackageLevel.ThirdLevel.getCode());
                        cata3.setPackageName(cataId3);
                        cata3.setPackageDesc(cataId3);
                        cata3.setCreateUser(userId);
                        cata3.setCreateTime(nowTime);
                        cata3.setPackageType(CatePackageType.Theme.getCode());
                        String packageId = this.dictCategoryInfoService.getSequencePackageId(CategoryPackagePrefix.ThirdLevel.getCode());
                        int order = NumberUtils.toInt((String)packageId.substring(CategoryPackagePrefix.ThirdLevel.getCode().length()), (int)1);
                        cata3.setOrderValue(order);
                        cata3.setPackageId(packageId);
                        cata3.setPackageCode(packageId);
                        cata3.setPackageAbvId(cata2.getPackageId());
                        cataList.add(cata3);
                        cataMap.put(cataId3, cata3);
                    }
                    item.setCataId1(cata1.getPackageId());
                    item.setCataId2(cata2.getPackageId());
                    item.setCataId3(cata3.getPackageId());
                    item.setCreateUser(userId);
                    item.setCreateTime(nowTime);
                    item.setAccessLevel(accessLevel);
                    item.setProjectId(projectId);
                    if (!StringUtils.equals((String)"\u4e0d\u6d89\u53ca", (String)item.getDictId())) continue;
                    item.setDictId(null);
                    item.setDictCode(null);
                }
                this.dictItemInfoService.excelUpload(excelUploadType, itemListener.getItemList(), cataList);
            }
            this.clearItemCached();
            return this.getResponseData("S");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u5165\u6570\u636e\u6807\u51c6\u5931\u8d25 {}", (Object)e.getMessage(), (Object)e);
            return this.getResponseData("\u4e0a\u4f20\u5931\u8d25");
        }
    }

    @PostMapping(value={"/dict/item/info/excel"})
    @ResponseBody
    public ResponseData<String> uploadExcel(@RequestParam(value="excelUploadType") String excelUploadType, @RequestParam(value="accessLevel") String accessLevel, @RequestParam(value="projectId", required=false) String projectId, @RequestPart(value="file") MultipartFile file) {
        try {
            ArrayList list = new ArrayList();
            UserInfo userInfo = this.getUserInfo();
            String userId = userInfo.getUserId();
            String nowTime = CurrentDateUtil.getTodayDateEx2();
            PubDatatypeVO pubDatatype = new PubDatatypeVO();
            pubDatatype.setSize(1000);
            List<PubDatatypeVO> dataTypeList = this.pubDatatypeService.queryAllByLevelOne(pubDatatype);
            HashMap<String, PubDatatypeVO> dataTypeMap = new HashMap<String, PubDatatypeVO>();
            if (CollectionUtils.isNotEmpty(dataTypeList)) {
                for (PubDatatypeVO dt : dataTypeList) {
                    dataTypeMap.put(dt.getDatatypeId().toString(), dt);
                }
            }
            PubDbmsDatatypeVO dataTypeParam = new PubDbmsDatatypeVO();
            dataTypeParam.setDbmsId(425);
            dataTypeParam.setSize(1000);
            List<PubDbmsDatatypeVO> dbmsDataTypeList = this.pubDbmsDatatypeService.queryAllByLevelOne(dataTypeParam);
            HashMap<String, PubDbmsDatatypeVO> dbmsDataTypeMap = new HashMap<String, PubDbmsDatatypeVO>();
            if (CollectionUtils.isNotEmpty(dbmsDataTypeList)) {
                for (PubDbmsDatatypeVO dbmsDt : dbmsDataTypeList) {
                    PubDatatypeVO dt = (PubDatatypeVO)((Object)dataTypeMap.get(dbmsDt.getDatatypeId().toString()));
                    if (dt == null) {
                        dt = new PubDatatypeVO();
                    }
                    String datatypeName = dt.getDatatypeName();
                    dbmsDt.setDatatypeName(datatypeName);
                    dbmsDataTypeMap.put(String.format("%s-%s", datatypeName, dbmsDt.getDbmsDatatypeCode()), dbmsDt);
                    dbmsDataTypeMap.put(dbmsDt.getDbmsDatatypeCode().toLowerCase(), dbmsDt);
                }
            }
            String createTime = TimeUtil.getCurrentDateTime();
            ExcelReader excelReader = EasyExcel.read((InputStream)file.getInputStream()).build();
            DictOptionExcelReadListener optionListener = new DictOptionExcelReadListener();
            ReadSheet optionSheet = ((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcel.readSheet((Integer)2).registerReadListener((ReadListener)optionListener)).headRowNumber(Integer.valueOf(1))).build();
            DictItemExcelReadListener itemListener = new DictItemExcelReadListener(dbmsDataTypeMap);
            ReadSheet itemSheet = ((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcel.readSheet((Integer)3).registerReadListener((ReadListener)itemListener)).headRowNumber(Integer.valueOf(1))).build();
            excelReader.read(new ReadSheet[]{optionSheet, itemSheet});
            if (optionListener.getOptionList().size() > 0) {
                ArrayList<DictOptionInfoVO> optionInfoList = new ArrayList<DictOptionInfoVO>();
                HashMap<String, DictOptionInfoVO> optionInfoMap = new HashMap<String, DictOptionInfoVO>();
                for (DictOptionEnumVO e : optionListener.getOptionList()) {
                    String dictId = e.getDictId();
                    String dictCode = e.getDictCode();
                    String dictName = e.getDictName();
                    String publishState = e.getPublishState();
                    DictOptionInfoVO option = (DictOptionInfoVO)((Object)optionInfoMap.get(dictId));
                    if (option == null) {
                        option = new DictOptionInfoVO();
                        option.setDictId(dictId);
                        option.setDictCode(dictCode);
                        option.setDictName(dictName);
                        option.setPublishState(publishState);
                        option.setCreateUser(userId);
                        option.setCreateTime(nowTime);
                        option.setAccessLevel(accessLevel);
                        option.setProjectId(projectId);
                        optionInfoList.add(option);
                        optionInfoMap.put(dictId, option);
                    }
                    e.setOptionId(UUIDUtil.getUUID());
                    e.setLastModifyUser(userId);
                    e.setLastModifyTime(nowTime);
                }
                this.dictOptionInfoService.excelUpload(excelUploadType, optionInfoList, optionListener.getOptionList());
            }
            if (itemListener.getItemList().size() > 0) {
                ArrayList<DictCategoryInfoVO> cataList = new ArrayList<DictCategoryInfoVO>();
                HashMap<String, DictCategoryInfoVO> cataMap = new HashMap<String, DictCategoryInfoVO>();
                for (DictItemInfoVO item : itemListener.getItemList()) {
                    DictCategoryInfoVO cata3;
                    DictCategoryInfoVO cata2;
                    String subjectId = item.getSubjectId();
                    String cataId1 = item.getCataId1();
                    String cataId2 = item.getCataId2();
                    String cataId3 = item.getCataId3();
                    DictCategoryInfoVO subjectCata = (DictCategoryInfoVO)((Object)cataMap.get(subjectId));
                    DictCategoryInfoVO cata1 = (DictCategoryInfoVO)((Object)cataMap.get(cataId1));
                    if (cata1 == null) {
                        cata1 = new DictCategoryInfoVO();
                        cata1.setPackageLevel(PackageLevel.FirstLevel.getCode());
                        cata1.setPackageName(cataId1);
                        cata1.setPackageDesc(cataId1);
                        cata1.setCreateUser(userId);
                        cata1.setCreateTime(nowTime);
                        cata1.setPackageType(CatePackageType.Theme.getCode());
                        String packageId = this.dictCategoryInfoService.getSequencePackageId(CategoryPackagePrefix.FirstLevel.getCode());
                        int order = NumberUtils.toInt((String)packageId.substring(CategoryPackagePrefix.FirstLevel.getCode().length()), (int)1);
                        cata1.setOrderValue(order);
                        cata1.setPackageId(packageId);
                        cata1.setPackageCode(packageId);
                        cataList.add(cata1);
                        cataMap.put(cataId1, cata1);
                    }
                    if ((cata2 = (DictCategoryInfoVO)((Object)cataMap.get(cataId2))) == null) {
                        cata2 = new DictCategoryInfoVO();
                        cata2.setPackageLevel(PackageLevel.SecondLevel.getCode());
                        cata2.setPackageName(cataId2);
                        cata2.setPackageDesc(cataId2);
                        cata2.setCreateUser(userId);
                        cata2.setCreateTime(nowTime);
                        cata2.setPackageType(CatePackageType.Theme.getCode());
                        String packageId = this.dictCategoryInfoService.getSequencePackageId(CategoryPackagePrefix.SecondLevel.getCode());
                        int order = NumberUtils.toInt((String)packageId.substring(CategoryPackagePrefix.SecondLevel.getCode().length()), (int)1);
                        cata2.setOrderValue(order);
                        cata2.setPackageId(packageId);
                        cata2.setPackageCode(packageId);
                        cata2.setPackageAbvId(cata1.getPackageId());
                        cataList.add(cata2);
                        cataMap.put(cataId2, cata2);
                    }
                    if ((cata3 = (DictCategoryInfoVO)((Object)cataMap.get(cataId3))) == null) {
                        cata3 = new DictCategoryInfoVO();
                        cata3.setPackageLevel(PackageLevel.ThirdLevel.getCode());
                        cata3.setPackageName(cataId3);
                        cata3.setPackageDesc(cataId3);
                        cata3.setCreateUser(userId);
                        cata3.setCreateTime(nowTime);
                        cata3.setPackageType(CatePackageType.Theme.getCode());
                        String packageId = this.dictCategoryInfoService.getSequencePackageId(CategoryPackagePrefix.ThirdLevel.getCode());
                        int order = NumberUtils.toInt((String)packageId.substring(CategoryPackagePrefix.ThirdLevel.getCode().length()), (int)1);
                        cata3.setOrderValue(order);
                        cata3.setPackageId(packageId);
                        cata3.setPackageCode(packageId);
                        cata3.setPackageAbvId(cata2.getPackageId());
                        cataList.add(cata3);
                        cataMap.put(cataId3, cata3);
                    }
                    item.setCataId1(cata1.getPackageId());
                    item.setCataId2(cata2.getPackageId());
                    item.setCataId3(cata3.getPackageId());
                    item.setCreateUser(userId);
                    item.setCreateTime(nowTime);
                    item.setAccessLevel(accessLevel);
                    item.setProjectId(projectId);
                    if (!StringUtils.equals((String)"\u4e0d\u6d89\u53ca", (String)item.getDictId())) continue;
                    item.setDictId(null);
                    item.setDictCode(null);
                }
                this.dictItemInfoService.excelUpload(excelUploadType, itemListener.getItemList(), cataList);
            }
            this.clearItemCached();
            return this.getResponseData("S");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u5165\u6570\u636e\u6807\u51c6\u5931\u8d25 {}", (Object)e.getMessage(), (Object)e);
            return this.getResponseData("\u4e0a\u4f20\u5931\u8d25");
        }
    }

    @GetMapping(value={"/dict/summary/index"})
    @ResponseBody
    public ResponseData<Map<String, Object>> queryStandardSummary(Map<String, Object> param) {
        Map<String, Object> outputVo = this.dictItemInfoService.queryStandardSummary(param);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/dict/std/counts"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, Object>>> queryStdSummaryList(Map<String, Object> param) {
        List<Map<String, Object>> outputVo = null;
        outputVo = this.dictItemInfoService.queryStdSummaryList(param);
        return this.getResponseData(outputVo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/dict/item/info/download"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Boolean> excelDownload(HttpServletResponse response) {
        ResponseData responseData;
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        try {
            int bytesRead;
            String today = CurrentDateUtil.getTodayDate();
            DocTemplateRepoPullQueueExecutor.syncRun();
            String templateRootPath = DocTemplateRepoPullQueueExecutor.getDocTemplatePath();
            File templateFile = new File(templateRootPath + File.separator + "xlsx" + File.separator + "\u6570\u636e\u6807\u51c6_\u57fa\u7840\u6570\u636e\u6807\u51c6-\u6a21\u677f.xlsx");
            response.setContentType("application/vnd.ms-excel;charset=utf-8");
            String downloadFileName = String.format("\u6570\u636e\u5f00\u53d1\u5e73\u53f0_\u6570\u636e\u6807\u51c6_%s.xlsx", today);
            response.setHeader("Content-Disposition", "attachment;filename=" + new String(downloadFileName.getBytes(), "iso-8859-1"));
            File targetFile = new File(this.DOCS_PATH, downloadFileName);
            ExcelWriter excelWriter = EasyExcel.write((File)targetFile).withTemplate(templateFile).build();
            WriteSheet indexSheet = EasyExcel.writerSheet((Integer)0, (String)"\u5c01\u9762").build();
            IndexExcelData indexData = new IndexExcelData();
            indexData.setToday(today);
            excelWriter.fill((Object)indexData, indexSheet);
            WriteSheet devLogSheet = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((Integer)1, (String)"\u5386\u53f2\u53d8\u66f4\u8bb0\u5f55").head(DictDevLogVO.class)).build();
            this.devLogData(excelWriter, devLogSheet);
            WriteSheet optionSheet = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((Integer)2, (String)"\u516c\u5171\u4ee3\u7801\u9879").head(DictOptionVO.class)).build();
            this.optionData(excelWriter, optionSheet);
            WriteSheet itemSheet = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((Integer)3, (String)"\u6570\u636e\u6807\u51c6\u9879").head(DictItemInfoVO.class)).build();
            this.itemData(excelWriter, itemSheet);
            excelWriter.finish();
            ServletOutputStream out = response.getOutputStream();
            bis = new BufferedInputStream(new FileInputStream(targetFile));
            bos = new BufferedOutputStream((OutputStream)out);
            byte[] buff = new byte[2048];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                bos.write(buff, 0, bytesRead);
            }
            responseData = this.getResponseData(true);
            ResourceCloseUtil.closeInputStream((InputStream)bis);
        }
        catch (Exception e) {
            logger.error("\u4e0b\u8f7dexcel\u6a21\u578b\u5f02\u5e38", (Throwable)e);
            ResponseData responseData2 = this.getResponseData(false);
            return responseData2;
        }
        finally {
            ResourceCloseUtil.closeInputStream(bis);
            ResourceCloseUtil.closeOutputStream(bos);
        }
        ResourceCloseUtil.closeOutputStream((OutputStream)bos);
        return responseData;
    }

    public void devLogData(ExcelWriter excelWriter, WriteSheet sheet) {
        DictDevLogVO param = new DictDevLogVO();
        param.setSize(500);
        List<DictDevLogVO> list = this.dictDevLogService.queryAllOwner(param);
        int total = param.getTotal();
        if (total < 500) {
            excelWriter.fill(list, sheet);
        } else {
            excelWriter.fill(list, sheet);
            int loop = this.calcLoop(total);
            int i = 2;
            while (i <= loop) {
                int page = i++;
                param.setPage(page);
                list = this.dictDevLogService.queryAllOwner(param);
                excelWriter.fill(list, sheet);
            }
        }
    }

    public void optionData(ExcelWriter excelWriter, WriteSheet sheet) {
        DictOptionEnumVO param = new DictOptionEnumVO();
        param.setSize(500);
        List<DictOptionVO> list = this.dictOptionEnumService.queryAllOptionForExcel(param);
        int total = param.getTotal();
        if (total < 500) {
            excelWriter.fill(list, sheet);
        } else {
            excelWriter.fill(list, sheet);
            int loop = this.calcLoop(total);
            int i = 2;
            while (i <= loop) {
                int page = i++;
                param.setPage(page);
                list = this.dictOptionEnumService.queryAllOptionForExcel(param);
                excelWriter.fill(list, sheet);
            }
        }
    }

    public void itemData(ExcelWriter excelWriter, WriteSheet sheet) {
        DictItemInfoVO param = new DictItemInfoVO();
        param.setSize(500);
        List<DictItemInfoVO> list = this.dictItemInfoService.queryAllForExcelByPage(param);
        int total = param.getTotal();
        if (total < 500) {
            excelWriter.fill(list, sheet);
        } else {
            excelWriter.fill(list, sheet);
            int loop = this.calcLoop(total);
            int i = 2;
            while (i <= loop) {
                int page = i++;
                param.setPage(page);
                list = this.dictItemInfoService.queryAllForExcelByPage(param);
                excelWriter.fill(list, sheet);
            }
        }
    }

    private int calcLoop(int size) {
        int loop = size / 500;
        if (size % 500 > 0) {
            return loop + 1;
        }
        return loop;
    }

    @RequestMapping(value={"/dict/item/info/seq"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<String> queryAppIdSeqWithPrefix(@RequestParam(value="projectId") String projectId) {
        String seq = this.dictItemInfoService.querySeqWithPrefix(projectId);
        return this.getResponseData(seq);
    }

    public static class IndexExcelData {
        private String today;

        public String getToday() {
            return this.today;
        }

        public void setToday(String today) {
            this.today = today;
        }
    }

    public static class DictItemExcelReadListener
    extends AnalysisEventListener {
        private Map<String, PubDbmsDatatypeVO> dbmsDataTypeMap;
        private List<DictItemInfoVO> itemList = new ArrayList<DictItemInfoVO>();
        List<String> HEAD = Arrays.asList("\u6807\u51c6\u7c7b\u578b", "\u6807\u51c6\u9879\u7f16\u53f7", "\u6807\u51c6\u4e3b\u9898", "\u4e00\u7ea7\u5206\u7c7b", "\u4e8c\u7ea7\u5206\u7c7b", "\u4e09\u7ea7\u5206\u7c7b", "\u4e2d\u6587\u540d\u79f0", "\u6807\u51c6\u9879\u7f16\u53f7", "\u82f1\u6587\u540d\u79f0", "\u5e38\u7528\u540d\u79f0", "\u4e1a\u52a1\u542b\u4e49", "\u5236\u5b9a\u4f9d\u636e", "\u9002\u7528\u7c7b\u578b", "\u9002\u7528\u6761\u4ef6", "\u76d1\u7ba1\u6807\u5fd7", "\u6570\u636e\u7c7b\u578b", "\u6570\u636e\u957f\u5ea6", "\u5f15\u7528\u4ee3\u7801", "\u4ee3\u7801\u5b9a\u4e49\u539f\u5219", "\u4ee3\u7801\u5f15\u7528\u6807\u51c6", "\u7f16\u7801\u89c4\u5219", "\u6821\u9a8c\u89c4\u5219", "\u6807\u51c6\u9879\u6570\u636e\u5206\u7ea7", "\u4e3b\u6570\u636e\u6240\u5728\u7cfb\u7edf", "\u7ba1\u7406\u90e8\u95e8", "\u53d1\u5e03\u72b6\u6001", "\u53d1\u5e03\u65f6\u95f4", "\u5907\u6ce8", "\u53d8\u66f4\u539f\u56e0");
        List<String> headCellList = new ArrayList<String>();
        Pattern pattern = Pattern.compile("(\\w+)\\(\\s*(\\d+),?(\\d*)(\\s+BYTE)*\\s*\\)");

        public DictItemExcelReadListener(Map<String, PubDbmsDatatypeVO> dbmsDataTypeMap) {
            this.dbmsDataTypeMap = dbmsDataTypeMap;
        }

        public List<DictItemInfoVO> getItemList() {
            return this.itemList;
        }

        public void setItemList(List<DictItemInfoVO> itemList) {
            this.itemList = itemList;
        }

        public void invokeHeadMap(Map headMap, AnalysisContext context) {
            super.invokeHeadMap(headMap, context);
            int size = headMap.size();
            for (int i = 0; i < size; ++i) {
                this.headCellList.add((String)headMap.get(i));
            }
        }

        public void invoke(Object data, AnalysisContext context) {
            Map map = (Map)data;
            String itemId = (String)map.get(1);
            String subjectId = (String)map.get(2);
            String cataId1 = (String)map.get(3);
            String cataId2 = (String)map.get(4);
            String cataId3 = (String)map.get(5);
            String itemName = (String)map.get(6);
            String itemCode = (String)map.get(8);
            String commonName = (String)map.get(9);
            String bussDesc = (String)map.get(10);
            String basicFormula = (String)map.get(11);
            String suitType = (String)map.get(12);
            String suitCond = (String)map.get(13);
            String itemDataType = (String)map.get(15);
            String itemDateLength = (String)map.get(16);
            String dictId = (String)map.get(17);
            String codeRule = (String)map.get(20);
            String checklist = (String)map.get(21);
            String mainSystem = (String)map.get(23);
            String manageDept = (String)map.get(24);
            String publishState = (String)map.get(25);
            String publishTime = (String)map.get(26);
            String itemRemarks = (String)map.get(27);
            DictItemInfoVO item = new DictItemInfoVO();
            item.setItemId(itemId);
            item.setSubjectId(subjectId);
            item.setCataId1(cataId1);
            item.setCataId2(cataId2);
            item.setCataId3(cataId3);
            item.setItemName(itemName);
            item.setItemCode(itemCode);
            item.setCommonName(commonName);
            item.setBussDesc(bussDesc);
            item.setBasicFormula(basicFormula);
            SuitType st = SuitType.getByName(suitType);
            if (st != null) {
                item.setSuitType(st.getCode());
            }
            item.setSuitCond(suitCond);
            itemDateLength = itemDateLength != null ? itemDateLength.replaceAll("\uff08", "(").replaceAll("\uff09", ")").replaceAll("\uff0c", ",").trim() : "";
            Matcher matcher = this.pattern.matcher(itemDateLength.toLowerCase());
            if (matcher.matches()) {
                String type = matcher.group(1);
                String length = matcher.group(2);
                String precision = matcher.group(3);
                String key = String.format("%s-%s", itemDataType, type);
                PubDbmsDatatypeVO dbmsDt = this.dbmsDataTypeMap.get(key);
                if (dbmsDt != null) {
                    item.setItemDataType(dbmsDt.getDatatypeId());
                } else {
                    dbmsDt = this.dbmsDataTypeMap.get(type.toLowerCase());
                    if (dbmsDt != null) {
                        item.setItemDataType(dbmsDt.getDatatypeId());
                    }
                }
                item.setItemDataLength(Integer.valueOf(length));
                if (StringUtils.isNotEmpty((String)precision)) {
                    item.setItemDataPrecision(Integer.valueOf(precision));
                }
            }
            item.setDictId(dictId);
            item.setDictCode(dictId);
            item.setCodeRule(codeRule);
            item.setChecklist(checklist);
            item.setMainSystem(mainSystem);
            item.setManageDept(manageDept);
            PublishState ps = PublishState.getByName(publishState);
            if (ps != null) {
                item.setPublishState(ps.getCode());
            }
            item.setPublishTime(publishTime);
            this.itemList.add(item);
        }

        public void doAfterAllAnalysed(AnalysisContext context) {
        }

        public String checkExcelFormat() {
            if (this.headCellList.size() != this.HEAD.size()) {
                return "\u6570\u636e\u5bfc\u5165\u6a21\u677f\u4e0d\u6b63\u786e";
            }
            for (int i = 0; i < this.HEAD.size(); ++i) {
                if (StringUtils.equals((String)this.headCellList.get(i), (String)this.HEAD.get(i))) continue;
                return "\u6570\u636e\u5bfc\u5165\u6a21\u677f\u4e0d\u6b63\u786e";
            }
            return null;
        }
    }

    public static class DictOptionExcelReadListener
    extends AnalysisEventListener {
        private List<DictOptionEnumVO> optionList = new ArrayList<DictOptionEnumVO>();
        private List<String> HEAD = Arrays.asList("\u4ee3\u7801\u7f16\u53f7", "\u4e2d\u6587\u540d\u79f0", "\u4ee3\u7801\u503c", "\u4ee3\u7801\u503c\u63cf\u8ff0", "\u5907\u6ce8", "\u516c\u5171\u4ee3\u7801\u72b6\u6001", "\u53d8\u66f4\u539f\u56e0");
        private List<String> headCellList = new ArrayList<String>();

        public List<DictOptionEnumVO> getOptionList() {
            return this.optionList;
        }

        public void setOptionList(List<DictOptionEnumVO> optionList) {
            this.optionList = optionList;
        }

        public void invokeHeadMap(Map headMap, AnalysisContext context) {
            super.invokeHeadMap(headMap, context);
            int size = headMap.size();
            for (int i = 0; i < size; ++i) {
                this.headCellList.add((String)headMap.get(i));
            }
        }

        public void invoke(Object data, AnalysisContext context) {
            Map map = (Map)data;
            DictOptionEnumVO option = new DictOptionEnumVO();
            String dictId = (String)map.get(0);
            if (StringUtils.isBlank((String)dictId)) {
                return;
            }
            option.setDictId(dictId);
            option.setDictCode(dictId);
            option.setDictName((String)map.get(1));
            option.setOptionCode((String)map.get(2));
            option.setOptionName((String)map.get(3));
            option.setOptionRemarks((String)map.get(4));
            String state = (String)map.get(5);
            state = StringUtils.equals((String)state, (String)"\u6709\u6548") ? "P" : "D";
            option.setPublishState(state);
            this.optionList.add(option);
        }

        public void doAfterAllAnalysed(AnalysisContext context) {
        }

        public String checkExcelFormat() {
            if (this.headCellList.size() != this.HEAD.size()) {
                return "\u6570\u636e\u5bfc\u5165\u6a21\u677f\u4e0d\u6b63\u786e";
            }
            for (int i = 0; i < this.HEAD.size(); ++i) {
                if (StringUtils.equals((String)this.headCellList.get(i), (String)this.HEAD.get(i))) continue;
                return "\u6570\u636e\u5bfc\u5165\u6a21\u677f\u4e0d\u6b63\u786e";
            }
            return null;
        }
    }
}

