/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinpaas.console.dmcenter.api.rest;

import com.irdstudio.allinpaas.console.dmcenter.common.annotations.DictDevLogAnno;
import com.irdstudio.allinpaas.console.dmcenter.common.enums.DictLogChangeType;
import com.irdstudio.allinpaas.console.dmcenter.common.util.CurrentDateUtil;
import com.irdstudio.allinpaas.console.dmcenter.common.util.KeyUtil;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.DictOptionEnumService;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.DictOptionEnumVO;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.SDicVO;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.AbstractController;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class DictOptionEnumController
extends AbstractController {
    @Autowired
    @Qualifier(value="dictOptionEnumService")
    private DictOptionEnumService dictOptionEnumService;

    @DictDevLogAnno(action=DictLogChangeType.Add, logCatalog="option", itemId="${args[0].optionId}", itemCode="${args[0].optionCode}", itemName="${args[0].optionName}")
    @PostMapping(value={"/dict/option/enum"})
    @ResponseBody
    public ResponseData<Integer> insertDictOptionEnum(@RequestBody DictOptionEnumVO inDictOptionEnumVo) {
        inDictOptionEnumVo.setOptionId(KeyUtil.createUUIDKey());
        inDictOptionEnumVo.setLastModifyUser(this.getUserInfo().getUserId());
        inDictOptionEnumVo.setLastModifyTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = this.dictOptionEnumService.insertDictOptionEnum(inDictOptionEnumVo);
        return this.getResponseData(outputVo);
    }

    @DictDevLogAnno(action=DictLogChangeType.Delete, logCatalog="option", itemId="${args[0].optionId}", itemCode="${old.optionCode}", itemName="${old.optionName}")
    @DeleteMapping(value={"/dict/option/enum"})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody DictOptionEnumVO inDictOptionEnumVo) {
        int outputVo = this.dictOptionEnumService.deleteByPk(inDictOptionEnumVo);
        return this.getResponseData(outputVo);
    }

    @DictDevLogAnno(action=DictLogChangeType.Update, logCatalog="option", itemId="${args[0].optionId}", itemCode="${args[0].optionCode}", itemName="${args[0].optionName}")
    @PutMapping(value={"/dict/option/enum"})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody DictOptionEnumVO inDictOptionEnumVo) {
        inDictOptionEnumVo.setLastModifyUser(this.getUserInfo().getUserId());
        inDictOptionEnumVo.setLastModifyTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = this.dictOptionEnumService.updateByPk(inDictOptionEnumVo);
        return this.getResponseData(outputVo);
    }

    @GetMapping(value={"/dict/option/enum/{optionId}"})
    @ResponseBody
    public ResponseData<DictOptionEnumVO> queryByPk(@PathVariable(value="optionId") String optionId) {
        DictOptionEnumVO inVo = new DictOptionEnumVO();
        inVo.setOptionId(optionId);
        DictOptionEnumVO outputVo = this.dictOptionEnumService.queryByPk(inVo);
        return this.getResponseData((Object)outputVo);
    }

    @RequestMapping(value={"/dict/option/enums"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<DictOptionEnumVO>> queryDictOptionEnumAll(DictOptionEnumVO vo) {
        List<DictOptionEnumVO> outputVo = null;
        this.setUserInfoToVO((Object)vo);
        outputVo = this.dictOptionEnumService.queryAllByLevelOne(vo);
        return this.getResponseData(outputVo);
    }

    @GetMapping(value={"/dict/option/script/{fieldId}"})
    @ResponseBody
    public ResponseData<String> generateDDL(@PathVariable(value="fieldId") String fieldId) {
        if (StringUtils.isNotBlank((CharSequence)fieldId)) {
            List<SDicVO> dicts = this.dictOptionEnumService.queryModelTableFieldDicts(fieldId);
            if (CollectionUtils.isEmpty(dicts)) {
                return this.getResponseData("");
            }
            String template = "insert into s_dic (enname, cnname, opttype, memo) values ('%s', '%s', '%s', '%s');\n";
            StringBuffer buffer = new StringBuffer();
            for (SDicVO dic : dicts) {
                buffer.append(String.format(template, dic.getEnname(), dic.getCnname(), dic.getOpttype(), dic.getMemo()));
            }
            return this.getResponseData(buffer.toString());
        }
        return this.getResponseData("");
    }

    @GetMapping(value={"/dict/option/enum/format"})
    @ResponseBody
    public ResponseData<String> formatOptionEnumEmpty() {
        int num = this.dictOptionEnumService.formatOptionEnumEmpty();
        return this.getResponseData("S");
    }
}

