/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinpaas.console.dmcenter.api.rest;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.irdstudio.allinpaas.console.dmcenter.common.annotations.DictDevLogAnno;
import com.irdstudio.allinpaas.console.dmcenter.common.enums.DictLogChangeType;
import com.irdstudio.allinpaas.console.dmcenter.common.enums.PublishState;
import com.irdstudio.allinpaas.console.dmcenter.common.util.CurrentDateUtil;
import com.irdstudio.allinpaas.console.dmcenter.common.util.KeyUtil;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.DictOptionEnumService;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.DictOptionInfoService;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.DictOptionEnumVO;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.DictOptionInfoVO;
import com.irdstudio.allinpaas.executor.core.plugin.docs.git.queue.DocTemplateRepoPullQueueExecutor;
import com.irdstudio.sdk.beans.core.util.ResourceCloseUtil;
import com.irdstudio.sdk.beans.core.util.TimeUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.core.vo.UserInfo;
import com.irdstudio.sdk.beans.web.controller.AbstractController;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api"})
public class DictOptionInfoController
extends AbstractController {
    @Autowired
    @Qualifier(value="dictOptionInfoService")
    private DictOptionInfoService dictOptionInfoService;
    @Autowired
    @Qualifier(value="dictOptionEnumService")
    private DictOptionEnumService dictOptionEnumService;

    @DictDevLogAnno(action=DictLogChangeType.Add, logCatalog="option", itemId="${args[0].dictId}", itemCode="${args[0].dictCode}", itemName="${args[0].dictName}")
    @PostMapping(value={"/dict/option/info"})
    @ResponseBody
    public ResponseData<Integer> insertDictOptionInfo(@RequestBody DictOptionInfoVO inDictOptionInfoVo) {
        if (StringUtils.isBlank((String)inDictOptionInfoVo.getDictId())) {
            inDictOptionInfoVo.setDictId(KeyUtil.createUUIDKey());
        }
        inDictOptionInfoVo.setDictCode(inDictOptionInfoVo.getDictCode().toLowerCase());
        inDictOptionInfoVo.setCreateUser(this.getUserInfo().getUserId());
        inDictOptionInfoVo.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        inDictOptionInfoVo.setLastModifyUser(this.getUserInfo().getUserId());
        inDictOptionInfoVo.setLastModifyTime(inDictOptionInfoVo.getCreateTime());
        int outputVo = this.dictOptionInfoService.insertDictOptionInfo(inDictOptionInfoVo);
        return this.getResponseData(outputVo);
    }

    @DictDevLogAnno(action=DictLogChangeType.Delete, logCatalog="option", itemId="${args[0].dictId}", itemCode="${old.dictCode}", itemName="${old.dictName}")
    @DeleteMapping(value={"/dict/option/info"})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody DictOptionInfoVO inDictOptionInfoVo) {
        int outputVo = this.dictOptionInfoService.deleteByPk(inDictOptionInfoVo);
        outputVo = this.dictOptionEnumService.deleteByDictId(inDictOptionInfoVo.getDictId());
        return this.getResponseData(outputVo);
    }

    @DictDevLogAnno(action=DictLogChangeType.Update, logCatalog="option", itemId="${args[0].dictId}", itemCode="${args[0].dictCode}", itemName="${args[0].dictName}")
    @PutMapping(value={"/dict/option/info"})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody DictOptionInfoVO inDictOptionInfoVo) {
        inDictOptionInfoVo.setDictCode(inDictOptionInfoVo.getDictCode().toLowerCase());
        int outputVo = this.dictOptionInfoService.updateByPk(inDictOptionInfoVo);
        return this.getResponseData(outputVo);
    }

    @GetMapping(value={"/dict/option/info/{dictId}"})
    @ResponseBody
    public ResponseData<DictOptionInfoVO> queryByPk(@PathVariable(value="dictId") String dictId) {
        DictOptionInfoVO inVo = new DictOptionInfoVO();
        inVo.setDictId(dictId);
        DictOptionInfoVO outputVo = this.dictOptionInfoService.queryByPk(inVo);
        return this.getResponseData((Object)outputVo);
    }

    @RequestMapping(value={"/my/dict/option/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<DictOptionInfoVO>> queryMyDictOptionInfoAll(DictOptionInfoVO vo) {
        List<DictOptionInfoVO> outputVo = null;
        this.setUserInfoToVO((Object)vo);
        outputVo = this.dictOptionInfoService.queryAllByLevelOne(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/dict/option/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<DictOptionInfoVO>> queryPublicDictOptionInfoAll(DictOptionInfoVO vo) {
        List<DictOptionInfoVO> outputVo = null;
        this.setUserInfoToVO((Object)vo);
        outputVo = this.dictOptionInfoService.queryAllByLevelTwo(vo);
        return this.getResponseData(outputVo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/dict/option/info/template"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Boolean> excelTemplateDownload(HttpServletResponse response) {
        ResponseData responseData;
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        try {
            int bytesRead;
            DocTemplateRepoPullQueueExecutor.syncRun();
            String templateRootPath = DocTemplateRepoPullQueueExecutor.getDocTemplatePath();
            File file = new File(templateRootPath + File.separator + "xlsx" + File.separator + "dictOptionInfoTemplate.xlsx");
            response.setContentType("application/vnd.ms-excel;charset=utf-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + new String("\u4ee3\u7801\u9879.xlsx".getBytes(), "iso-8859-1"));
            ServletOutputStream out = response.getOutputStream();
            bis = new BufferedInputStream(new FileInputStream(file));
            bos = new BufferedOutputStream((OutputStream)out);
            byte[] buff = new byte[2048];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                bos.write(buff, 0, bytesRead);
            }
            responseData = this.getResponseData(true);
            ResourceCloseUtil.closeInputStream((InputStream)bis);
        }
        catch (Exception e) {
            logger.error("\u4e0b\u8f7dexcel\u6a21\u578b\u5f02\u5e38", (Throwable)e);
            ResponseData responseData2 = this.getResponseData(false);
            return responseData2;
        }
        finally {
            ResourceCloseUtil.closeInputStream(bis);
            ResourceCloseUtil.closeOutputStream(bos);
        }
        ResourceCloseUtil.closeOutputStream((OutputStream)bos);
        return responseData;
    }

    @PostMapping(value={"/dict/option/info/excel"})
    @ResponseBody
    public ResponseData<String> uploadExcel(@RequestParam(value="excelUploadType") String excelUploadType, final @RequestParam(value="accessLevel") String accessLevel, final @RequestParam(value="projectId", required=false) String projectId, @RequestPart(value="file") MultipartFile file) {
        try {
            final ArrayList<DictOptionInfoVO> list = new ArrayList<DictOptionInfoVO>();
            final HashMap map = new HashMap();
            final ArrayList<DictOptionEnumVO> enumList = new ArrayList<DictOptionEnumVO>();
            final UserInfo userInfo = this.getUserInfo();
            final String createTime = TimeUtil.getCurrentDateTime();
            List<String> HEAD = Arrays.asList("\u9009\u9879\u7f16\u53f7", "\u82f1\u6587\u540d\u79f0", "\u4e2d\u6587\u540d\u79f0", "\u9009\u9879\u503c", "\u9009\u9879\u679a\u4e3e\u503c", "\u9009\u9879\u63cf\u8ff0");
            final ArrayList headCellList = new ArrayList();
            ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)file.getInputStream(), (ReadListener)new AnalysisEventListener<Map<Integer, String>>(){

                public void invokeHeadMap(Map<Integer, String> headMap, AnalysisContext context) {
                    super.invokeHeadMap(headMap, context);
                    int size = headMap.size();
                    for (int i = 0; i < size; ++i) {
                        headCellList.add(headMap.get(i));
                    }
                }

                public void invoke(Map<Integer, String> data, AnalysisContext analysisContext) {
                    String dictId = data.get(0);
                    String dictCode = data.get(1);
                    String dictName = data.get(2);
                    String optionCode = data.get(3);
                    String optionEnum = data.get(4);
                    String optionName = data.get(5);
                    DictOptionInfoVO info = (DictOptionInfoVO)((Object)map.get(dictId));
                    if (info == null) {
                        info = new DictOptionInfoVO();
                        info.setDictId(dictId);
                        info.setDictCode(dictCode);
                        info.setDictName(dictName);
                        info.setDictIsStd("N");
                        info.setDictType("1");
                        info.setAccessLevel(accessLevel);
                        info.setProjectId(projectId);
                        info.setCreateTime(createTime);
                        info.setCreateUser(userInfo.getUserId());
                        info.setPublishState(PublishState.Publish.getCode());
                        info.setCodeLen(0);
                        map.put(info.getDictId(), info);
                        list.add(info);
                    }
                    info.setCodeLen(Math.max(info.getCodeLen(), StringUtils.length((String)optionCode)));
                    DictOptionEnumVO obj = new DictOptionEnumVO();
                    obj.setOptionId(UUIDUtil.getUUID());
                    obj.setDictId(dictId);
                    obj.setOptionCode(optionCode);
                    obj.setOptionEnum(optionEnum);
                    obj.setOptionName(optionName);
                    obj.setOptionRemarks(optionName);
                    obj.setLastModifyTime(createTime);
                    obj.setLastModifyUser(userInfo.getUserId());
                    enumList.add(obj);
                }

                public void doAfterAllAnalysed(AnalysisContext analysisContext) {
                }
            }).sheet(Integer.valueOf(0)).headRowNumber(Integer.valueOf(1))).doReadSync();
            if (headCellList.size() != HEAD.size()) {
                return this.getResponseData("\u6570\u636e\u5bfc\u5165\u6a21\u677f\u4e0d\u6b63\u786e");
            }
            for (int i = 0; i < HEAD.size(); ++i) {
                if (StringUtils.equals((String)((String)headCellList.get(i)), (String)HEAD.get(i))) continue;
                return this.getResponseData("\u6570\u636e\u5bfc\u5165\u6a21\u677f\u4e0d\u6b63\u786e");
            }
            if (list.size() > 0) {
                this.dictOptionInfoService.excelUpload(excelUploadType, list, enumList);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getResponseData("S");
    }

    @RequestMapping(value={"/dict/option/info/seq"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<String> queryAppIdSeqWithPrefix(@RequestParam(value="projectId") String projectId) {
        String seq = this.dictOptionInfoService.querySeqWithPrefix(projectId);
        return this.getResponseData(seq);
    }
}

