/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinpaas.console.dmcenter.api.rest;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.irdstudio.allinpaas.console.dmcenter.common.annotations.DictDevLogAnno;
import com.irdstudio.allinpaas.console.dmcenter.common.enums.DictLogChangeType;
import com.irdstudio.allinpaas.console.dmcenter.common.util.CurrentDateUtil;
import com.irdstudio.allinpaas.console.dmcenter.common.util.KeyUtil;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.DictWordInfoService;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.DictWordInfoVO;
import com.irdstudio.allinpaas.executor.core.plugin.docs.git.queue.DocTemplateRepoPullQueueExecutor;
import com.irdstudio.sdk.beans.core.util.ResourceCloseUtil;
import com.irdstudio.sdk.beans.core.util.StringUtil;
import com.irdstudio.sdk.beans.core.util.TimeUtil;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.core.vo.UserInfo;
import com.irdstudio.sdk.beans.web.controller.AbstractController;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api"})
public class DictWordInfoController
extends AbstractController {
    @Autowired
    @Qualifier(value="dictWordInfoService")
    private DictWordInfoService dictWordInfoService;

    @DictDevLogAnno(action=DictLogChangeType.Add, logCatalog="word", itemId="${args[0].wordId}", itemCode="${args[0].wordShortCode}", itemName="${args[0].wordCnDesc}")
    @PostMapping(value={"/dict/word/info"})
    @ResponseBody
    public ResponseData<Integer> insertDictWordInfo(@RequestBody DictWordInfoVO inDictWordInfoVo) {
        inDictWordInfoVo.setWordId(KeyUtil.createUUIDKey());
        inDictWordInfoVo.setCreateUser(this.getUserInfo().getUserId());
        inDictWordInfoVo.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = this.dictWordInfoService.insertDictWordInfo(inDictWordInfoVo);
        return this.getResponseData(outputVo);
    }

    @DictDevLogAnno(action=DictLogChangeType.Delete, logCatalog="word", itemId="${args[0].wordId}", itemCode="${old.wordShortCode}", itemName="${old.wordCnDesc}")
    @DeleteMapping(value={"/dict/word/info"})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody DictWordInfoVO inDictWordInfoVo) {
        int outputVo = this.dictWordInfoService.deleteByPk(inDictWordInfoVo);
        return this.getResponseData(outputVo);
    }

    @DictDevLogAnno(action=DictLogChangeType.Update, logCatalog="word", itemId="${args[0].wordId}", itemCode="${args[0].wordShortCode}", itemName="${args[0].wordCnDesc}")
    @PutMapping(value={"/dict/word/info"})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody DictWordInfoVO inDictWordInfoVo) {
        inDictWordInfoVo.setLastModifyUser(this.getUserInfo().getUserId());
        inDictWordInfoVo.setLastModifyTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = this.dictWordInfoService.updateByPk(inDictWordInfoVo);
        return this.getResponseData(outputVo);
    }

    @GetMapping(value={"/dict/word/info/{wordId}"})
    @ResponseBody
    public ResponseData<DictWordInfoVO> queryByPk(@PathVariable(value="wordId") String wordId) {
        DictWordInfoVO inVo = new DictWordInfoVO();
        inVo.setWordId(wordId);
        DictWordInfoVO outputVo = this.dictWordInfoService.queryByPk(inVo);
        return this.getResponseData((Object)outputVo);
    }

    @RequestMapping(value={"/dict/word/ss/{word}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<List<DictWordInfoVO>> searchByWord(@PathVariable(value="word") String word) {
        DictWordInfoVO inVo = new DictWordInfoVO();
        inVo.setWordShortCode(word);
        inVo.setWordCnDesc(word);
        List<DictWordInfoVO> outputVo = this.dictWordInfoService.queryAllByLevelThree(inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/my/dict/word/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<DictWordInfoVO>> queryMyDictWordInfoAll(DictWordInfoVO vo) {
        List<DictWordInfoVO> outputVo = null;
        this.setUserInfoToVO((Object)vo);
        outputVo = this.dictWordInfoService.queryAllByLevelOne(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/dict/word/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<DictWordInfoVO>> queryPublicDictWordInfoAll(DictWordInfoVO vo) {
        List<DictWordInfoVO> outputVo = null;
        this.setUserInfoToVO((Object)vo);
        outputVo = this.dictWordInfoService.queryAllByLevelTwo(vo);
        return this.getResponseData(outputVo);
    }

    @PostMapping(value={"/dict/word/info/excel"})
    @ResponseBody
    public ResponseData<String> uploadExcel(@RequestParam(value="excelUploadType") String excelUploadType, @RequestPart(value="file") MultipartFile file) {
        String fileName = file.getOriginalFilename();
        if (StringUtil.isNullorBank((String)fileName)) {
            fileName = file.getName();
        }
        try {
            final ArrayList<DictWordInfoVO> list = new ArrayList<DictWordInfoVO>();
            final UserInfo userInfo = this.getUserInfo();
            final String createTime = TimeUtil.getCurrentDateTime();
            List<String> HEAD = Arrays.asList("\u540d\u8bcd\u4e2d\u6587\u540d", "\u540d\u79f0\u82f1\u6587\u540d", "\u8bcd\u6839\u7c7b\u578b", "\u6dfb\u52a0/\u4fee\u6539\u65e5\u671f", "\u5907\u6ce8");
            final ArrayList headCellList = new ArrayList();
            ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)file.getInputStream(), DictWordInfoData.class, (ReadListener)new AnalysisEventListener<DictWordInfoData>(){

                public void invokeHeadMap(Map<Integer, String> headMap, AnalysisContext context) {
                    super.invokeHeadMap(headMap, context);
                    int size = headMap.size();
                    for (int i = 0; i < size; ++i) {
                        headCellList.add(headMap.get(i));
                    }
                }

                public void invoke(DictWordInfoData dictWordInfoData, AnalysisContext analysisContext) {
                    DictWordInfoVO dictWordInfoVO = new DictWordInfoVO();
                    dictWordInfoVO.setWordId(UUIDUtil.getUUID());
                    dictWordInfoVO.setWordCnDesc(dictWordInfoData.wordCnDesc);
                    dictWordInfoVO.setWordShortCode(dictWordInfoData.wordShortCode);
                    dictWordInfoVO.setWordEnDesc(dictWordInfoData.wordShortCode);
                    dictWordInfoVO.setCreateTime(createTime);
                    dictWordInfoVO.setCreateUser(userInfo.getUserId());
                    list.add(dictWordInfoVO);
                }

                public void doAfterAllAnalysed(AnalysisContext analysisContext) {
                }
            }).sheet().headRowNumber(Integer.valueOf(1))).doReadSync();
            if (headCellList.size() != HEAD.size()) {
                return this.getResponseData("\u6570\u636e\u5bfc\u5165\u6a21\u677f\u4e0d\u6b63\u786e");
            }
            for (int i = 0; i < HEAD.size(); ++i) {
                if (StringUtils.equals((String)((String)headCellList.get(i)), (String)HEAD.get(i))) continue;
                return this.getResponseData("\u6570\u636e\u5bfc\u5165\u6a21\u677f\u4e0d\u6b63\u786e");
            }
            if (list.size() > 0) {
                this.dictWordInfoService.excelUpload(excelUploadType, list);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getResponseData("S");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/dict/word/info/template"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Boolean> excelTemplateDownload(HttpServletResponse response) {
        ResponseData responseData;
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        try {
            int bytesRead;
            DocTemplateRepoPullQueueExecutor.syncRun();
            String templateRootPath = DocTemplateRepoPullQueueExecutor.getDocTemplatePath();
            File file = new File(templateRootPath + File.separator + "xlsx" + File.separator + "dictWordInfoTemplate.xlsx");
            response.setContentType("application/vnd.ms-excel;charset=utf-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + new String("\u6570\u636e\u8bcd\u6839.xlsx".getBytes(), "iso-8859-1"));
            ServletOutputStream out = response.getOutputStream();
            bis = new BufferedInputStream(new FileInputStream(file));
            bos = new BufferedOutputStream((OutputStream)out);
            byte[] buff = new byte[2048];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                bos.write(buff, 0, bytesRead);
            }
            responseData = this.getResponseData(true);
            ResourceCloseUtil.closeInputStream((InputStream)bis);
        }
        catch (Exception e) {
            logger.error("\u4e0b\u8f7dexcel\u6a21\u578b\u5f02\u5e38", (Throwable)e);
            ResponseData responseData2 = this.getResponseData(false);
            return responseData2;
        }
        finally {
            ResourceCloseUtil.closeInputStream(bis);
            ResourceCloseUtil.closeOutputStream(bos);
        }
        ResourceCloseUtil.closeOutputStream((OutputStream)bos);
        return responseData;
    }

    public static class DictWordInfoData {
        @ExcelProperty(value={"\u540d\u79f0\u82f1\u6587\u540d"})
        private String wordShortCode;
        @ExcelProperty(value={"\u540d\u8bcd\u4e2d\u6587\u540d"})
        private String wordCnDesc;

        public String getWordShortCode() {
            return this.wordShortCode;
        }

        public void setWordShortCode(String wordShortCode) {
            this.wordShortCode = wordShortCode;
        }

        public String getWordCnDesc() {
            return this.wordCnDesc;
        }

        public void setWordCnDesc(String wordCnDesc) {
            this.wordCnDesc = wordCnDesc;
        }
    }
}

