/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinpaas.console.dmcenter.api.rest;

import com.irdstudio.allinpaas.console.dmcenter.common.annotations.DevLog;
import com.irdstudio.allinpaas.console.dmcenter.common.enums.LogAction;
import com.irdstudio.allinpaas.console.dmcenter.common.enums.PubStdSwitchEnum;
import com.irdstudio.allinpaas.console.dmcenter.common.util.CurrentDateUtil;
import com.irdstudio.allinpaas.console.dmcenter.common.util.KeyUtil;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.DictItemInfoService;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.DictOptionInfoService;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.DictWordInfoService;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.ModelTableFieldService;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.ModelTableInfoService;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.PubDbmsDatatypeService;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.SrvFieldFlagService;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.FieldBatchImportVO;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.ModelTableFieldVO;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.SrvFieldFlagVO;
import com.irdstudio.sdk.beans.core.enums.PubStdYnEnum;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.AbstractController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class ModelTableFieldController
extends AbstractController {
    private static final Pattern pattern = Pattern.compile("\\w+\\(\\s*(\\d+),?(\\d*)(\\s+BYTE)*\\s*\\)");
    @Autowired
    @Qualifier(value="modelTableInfoService")
    private ModelTableInfoService modelTableInfoService;
    @Autowired
    @Qualifier(value="modelTableFieldService")
    private ModelTableFieldService modelTableFieldService;
    @Autowired
    @Qualifier(value="pubDbmsDatatypeService")
    private PubDbmsDatatypeService pubDbmsDatatypeService;
    @Autowired
    @Qualifier(value="dictItemInfoService")
    private DictItemInfoService dictItemInfoService;
    @Autowired
    @Qualifier(value="dictWordInfoService")
    private DictWordInfoService dictWordInfoService;
    @Autowired
    @Qualifier(value="dictOptionInfoService")
    private DictOptionInfoService dictOptionInfoService;
    @Autowired
    @Qualifier(value="srvFieldFlagService")
    private SrvFieldFlagService srvFieldFlagService;
    @Value(value="${tdp.docs.path}")
    private String DOCS_PATH;

    @PostMapping(value={"/model/table/field"})
    @DevLog(action=LogAction.Add, desc="\u521b\u5efa\u5b57\u6bb5 ${args[0].fieldName} ${args[0].fieldCode}", objectId="${args[0].objectId}")
    @ResponseBody
    public ResponseData<String> insertModelTableField(@RequestBody ModelTableFieldVO inModelTableFieldVo) {
        int orderValue = this.modelTableFieldService.getCurrentOrderValue(inModelTableFieldVo.getObjectId());
        inModelTableFieldVo.setFieldOrder(orderValue);
        inModelTableFieldVo.setFieldId(KeyUtil.createUUIDKey());
        if (PubStdSwitchEnum.ON.getCode().equals(inModelTableFieldVo.getIsPk())) {
            inModelTableFieldVo.setIsPk(PubStdYnEnum.Y.getCode());
        } else {
            inModelTableFieldVo.setIsPk(PubStdYnEnum.N.getCode());
        }
        if (PubStdSwitchEnum.ON.getCode().equals(inModelTableFieldVo.getIsAllowNull())) {
            inModelTableFieldVo.setIsAllowNull(PubStdYnEnum.Y.getCode());
        } else {
            inModelTableFieldVo.setIsAllowNull(PubStdYnEnum.N.getCode());
        }
        inModelTableFieldVo.setCreateUser(this.getUserInfo().getUserId());
        inModelTableFieldVo.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = this.modelTableFieldService.insertModelTableField(inModelTableFieldVo);
        return this.getResponseData(inModelTableFieldVo.getFieldId());
    }

    @PostMapping(value={"/model/table/field/item"})
    @DevLog(action=LogAction.Add, desc="\u521b\u5efa\u5b57\u6bb5 ${args[0].fieldName} ${args[0].fieldCode}", objectId="${args[0].objectId}")
    @ResponseBody
    public ResponseData<String> insertModelTableFieldWithDictItem(@RequestBody ModelTableFieldVO inModelTableFieldVo) {
        String fieldType = inModelTableFieldVo.getFieldType();
        ResponseData<String> insertFieldResult = this.insertModelTableField(inModelTableFieldVo);
        ModelTableFieldVO param = new ModelTableFieldVO();
        param.setFieldId((String)insertFieldResult.getRows());
        ModelTableFieldVO field = this.modelTableFieldService.queryByPk(param);
        this.modelTableFieldService.updateByPk(field);
        return insertFieldResult;
    }

    @DevLog(action=LogAction.Update, desc="\u6279\u91cf\u66f4\u65b0\u5b57\u6bb5\u670d\u52a1\u6a21\u578b\u8f93\u5165\u8f93\u51fa\u6807\u5fd7 ${args[0]}", objectId="${args[0]}", srvModelId="${args[1]}")
    @GetMapping(value={"/model/table/field/batch/update"})
    @ResponseBody
    public ResponseData<Integer> updateFiledByObjectId(@RequestParam(value="objectId") String objectId, @RequestParam(value="srvModelId") String srvModelId, @RequestParam(value="srvModelCatalog") String srvModelCatalog, @RequestParam(value="srvModelType") String srvModelType, @RequestParam(value="srvParamFlag") String srvParamFlag) {
        ModelTableFieldVO fieldVO = new ModelTableFieldVO();
        fieldVO.setObjectId(objectId);
        List<ModelTableFieldVO> fields = this.modelTableFieldService.queryModelTableFields(fieldVO);
        int num = 0;
        if (CollectionUtils.isNotEmpty(fields)) {
            ArrayList<SrvFieldFlagVO> flagList = new ArrayList<SrvFieldFlagVO>(fields.size());
            for (ModelTableFieldVO field : fields) {
                SrvFieldFlagVO flag = new SrvFieldFlagVO(field.getFieldId(), field.getObjectId(), srvModelCatalog, srvModelType, srvParamFlag);
                flagList.add(flag);
            }
            this.srvFieldFlagService.insertSrvFieldFlags(flagList);
        }
        return this.getResponseData(num);
    }

    @PutMapping(value={"/model/table/field/item"})
    @DevLog(action=LogAction.Update, desc="\u66f4\u65b0\u5b57\u6bb5 ${args[0].fieldName} ${args[0].fieldCode}", objectId="${args[0].objectId}")
    @ResponseBody
    public ResponseData<Integer> updateWithItem(@RequestBody ModelTableFieldVO inModelTableFieldVo) {
        inModelTableFieldVo.setLastModifyUser(this.getUserInfo().getUserId());
        inModelTableFieldVo.setLastModifyTime(CurrentDateUtil.getTodayDateEx2());
        String fieldType = inModelTableFieldVo.getFieldType();
        if (PubStdSwitchEnum.ON.getCode().equals(inModelTableFieldVo.getIsPk())) {
            inModelTableFieldVo.setIsPk(PubStdYnEnum.Y.getCode());
        } else {
            inModelTableFieldVo.setIsPk(PubStdYnEnum.N.getCode());
        }
        if (PubStdSwitchEnum.ON.getCode().equals(inModelTableFieldVo.getIsAllowNull())) {
            inModelTableFieldVo.setIsAllowNull(PubStdYnEnum.Y.getCode());
        } else {
            inModelTableFieldVo.setIsAllowNull(PubStdYnEnum.N.getCode());
        }
        int outputVo = this.modelTableFieldService.updateByPk(inModelTableFieldVo);
        return this.getResponseData(outputVo);
    }

    @PostMapping(value={"/field/batch/import"})
    @ResponseBody
    public ResponseData<String> batchImportFields(@RequestBody FieldBatchImportVO fbiv) {
        int i;
        ResponseData rsp = new ResponseData();
        ArrayList<ModelTableFieldVO> fieldList = new ArrayList<ModelTableFieldVO>();
        String[] lines = fbiv.getContent().split("\n|\r");
        int fieldCodeIdx = 0;
        int fieldNameIdx = 1;
        int fieldTypeIdx = 2;
        String[] props = new String[]{fbiv.getField1(), fbiv.getField2(), fbiv.getField3()};
        for (i = 0; i < props.length; ++i) {
            if (StringUtils.equals((String)"fieldCode", (String)props[i])) {
                fieldCodeIdx = i;
                continue;
            }
            if (StringUtils.equals((String)"fieldName", (String)props[i])) {
                fieldNameIdx = i;
                continue;
            }
            if (!StringUtils.equals((String)"fieldType", (String)props[i])) continue;
            fieldTypeIdx = i;
        }
        for (i = 0; i < lines.length; ++i) {
            if (StringUtils.isEmpty((String)lines[i])) continue;
            String[] fields = StringUtils.split((String)lines[i], (String)fbiv.getSplit());
            if (fields.length < 3) {
                rsp.fail("\u5b57\u6bb5\u4e2a\u6570\u5c11\u4e8e\u6700\u4f4e\u8981\u6c42(3\u4e2a)!");
                return rsp;
            }
            if (fbiv.getSplit().equals(",") && fields.length > 3) {
                fields[fieldTypeIdx] = fields[fieldTypeIdx] + "," + fields[fieldTypeIdx + 1];
            }
            ModelTableFieldVO mtfv = new ModelTableFieldVO();
            mtfv.setFieldId(KeyUtil.createUUIDKey());
            mtfv.setCreateUser(this.getUserInfo().getUserId());
            mtfv.setCreateTime(CurrentDateUtil.getTodayDateEx2());
            mtfv.setFieldCode(fields[fieldCodeIdx]);
            mtfv.setFieldName(fields[fieldNameIdx]);
            String typeStr = fields[fieldTypeIdx];
            if (typeStr.contains("(")) {
                mtfv.setFieldType(typeStr.substring(0, typeStr.indexOf("(")));
                Matcher matcher = pattern.matcher(typeStr);
                if (matcher.matches()) {
                    mtfv.setFieldLength(Integer.valueOf(matcher.group(1)));
                    if (StringUtils.isNotEmpty((String)matcher.group(2))) {
                        mtfv.setFieldPrecision(Integer.valueOf(matcher.group(2)));
                    } else {
                        mtfv.setFieldPrecision(0);
                    }
                }
            } else {
                mtfv.setFieldType(typeStr);
            }
            mtfv.setObjectId(fbiv.getObjectId());
            fieldList.add(mtfv);
        }
        for (ModelTableFieldVO mtfv : fieldList) {
            try {
                this.insertModelTableField(mtfv);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                return this.getResponseData(e.getMessage());
            }
        }
        return this.getResponseData("\u6279\u91cf\u5bfc\u5165\u5b8c\u6210!");
    }

    @DeleteMapping(value={"/model/table/field"})
    @DevLog(action=LogAction.Delete, desc="\u5220\u9664\u5b57\u6bb5 ${args[0].fieldId}")
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody ModelTableFieldVO inModelTableFieldVo) {
        int outputVo = this.modelTableFieldService.deleteByPk(inModelTableFieldVo);
        return this.getResponseData(outputVo);
    }

    @PutMapping(value={"/model/table/field"})
    @DevLog(action=LogAction.Update, desc="\u66f4\u65b0\u5b57\u6bb5 ${args[1].fieldName} ${args[1].fieldCode}", objectId="${args[1].objectId}")
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestParam(value="needUpdateIsrv", required=false) String needUpdateIsrv, @RequestBody ModelTableFieldVO inModelTableFieldVo) {
        inModelTableFieldVo.setLastModifyUser(this.getUserInfo().getUserId());
        inModelTableFieldVo.setLastModifyTime(CurrentDateUtil.getTodayDateEx2());
        if (PubStdSwitchEnum.ON.getCode().equals(inModelTableFieldVo.getIsPk())) {
            inModelTableFieldVo.setIsPk(PubStdYnEnum.Y.getCode());
        } else {
            inModelTableFieldVo.setIsPk(PubStdYnEnum.N.getCode());
        }
        if (PubStdSwitchEnum.ON.getCode().equals(inModelTableFieldVo.getIsAllowNull())) {
            inModelTableFieldVo.setIsAllowNull(PubStdYnEnum.Y.getCode());
        } else {
            inModelTableFieldVo.setIsAllowNull(PubStdYnEnum.N.getCode());
        }
        int outputVo = this.modelTableFieldService.updateByPk(inModelTableFieldVo);
        return this.getResponseData(outputVo);
    }

    @PutMapping(value={"/model/table/field/ioflag"})
    @DevLog(action=LogAction.Update, desc="\u66f4\u65b0\u5b57\u6bb5 ${args[0].fieldId}", srvModelId="${args[0].srvModelId}")
    @ResponseBody
    public ResponseData<Integer> updateIoFlagByPk(@RequestBody ModelTableFieldVO inModelTableFieldVo) {
        inModelTableFieldVo.setLastModifyUser(this.getUserInfo().getUserId());
        inModelTableFieldVo.setLastModifyTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = this.modelTableFieldService.updateFieldByPk(inModelTableFieldVo);
        return this.getResponseData(outputVo);
    }

    @GetMapping(value={"/model/table/field/{sourceId}/{targetId}"})
    @ResponseBody
    public ResponseData<Integer> doExchange(@PathVariable(value="sourceId") String sourceId, @PathVariable(value="targetId") String targetId) {
        int outputVo = this.modelTableFieldService.doExchange(sourceId, targetId);
        return this.getResponseData(outputVo);
    }

    @GetMapping(value={"/model/table/field/up/{fieldId}"})
    @ResponseBody
    public ResponseData<Integer> fieldSortUp(@PathVariable(value="fieldId") String fieldId) {
        int outputVo = this.modelTableFieldService.fieldSortUp(fieldId);
        return this.getResponseData(outputVo);
    }

    @GetMapping(value={"/model/table/field/down/{fieldId}"})
    @ResponseBody
    public ResponseData<Integer> fieldSortDown(@PathVariable(value="fieldId") String fieldId) {
        int outputVo = this.modelTableFieldService.fieldSortDown(fieldId);
        return this.getResponseData(outputVo);
    }

    @GetMapping(value={"/model/table/field/{fieldId}"})
    @ResponseBody
    public ResponseData<ModelTableFieldVO> queryByPk(@PathVariable(value="fieldId") String fieldId, @RequestParam(value="srvModelCatalog", required=false) String srvModelCatalog, @RequestParam(value="srvModelType", required=false) String srvModelType) {
        ModelTableFieldVO inVo = new ModelTableFieldVO();
        inVo.setFieldId(fieldId);
        inVo.setSrvModelCatalog(srvModelCatalog);
        inVo.setSrvModelType(srvModelType);
        ModelTableFieldVO outputVo = this.modelTableFieldService.queryByPk(inVo);
        return this.getResponseData((Object)outputVo);
    }

    @RequestMapping(value={"/model/table/fields"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<ModelTableFieldVO>> queryModelTableFieldAll(ModelTableFieldVO vo) {
        List<ModelTableFieldVO> outputVo = null;
        this.setUserInfoToVO((Object)vo);
        outputVo = this.modelTableFieldService.queryAllByLevelOne(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/model/table/fields2"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<ModelTableFieldVO>> queryModelTableFields(ModelTableFieldVO vo) {
        List<ModelTableFieldVO> outputVo = null;
        this.setUserInfoToVO((Object)vo);
        outputVo = this.modelTableFieldService.queryModelTableFields(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/model/table/fields/withflag"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<ModelTableFieldVO>> queryFieldWithFieldFlag(@RequestParam(value="objectId") String objectId, @RequestParam(value="srvModelCatalog") String srvModelCatalog, @RequestParam(value="srvModelType") String srvModelType) {
        List<ModelTableFieldVO> outputVo = this.modelTableFieldService.queryFieldWithFieldFlag(objectId, srvModelCatalog, srvModelType);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/model/table/field/quicks"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<ModelTableFieldVO>> queryExistsFieldByPage(ModelTableFieldVO vo) {
        List<ModelTableFieldVO> outputVo = null;
        this.setUserInfoToVO((Object)vo);
        outputVo = this.modelTableFieldService.queryExistsFieldByPage(vo);
        return this.getResponseData(outputVo);
    }

    @PostMapping(value={"/model/table/field/copyfromother"})
    @DevLog(action=LogAction.Add, desc="\u4ece\u5176\u5b83\u8868\u590d\u5236\u5b57\u6bb5 ${args[0].fieldName} ${args[0].objectId}", objectId="${args[0].objectId}")
    @ResponseBody
    public ResponseData<Integer> insertModelTableField(@RequestBody Map<String, Object> copyData) {
        int num = 0;
        String userId = this.getUserInfo().getUserId();
        String now = CurrentDateUtil.getTodayDateEx2();
        String objectId = MapUtils.getString(copyData, (Object)"objectId");
        List fieldIds = (List)copyData.get("fieldIds");
        if (CollectionUtils.isNotEmpty((Collection)fieldIds)) {
            for (String fieldId : fieldIds) {
                ModelTableFieldVO fieldParam = new ModelTableFieldVO();
                fieldParam.setFieldId(fieldId);
                if ((fieldParam = this.modelTableFieldService.queryByPk(fieldParam)) == null) continue;
                fieldParam.setFieldId(UUIDUtil.getUUID());
                fieldParam.setObjectId(objectId);
                fieldParam.setCreateUser(userId);
                fieldParam.setCreateTime(now);
                fieldParam.setLastModifyUser(userId);
                fieldParam.setLastModifyTime(now);
                num += this.modelTableFieldService.insertModelTableField(fieldParam);
            }
        }
        return this.getResponseData(num);
    }

    @RequestMapping(value={"/model/table/field/markcheckdetail"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<ModelTableFieldVO>> markcheckdetail(ModelTableFieldVO param) {
        List<ModelTableFieldVO> modelTableFieldVOS = this.modelTableFieldService.queryModelTableFields(param);
        for (ModelTableFieldVO modelTableFieldVO : modelTableFieldVOS) {
            modelTableFieldVO.setFieldTypeFormat(ModelTableFieldController.extracted(modelTableFieldVO.getFieldType(), modelTableFieldVO.getFieldLength(), modelTableFieldVO.getFieldPrecision()));
            modelTableFieldVO.setPreFieldTypeFormat(ModelTableFieldController.extracted(modelTableFieldVO.getPreFieldType(), modelTableFieldVO.getPreFieldLength(), modelTableFieldVO.getPreFieldPrecision()));
        }
        return this.getResponseData(modelTableFieldVOS);
    }

    private static String extracted(String fieldType, Integer fieldLength, Integer fieldPrecision) {
        if (fieldLength == null && fieldPrecision == null) {
            return fieldType;
        }
        if (fieldLength != null && fieldPrecision == null) {
            return String.join((CharSequence)"", fieldType, "(", String.valueOf(fieldLength), ")");
        }
        return String.join((CharSequence)"", fieldType, "(", String.valueOf(fieldLength), ",", String.valueOf(fieldPrecision), ")");
    }
}

