/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinpaas.console.dmcenter.api.rest;

import com.irdstudio.allinpaas.console.dmcenter.common.util.CurrentDateUtil;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.ModelTableIndexService;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.ModelTableIndexVO;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.AbstractController;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class ModelTableIndexController
extends AbstractController {
    @Autowired
    @Qualifier(value="modelTableIndexService")
    private ModelTableIndexService modelTableIndexService;

    @PostMapping(value={"/model/table/index"})
    @ResponseBody
    public ResponseData<Integer> insertModelTableIndex(@RequestBody ModelTableIndexVO inModelTableIndexVo) {
        this.setUserInfoToVO((Object)inModelTableIndexVo);
        inModelTableIndexVo.setCreateUser(this.getUserInfo().getUserId());
        inModelTableIndexVo.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        inModelTableIndexVo.setLastModifyUser(this.getUserInfo().getUserId());
        inModelTableIndexVo.setLastModifyTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = this.modelTableIndexService.insertModelTableIndex(inModelTableIndexVo);
        return this.getResponseData(outputVo);
    }

    @DeleteMapping(value={"/model/table/index"})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody ModelTableIndexVO inModelTableIndexVo) {
        int outputVo = this.modelTableIndexService.deleteByPk(inModelTableIndexVo);
        return this.getResponseData(outputVo);
    }

    @PutMapping(value={"/model/table/index"})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody ModelTableIndexVO inModelTableIndexVo) {
        this.setUserInfoToVO((Object)inModelTableIndexVo);
        inModelTableIndexVo.setLastModifyUser(this.getUserInfo().getUserId());
        inModelTableIndexVo.setLastModifyTime(CurrentDateUtil.getTodayDateEx2());
        int outputVo = this.modelTableIndexService.updateByPk(inModelTableIndexVo);
        return this.getResponseData(outputVo);
    }

    @GetMapping(value={"/model/table/index/{objectId}/{indexName}"})
    @ResponseBody
    public ResponseData<ModelTableIndexVO> queryByPk(@PathVariable(value="objectId") String objectId, @PathVariable(value="indexName") String indexName) {
        ModelTableIndexVO inVo = new ModelTableIndexVO();
        inVo.setObjectId(objectId);
        inVo.setIndexName(indexName);
        ModelTableIndexVO outputVo = this.modelTableIndexService.queryByPk(inVo);
        return this.getResponseData((Object)outputVo);
    }

    @RequestMapping(value={"/model/table/indexs"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<ModelTableIndexVO>> queryModelTableIndexAll(ModelTableIndexVO vo) {
        List<ModelTableIndexVO> outputVo = null;
        this.setUserInfoToVO((Object)vo);
        outputVo = this.modelTableIndexService.queryAllByLevelOne(vo);
        return this.getResponseData(outputVo);
    }
}

