/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinpaas.console.dmcenter.api.rest;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.metadata.Cell;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.fastjson.JSON;
import com.irdstudio.allinpaas.common.enums.YesOrNO;
import com.irdstudio.allinpaas.console.dmcenter.common.annotations.DevLog;
import com.irdstudio.allinpaas.console.dmcenter.common.enums.LogAction;
import com.irdstudio.allinpaas.console.dmcenter.common.util.CurrentDateUtil;
import com.irdstudio.allinpaas.console.dmcenter.common.util.KeyUtil;
import com.irdstudio.allinpaas.console.dmcenter.common.util.TablePropertyUtil;
import com.irdstudio.allinpaas.console.dmcenter.common.util.WebUtil;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.DictOptionEnumService;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.ModelJoinDetailService;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.ModelTableFieldService;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.ModelTableIndexService;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.ModelTableInfoService;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.ProjectTmInfoService;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.ProjectTmLogService;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.ProjectTmPackageService;
import com.irdstudio.allinpaas.console.dmcenter.service.facade.PubDbmsDatatypeService;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.ModelTableFieldVO;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.ModelTableIndexVO;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.ModelTableInfoVO;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.ProjectTmInfoVO;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.ProjectTmLogVO;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.ProjectTmPackageVO;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.PubDbmsDatatypeVO;
import com.irdstudio.allinpaas.executor.core.plugin.docs.git.queue.DocTemplateRepoPullQueueExecutor;
import com.irdstudio.allinpaas.executor.core.util.db.plugin.DataBaseSQLScriptPlugin;
import com.irdstudio.allinpaas.executor.core.util.db.plugin.ModelTableStructVO;
import com.irdstudio.sdk.beans.core.util.ResourceCloseUtil;
import com.irdstudio.sdk.beans.core.util.StringUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.AbstractController;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api"})
public class ModelTableInfoController
extends AbstractController {
    private static final Pattern pattern = Pattern.compile("\\w+\\(\\s*(\\d+),?(\\d*)(\\s+BYTE)*\\s*\\)");
    @Autowired
    @Qualifier(value="modelTableInfoService")
    private ModelTableInfoService modelTableInfoService;
    @Autowired
    @Qualifier(value="projectTmPackageService")
    private ProjectTmPackageService projectTmPackageService;
    @Autowired
    @Qualifier(value="projectTmLogService")
    private ProjectTmLogService projectTmLogService;
    @Autowired
    @Qualifier(value="modelTableFieldService")
    private ModelTableFieldService modelTableFieldService;
    @Autowired
    @Qualifier(value="modelTableIndexService")
    private ModelTableIndexService modelTableIndexService;
    @Autowired
    @Qualifier(value="projectTmInfoService")
    private ProjectTmInfoService projectTmInfoService;
    @Autowired
    @Qualifier(value="dictOptionEnumService")
    private DictOptionEnumService dictOptionEnumService;
    @Autowired
    @Qualifier(value="pubDbmsDatatypeService")
    private PubDbmsDatatypeService pubDbmsDatatypeService;
    @Autowired
    @Qualifier(value="modelJoinDetailServiceImpl")
    private ModelJoinDetailService modelJoinDetailService;
    @Autowired
    private HttpServletRequest request;

    @PostMapping(value={"/model/table/info"})
    @DevLog(action=LogAction.Add, desc="\u65b0\u5efa\u8868\u6a21\u578b ${args[0].objectCode} ${args[0].objectName}", objectId="${args[0].objectId}", projectId="${args[0].projectId}")
    @ResponseBody
    public ResponseData<String> insertModelTableInfo(@RequestBody ModelTableInfoVO inModelTableInfoVo) {
        if (StringUtils.isBlank((CharSequence)inModelTableInfoVo.getObjectId())) {
            inModelTableInfoVo.setObjectId(KeyUtil.createUUIDKey());
        }
        inModelTableInfoVo.setCreateUser(this.getUserInfo().getUserId());
        inModelTableInfoVo.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        inModelTableInfoVo.setLastModifyUser(this.getUserInfo().getUserId());
        inModelTableInfoVo.setLastModifyTime(CurrentDateUtil.getTodayDateEx2());
        inModelTableInfoVo.setObjectCode(StringUtils.trim((String)inModelTableInfoVo.getObjectCode()));
        if (!StringUtil.isJavaIdentifier((String)inModelTableInfoVo.getObjectCode())) {
            ResponseData res = this.getResponseData("-1");
            res.setMessage("\u8868\u6a21\u578b\u4ee3\u7801\u547d\u540d\u5305\u542b\u975e\u6cd5\u5b57\u7b26");
            return res;
        }
        ProjectTmPackageVO inVo = new ProjectTmPackageVO();
        inVo.setPackageId(inModelTableInfoVo.getPackageId());
        inVo = this.projectTmPackageService.queryByPk(inVo);
        if (inVo == null) {
            ProjectTmInfoVO infoParam = new ProjectTmInfoVO();
            infoParam.setProjectId(inModelTableInfoVo.getProjectId());
            ProjectTmInfoVO tmInfo = this.projectTmInfoService.queryByPk(infoParam);
            inVo = new ProjectTmPackageVO();
            inVo.setPackageId(tmInfo.getProjectId());
            inVo.setPackageId(tmInfo.getProjectId());
            inVo.setPackageCode(tmInfo.getProjectCode());
            inVo.setPackageName(tmInfo.getProjectName());
            inVo.setPackageAbvId("0");
            inVo.setPackageType(0);
            inVo.setPackageDesc(tmInfo.getProjectName());
            inVo.setOrderValue(0);
            inVo.setCreateUser(tmInfo.getCreateUser());
            inVo.setCreateTime(CurrentDateUtil.getTodayDateEx2());
            inVo.setLastModifyUser(tmInfo.getCreateUser());
            inVo.setLastModifyTime(CurrentDateUtil.getTodayDateEx2());
            inVo.setPackageLocation(tmInfo.getProjectName() + "/");
            this.projectTmPackageService.insertProjectTmPackage(inVo);
        }
        inModelTableInfoVo.setObjectLocation(inVo.getPackageLocation());
        int outputVo = this.modelTableInfoService.insertModelTableInfo(inModelTableInfoVo);
        ProjectTmLogVO ptlv = new ProjectTmLogVO();
        ptlv.setRecordKeyid(KeyUtil.createUUIDKey());
        ptlv.setClientIp(WebUtil.getClientIp(this.request));
        ptlv.setOperUserid(this.getUserInfo().getUserId());
        ptlv.setLogRecordTime(CurrentDateUtil.getTodayDateEx2());
        ptlv.setProjectId(inModelTableInfoVo.getProjectId());
        ptlv.setLogContent("\u521b\u5efa\u8868\u6a21\u578b[" + inModelTableInfoVo.getObjectCode() + "]");
        this.projectTmLogService.insertProjectTmLog(ptlv);
        return this.getResponseData(inModelTableInfoVo.getObjectId());
    }

    @DeleteMapping(value={"/model/table/info"})
    @DevLog(action=LogAction.Delete, desc="\u5220\u9664\u8868\u6a21\u578b ${args[0].objectId}", objectId="${args[0].objectId}")
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody ModelTableInfoVO inModelTableInfoVo) {
        this.modelTableFieldService.deleteByObjectId(inModelTableInfoVo.getObjectId());
        this.modelTableIndexService.deleteByObjectId(inModelTableInfoVo.getObjectId());
        int outputVo = this.modelTableInfoService.deleteByPk(inModelTableInfoVo);
        this.modelJoinDetailService.deleteByJoinDetailId(inModelTableInfoVo.getObjectId());
        return this.getResponseData(outputVo);
    }

    @PutMapping(value={"/model/table/info"})
    @DevLog(action=LogAction.Update, desc="\u66f4\u65b0\u8868\u6a21\u578b ${args[0].objectCode} ${args[0].objectName} ", objectId="${args[0].objectId}", projectId="${args[0].projectId}")
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody ModelTableInfoVO inModelTableInfoVo) {
        inModelTableInfoVo.setObjectCode(StringUtils.trim((String)inModelTableInfoVo.getObjectCode()));
        this.setUserInfoToVO((Object)inModelTableInfoVo);
        inModelTableInfoVo.setLastModifyUser(this.getUserInfo().getUserId());
        inModelTableInfoVo.setLastModifyTime(CurrentDateUtil.getTodayDateEx2());
        if (!StringUtil.isJavaIdentifier((String)inModelTableInfoVo.getObjectCode())) {
            ResponseData res = this.getResponseData(-1);
            res.setMessage("\u8868\u6a21\u578b\u4ee3\u7801\u547d\u540d\u5305\u542b\u975e\u6cd5\u5b57\u7b26");
            return res;
        }
        int outputVo = this.modelTableInfoService.updateByPk(inModelTableInfoVo);
        return this.getResponseData(outputVo);
    }

    @GetMapping(value={"/model/table/info/{objectId}"})
    @ResponseBody
    public ResponseData<ModelTableInfoVO> queryByPk(@PathVariable(value="objectId") String objectId) {
        ModelTableInfoVO inVo = new ModelTableInfoVO();
        inVo.setObjectId(objectId);
        ModelTableInfoVO outputVo = this.modelTableInfoService.queryByPk(inVo);
        return this.getResponseData((Object)outputVo);
    }

    @GetMapping(value={"/model/table/merge"})
    @ResponseBody
    public ResponseData<Integer> mergeToTargetTable(@RequestParam(value="objectId") String objectId, @RequestParam(value="srcObjectId") String srcObjectId) {
        try {
            int rs = this.modelTableFieldService.mergeModelTableField(objectId, srcObjectId);
            return this.getResponseData(rs);
        }
        catch (Exception e) {
            ResponseData resp = this.getResponseData(-1);
            resp.setMessage(e.getMessage());
            return resp;
        }
    }

    @GetMapping(value={"/model/table/copy/tb"})
    @DevLog(action=LogAction.Add, desc="\u590d\u5236\u8868\u6a21\u578b\u521b\u5efa ${args[0]}  ${args[1]}", objectId="${args[0]}", projectId="${args[1]}")
    @ResponseBody
    public ResponseData<Integer> copyTo(@RequestParam(value="objectId") String objectId, @RequestParam(value="projectId") String projectId, @RequestParam(value="packageId") String packageId, @RequestParam(value="objectType") int objectType) {
        ModelTableInfoVO inVo = new ModelTableInfoVO();
        inVo.setObjectId(objectId);
        ModelTableInfoVO modelTableInfo = this.modelTableInfoService.queryByPk(inVo);
        modelTableInfo.setObjectId(KeyUtil.createUUIDKey());
        modelTableInfo.setCreateUser(this.getUserInfo().getUserId());
        modelTableInfo.setCreateTime(CurrentDateUtil.getTodayDateEx2());
        ProjectTmPackageVO targetPackage = new ProjectTmPackageVO();
        targetPackage.setPackageId(packageId);
        targetPackage = this.projectTmPackageService.queryByPk(targetPackage);
        if (targetPackage != null) {
            modelTableInfo.setObjectLocation(targetPackage.getPackageLocation());
            modelTableInfo.setProjectId(targetPackage.getProjectId());
        }
        modelTableInfo.setPackageId(packageId);
        modelTableInfo.setObjectType(objectType);
        modelTableInfo.setObjectCode("copyOf" + modelTableInfo.getObjectCode());
        modelTableInfo.setProjectId(projectId);
        int num = this.modelTableInfoService.insertModelTableInfo(modelTableInfo);
        num = this.modelTableFieldService.copyModelTableField(objectId, modelTableInfo.getObjectId());
        num = this.modelTableIndexService.copyModelTableIndex(objectId, modelTableInfo.getObjectId());
        ProjectTmLogVO ptlv = new ProjectTmLogVO();
        ptlv.setRecordKeyid(KeyUtil.createUUIDKey());
        ptlv.setClientIp(WebUtil.getClientIp(this.request));
        ptlv.setOperUserid(this.getUserInfo().getUserId());
        ptlv.setLogRecordTime(CurrentDateUtil.getTodayDateEx2());
        ptlv.setProjectId(projectId);
        ptlv.setLogContent("\u521b\u5efa\u8868\u6a21\u578b[" + modelTableInfo.getObjectCode() + "]");
        this.projectTmLogService.insertProjectTmLog(ptlv);
        return this.getResponseData(num);
    }

    @GetMapping(value={"/model/table/script/{objectId}"})
    @ResponseBody
    public ResponseData<String> generateDDL(@PathVariable(value="objectId") String objectId) {
        ModelTableInfoVO inVo = new ModelTableInfoVO();
        inVo.setObjectId(objectId);
        ModelTableInfoVO outputVo = this.modelTableInfoService.queryByPk(inVo);
        ProjectTmInfoVO projectTmInfoVo = new ProjectTmInfoVO();
        projectTmInfoVo.setProjectId(outputVo.getProjectId());
        projectTmInfoVo = this.projectTmInfoService.queryByPk(projectTmInfoVo);
        ModelTableFieldVO modelTableFieldVO = new ModelTableFieldVO();
        modelTableFieldVO.setObjectId(objectId);
        List<ModelTableFieldVO> modelTableFieldVOs = this.modelTableFieldService.queryModelTableField(modelTableFieldVO);
        PubDbmsDatatypeVO pubParam = new PubDbmsDatatypeVO();
        pubParam.setSize(1000);
        pubParam.setDbmsId(projectTmInfoVo.getProjectDbms());
        List<PubDbmsDatatypeVO> dbmsTypes = this.pubDbmsDatatypeService.queryAllByLevelOne(pubParam);
        HashMap<String, PubDbmsDatatypeVO> dbmsTypeMap = new HashMap<String, PubDbmsDatatypeVO>();
        if (CollectionUtils.isNotEmpty(dbmsTypes)) {
            for (PubDbmsDatatypeVO tt : dbmsTypes) {
                dbmsTypeMap.put(tt.getDbmsDatatypeCode(), tt);
            }
            if (CollectionUtils.isNotEmpty(modelTableFieldVOs)) {
                for (ModelTableFieldVO ff : modelTableFieldVOs) {
                    PubDbmsDatatypeVO dt = (PubDbmsDatatypeVO)((Object)dbmsTypeMap.get(ff.getFieldType()));
                    if (dt == null || !StringUtils.equals((CharSequence)dt.getIsNeedLength(), (CharSequence)"N")) continue;
                    ff.setFieldLength(0);
                }
            }
        }
        com.irdstudio.allinpaas.console.dmcenter.service.vo.ModelTableStructVO genSQLScript = new com.irdstudio.allinpaas.console.dmcenter.service.vo.ModelTableStructVO();
        genSQLScript.setDbms(String.valueOf(projectTmInfoVo.getProjectDbms()));
        genSQLScript.setTable(outputVo);
        genSQLScript.setFields(modelTableFieldVOs);
        DataBaseSQLScriptPlugin plugin = new DataBaseSQLScriptPlugin();
        ModelTableIndexVO indexParam = new ModelTableIndexVO();
        indexParam.setObjectId(objectId);
        indexParam.setIndexTypePrimary(YesOrNO.NO.getCode());
        indexParam.setSize(1000);
        List<ModelTableIndexVO> indexList = this.modelTableIndexService.queryAllByLevelOne(indexParam);
        genSQLScript.setIndexs(indexList);
        ModelTableStructVO genParam = (ModelTableStructVO)JSON.parseObject((String)JSON.toJSONString((Object)genSQLScript), ModelTableStructVO.class);
        return this.getResponseData(plugin.generateDDLScript(genParam));
    }

    @RequestMapping(value={"/model/table/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<ModelTableInfoVO>> queryModelTableInfoAll(ModelTableInfoVO vo) {
        List<ModelTableInfoVO> outputVo = null;
        this.setUserInfoToVO((Object)vo);
        outputVo = this.modelTableInfoService.queryAllByLevelOne(vo);
        if (Objects.nonNull(outputVo) && outputVo.size() > 0) {
            for (ModelTableInfoVO infoVO : outputVo) {
                infoVO.setTableModelId(TablePropertyUtil.tableName2TableModelId(infoVO.getObjectCode()));
            }
        }
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/model/table/info/isolates"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<ModelTableInfoVO>> queryAllIsolateTableByPage(ModelTableInfoVO vo) {
        List<ModelTableInfoVO> outputVo = null;
        this.setUserInfoToVO((Object)vo);
        outputVo = this.modelTableInfoService.queryAllIsolateTableByPage(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/model/table/info/not/page"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<ModelTableInfoVO>> queryModelTableInfoAllNotPage(ModelTableInfoVO vo) {
        List<ModelTableInfoVO> outputVo = null;
        this.setUserInfoToVO((Object)vo);
        outputVo = this.modelTableInfoService.queryAllNotPage(vo);
        if (Objects.nonNull(outputVo) && outputVo.size() > 0) {
            for (ModelTableInfoVO infoVO : outputVo) {
                infoVO.setTableModelId(TablePropertyUtil.tableName2TableModelId(infoVO.getObjectCode()));
            }
        }
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/project/model/table/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<ModelTableInfoVO>> queryProjectModelTableInfoAll(ModelTableInfoVO vo) {
        List<ModelTableInfoVO> outputVo = null;
        this.setUserInfoToVO((Object)vo);
        outputVo = this.modelTableInfoService.queryAllByLevelTwo(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/all/model/table/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<ModelTableInfoVO>> queryAllModelTableInfo(ModelTableInfoVO vo) {
        List<ModelTableInfoVO> outputVo = null;
        this.setUserInfoToVO((Object)vo);
        outputVo = this.modelTableInfoService.queryAllByLevelThree(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/model/table/infos/srv"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<ModelTableInfoVO>> queryAllModelTableInfoWithSrv(ModelTableInfoVO vo) {
        List<ModelTableInfoVO> outputVo = null;
        this.setUserInfoToVO((Object)vo);
        if (vo.getObjectType() != null && vo.getObjectType().equals(2001)) {
            vo.setObjectTypes(Arrays.asList("2001", "2003", "2004"));
            vo.setObjectType(null);
        }
        outputVo = this.modelTableInfoService.queryAllByLevelOneWithSrv(vo);
        return this.getResponseData(outputVo);
    }

    @GetMapping(value={"/model/table/info/sort"})
    @ResponseBody
    public ResponseData<Integer> tableSort(@RequestParam(value="objectId") String objectId, @RequestParam(value="upFlag") Boolean upFlag) {
        ModelTableInfoVO tableVO = new ModelTableInfoVO();
        tableVO.setObjectId(objectId);
        this.setUserInfoToVO((Object)tableVO);
        int outputVo = this.modelTableInfoService.updateTableOrder(tableVO, upFlag);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/model/table/item/byrefs"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<List<ModelTableFieldVO>> queryModelTableInfoByItemId(ModelTableFieldVO paramVO) {
        List<ModelTableFieldVO> outputVo = null;
        outputVo = this.modelTableInfoService.queryAllByItemId(paramVO);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/model/table/option/byrefs/{dictId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<List<ModelTableInfoVO>> queryModelTableInfoByDictId(@PathVariable(value="dictId") String dictId) {
        List<ModelTableInfoVO> outputVo = null;
        outputVo = this.modelTableInfoService.queryAllByDictId(dictId);
        return this.getResponseData(outputVo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/model/table/excel/template"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Boolean> excelTemplateDownload(HttpServletResponse response) {
        ResponseData responseData;
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        try {
            int bytesRead;
            DocTemplateRepoPullQueueExecutor.syncRun();
            String templateRootPath = DocTemplateRepoPullQueueExecutor.getDocTemplatePath();
            File file = new File(templateRootPath + File.separator + "xlsx" + File.separator + "modelTableInfoImportTemplate.xlsx");
            response.setContentType("application/vnd.ms-excel;charset=utf-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + new String("\u5bfc\u5165\u8868\u6a21\u677f.xlsx".getBytes(), "iso-8859-1"));
            ServletOutputStream out = response.getOutputStream();
            bis = new BufferedInputStream(new FileInputStream(file));
            bos = new BufferedOutputStream((OutputStream)out);
            byte[] buff = new byte[2048];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                bos.write(buff, 0, bytesRead);
            }
            responseData = this.getResponseData(true);
            ResourceCloseUtil.closeInputStream((InputStream)bis);
        }
        catch (Exception e) {
            logger.error("\u4e0b\u8f7dexcel\u6a21\u578b\u5f02\u5e38", (Throwable)e);
            ResponseData responseData2 = this.getResponseData(false);
            return responseData2;
        }
        finally {
            ResourceCloseUtil.closeInputStream(bis);
            ResourceCloseUtil.closeOutputStream(bos);
        }
        ResourceCloseUtil.closeOutputStream((OutputStream)bos);
        return responseData;
    }

    @ResponseBody
    public ResponseData<ModelTableInfoVO> copyModelTable(@RequestBody ModelTableInfoVO vo) {
        this.setUserInfoToVO((Object)vo);
        vo.setCreateUser(this.getUserInfo().getUserId());
        ModelTableInfoVO copyTb = this.modelTableInfoService.copyModelTableInfo(vo);
        return this.getResponseData((Object)copyTb);
    }

    @RequestMapping(value={"/model/table/sql"}, method={RequestMethod.POST})
    @DevLog(action=LogAction.Add, desc="\u4eceSQL\u521b\u5efa\u8868\u6a21\u578b", projectId="${args[0].projectId}")
    @ResponseBody
    public ResponseData<ModelTableInfoVO> createModelTableInfoBySQL(@RequestBody Map<String, String> param) {
        String projectId = param.get("projectId");
        String packageId = param.get("packageId");
        String objectType = param.get("objectType");
        String sql = param.get("sql");
        String userId = this.getUserInfo().getUserId();
        ModelTableInfoVO tb = this.modelTableInfoService.createModelTableInfoBySQL(projectId, packageId, objectType, userId, sql);
        if (tb == null) {
            ResponseData res = this.getResponseData((Object)tb);
            res.setMessage("\u521b\u5efa\u5931\u8d25");
            return res;
        }
        return this.getResponseData((Object)tb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/model/table/excel"})
    @DevLog(action=LogAction.Add, desc="\u4eceExcel\u4e2d\u5bfc\u5165\u8868\u6a21\u578b", projectId="${args[0].projectId}")
    @ResponseBody
    public ResponseData<String> uploadExcel(@RequestParam(value="projectId") String projectId, @RequestParam(value="packageId") String packageId, @RequestParam(value="objectType") String objectType, @RequestPart(value="file") MultipartFile file) {
        String fileName = file.getOriginalFilename();
        if (StringUtil.isNullorBank((String)fileName)) {
            fileName = file.getName();
        }
        try {
            final ModelTableInfoVO tableInfo = new ModelTableInfoVO();
            final ArrayList fields = new ArrayList();
            final ArrayList indexs = new ArrayList();
            final AtomicInteger indexLen = new AtomicInteger(0);
            ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)file.getInputStream(), ModelTableIndexData.class, (ReadListener)new AnalysisEventListener<ModelTableIndexData>(){

                public void invokeHead(Map<Integer, CellData> headMap, AnalysisContext context) {
                    logger.info(headMap.toString());
                    if (headMap.get(0).getStringValue().equals("\u7269\u7406\u8868\u540d\u79f0")) {
                        tableInfo.setObjectCode(StringUtils.lowerCase((String)headMap.get(2).getStringValue()));
                        tableInfo.setObjectName(headMap.get(4).getStringValue());
                        tableInfo.setObjectDesc(headMap.get(4).getStringValue());
                    } else if (headMap.get(0).getStringValue().equals("\u7269\u7406\u8868\u540d")) {
                        tableInfo.setObjectCode(StringUtils.lowerCase((String)headMap.get(1).getStringValue()));
                        tableInfo.setObjectName(headMap.get(3).getStringValue());
                        tableInfo.setObjectDesc(headMap.get(3).getStringValue());
                    } else if (headMap.get(0).getStringValue().equals("\u6240\u5c5e\u4e3b\u9898\u57df") && headMap.get(2) != null) {
                        tableInfo.setSubjectId(headMap.get(2).getStringValue());
                    } else if (headMap.get(0).getStringValue().equals("\u4e3b\u952e") && headMap.get(1) != null) {
                        ModelTableIndexVO primary = new ModelTableIndexVO();
                        primary.setIndexFields(StringUtils.lowerCase((String)headMap.get(1).getStringValue()));
                        primary.setIndexName("PK_" + tableInfo.getObjectCode());
                        primary.setIndexTypePrimary("Y");
                        primary.setIndexTypeUnique("N");
                        indexs.add(primary);
                    }
                }

                public void invoke(ModelTableIndexData data, AnalysisContext context) {
                    logger.info(data.getIndexName());
                    if (StringUtils.isNotEmpty((CharSequence)data.getIndexName()) && (data.getIndexName().equals("\u5e8f\u53f7") || data.getIndexName().equals("\u5b57\u6bb5\u63cf\u8ff0") || data.getIndexName().equals("\u5b57\u6bb5\u540d\u79f0") || data.getIndexName().equals("\u5b57\u6bb5\u540d"))) {
                        int fieldIndex = context.readRowHolder().getRowIndex();
                        indexLen.set(fieldIndex + 1);
                        return;
                    }
                    if (StringUtils.isEmpty((CharSequence)data.getIndexName())) {
                        return;
                    }
                    ModelTableIndexVO index = new ModelTableIndexVO();
                    index.setIndexName(data.getIndexName());
                    index.setIndexFields(StringUtils.lowerCase((String)data.getIndexFields()));
                    if (StringUtils.isNotBlank((CharSequence)data.getIndexType()) && data.getIndexType().equals("\u4e3b\u952e\u7d22\u5f15")) {
                        index.setIndexTypePrimary("Y");
                        index.setIndexTypeUnique("N");
                    } else if (StringUtils.isNotBlank((CharSequence)data.getIndexType()) && data.getIndexType().equals("\u552f\u4e00\u7d22\u5f15")) {
                        index.setIndexTypeUnique("Y");
                        index.setIndexTypePrimary("N");
                    } else {
                        index.setIndexTypePrimary("N");
                        index.setIndexTypeUnique("N");
                    }
                    indexs.add(index);
                }

                public void doAfterAllAnalysed(AnalysisContext context) {
                }

                public boolean hasNext(AnalysisContext context) {
                    String value = ((Cell)context.readRowHolder().getCellMap().get(0)).toString();
                    return value == null || !value.equals("\u5e8f\u53f7") && !value.equals("\u5b57\u6bb5\u63cf\u8ff0") && !value.equals("\u5b57\u6bb5\u540d\u79f0") && !value.equals("\u5b57\u6bb5\u540d");
                }
            }).sheet().headRowNumber(Integer.valueOf(3))).doReadSync();
            ModelTableIndexVO primaryKey = null;
            for (ModelTableIndexVO index : indexs) {
                if (!index.getIndexTypePrimary().equalsIgnoreCase("Y")) continue;
                primaryKey = index;
                break;
            }
            final ModelTableIndexVO finalPrimaryKey = primaryKey;
            ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)file.getInputStream(), ModelTableRowData.class, (ReadListener)new AnalysisEventListener<ModelTableRowData>(){

                public void invoke(ModelTableRowData data, AnalysisContext context) {
                    logger.info(data.getFieldCode() + "-" + data.getFieldName());
                    ModelTableFieldVO field = new ModelTableFieldVO();
                    field.setFieldOrder(data.getFieldOrder() != null ? Integer.valueOf(data.getFieldOrder()) : context.readRowHolder().getRowIndex() - indexLen.get());
                    field.setFieldCode(StringUtils.lowerCase((String)data.getFieldCode()));
                    field.setFieldName(data.getFieldName());
                    if (data.getFieldType().contains("(")) {
                        field.setFieldType(data.getFieldType().substring(0, data.getFieldType().indexOf("(")));
                        Matcher matcher = pattern.matcher(data.getFieldType());
                        if (matcher.matches()) {
                            field.setFieldLength(Integer.valueOf(matcher.group(1)));
                            if (StringUtils.isNotEmpty((CharSequence)matcher.group(2))) {
                                field.setFieldPrecision(Integer.valueOf(matcher.group(2)));
                            }
                        }
                    } else {
                        field.setFieldType(data.getFieldType());
                    }
                    field.setFieldDesc(data.getFieldDesc());
                    if (data.getIsAllowNull() != null && (data.getIsAllowNull().equals("N") || data.getIsAllowNull().equals("Y"))) {
                        field.setIsAllowNull(data.getIsAllowNull());
                    } else {
                        field.setIsAllowNull(data.getIsAllowNull() != null && data.getIsAllowNull().equals("\u662f") ? "Y" : "N");
                    }
                    if (finalPrimaryKey != null && finalPrimaryKey.getIndexFields() != null && finalPrimaryKey.getIndexFields().contains(field.getFieldCode())) {
                        field.setIsPk("Y");
                    } else {
                        field.setIsPk("N");
                    }
                    fields.add(field);
                }

                public void doAfterAllAnalysed(AnalysisContext context) {
                }
            }).sheet().headRowNumber(Integer.valueOf(indexLen.get()))).doReadSync();
            String createTime = CurrentDateUtil.getTodayDateEx2();
            String createUser = this.getUserInfo().getUserId();
            tableInfo.setObjectId(KeyUtil.createUUIDKey());
            tableInfo.setProjectId(projectId);
            tableInfo.setPackageId(packageId);
            tableInfo.setObjectType(Integer.parseInt(objectType));
            tableInfo.setCreateUser(createUser);
            tableInfo.setCreateTime(createTime);
            tableInfo.setLastModifyUser(createUser);
            tableInfo.setLastModifyTime(createTime);
            this.modelTableInfoService.insertModelTableInfo(tableInfo);
            for (ModelTableIndexVO index : indexs) {
                index.setObjectId(tableInfo.getObjectId());
                index.setCreateUser(createUser);
                index.setCreateTime(createTime);
                index.setLastModifyUser(createUser);
                index.setLastModifyTime(createTime);
                index.setIndexName(StringUtils.upperCase((String)index.getIndexName()));
                this.modelTableIndexService.insertModelTableIndex(index);
            }
            for (ModelTableFieldVO field : fields) {
                field.setObjectId(tableInfo.getObjectId());
                field.setFieldId(KeyUtil.createUUIDKey());
                field.setCreateTime(createTime);
                field.setCreateUser(createUser);
                field.setLastModifyUser(createUser);
                field.setLastModifyTime(createTime);
                this.modelTableFieldService.insertModelTableField(field);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            ResponseData responseData = this.getResponseData("F");
            return responseData;
        }
        finally {
            try {
                IOUtils.closeQuietly((InputStream)file.getInputStream());
            }
            catch (IOException e) {
                logger.error("\u83b7\u53d6\u4e0a\u4f20\u6587\u4ef6\u8f93\u5165\u5f02\u5e38", (Throwable)e);
            }
        }
        return this.getResponseData("S");
    }

    public static class ModelTableRowData {
        @ExcelProperty(value={"\u5e8f\u53f7"})
        private String fieldOrder;
        @ExcelProperty(value={"\u5b57\u6bb5\u540d\u79f0"})
        private String fieldCode;
        @ExcelProperty(value={"\u5b57\u6bb5\u63cf\u8ff0"})
        private String fieldName;
        @ExcelProperty(value={"\u6570\u636e\u7c7b\u578b"})
        private String fieldType;
        @ExcelProperty(value={"\u5b57\u6bb5\u8bf4\u660e"})
        private String fieldDesc;
        @ExcelProperty(value={"\u5141\u7a7a"})
        private String isAllowNull;
        @ExcelProperty(value={"\u6240\u5c5e\u4e3b\u9898\u57df"})
        private String subjectId;

        public String getFieldOrder() {
            return this.fieldOrder;
        }

        public void setFieldOrder(String fieldOrder) {
            this.fieldOrder = fieldOrder;
        }

        public String getFieldCode() {
            return this.fieldCode;
        }

        public void setFieldCode(String fieldCode) {
            this.fieldCode = fieldCode;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getFieldType() {
            return this.fieldType;
        }

        public void setFieldType(String fieldType) {
            this.fieldType = fieldType;
        }

        public String getFieldDesc() {
            return this.fieldDesc;
        }

        public void setFieldDesc(String fieldDesc) {
            this.fieldDesc = fieldDesc;
        }

        public String getIsAllowNull() {
            return this.isAllowNull;
        }

        public void setIsAllowNull(String isAllowNull) {
            this.isAllowNull = isAllowNull;
        }

        public String getSubjectId() {
            return this.subjectId;
        }

        public void setSubjectId(String subjectId) {
            this.subjectId = subjectId;
        }
    }

    public static class ModelTableIndexData {
        @ExcelProperty(value={"\u7d22\u5f15\u540d"})
        private String indexName;
        @ExcelProperty(value={"\u7d22\u5f15\u5b57\u6bb5"})
        private String indexFields;
        @ExcelProperty(value={"\u7d22\u5f15\u7c7b\u578b"})
        private String indexType;

        public String getIndexName() {
            return this.indexName;
        }

        public void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public String getIndexFields() {
            return this.indexFields;
        }

        public void setIndexFields(String indexFields) {
            this.indexFields = indexFields;
        }

        public String getIndexType() {
            return this.indexType;
        }

        public void setIndexType(String indexType) {
            this.indexType = indexType;
        }
    }
}

