/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinpaas.console.dmcenter.api.rest;

import com.irdstudio.allinpaas.console.dmcenter.service.facade.ProjectTmCheckService;
import com.irdstudio.allinpaas.console.dmcenter.service.vo.ProjectTmCheckVO;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.beans.web.controller.AbstractController;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class ProjectTmCheckController
extends AbstractController {
    @Autowired
    @Qualifier(value="projectTmCheckService")
    private ProjectTmCheckService projectTmCheckService;

    @RequestMapping(value={"/project/tm/checks"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<ProjectTmCheckVO>> queryProjectTmCheckAll(ProjectTmCheckVO vo) {
        List<ProjectTmCheckVO> outputVo = this.projectTmCheckService.queryAllOwner(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/project/tm/check/{recordKeyid}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<ProjectTmCheckVO> queryByPk(@PathVariable(value="recordKeyid") String recordKeyid) {
        ProjectTmCheckVO inVo = new ProjectTmCheckVO();
        inVo.setRecordKeyid(recordKeyid);
        ProjectTmCheckVO outputVo = this.projectTmCheckService.queryByPk(inVo);
        return this.getResponseData((Object)outputVo);
    }

    @RequestMapping(value={"/project/tm/check"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody ProjectTmCheckVO inProjectTmCheckVo) {
        int outputVo = this.projectTmCheckService.deleteByPk(inProjectTmCheckVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/project/tm/check"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody ProjectTmCheckVO inProjectTmCheckVo) {
        int outputVo = this.projectTmCheckService.updateByPk(inProjectTmCheckVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/project/tm/check"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertProjectTmCheck(@RequestBody ProjectTmCheckVO inProjectTmCheckVo) {
        int outputVo = this.projectTmCheckService.insertProjectTmCheck(inProjectTmCheckVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/project/tm/checkall"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> projectModelTableCheck(@RequestBody ProjectTmCheckVO inProjectTmCheckVo) {
        inProjectTmCheckVo.setOperUserid(this.getUserInfo().getUserId());
        int outputVo = this.projectTmCheckService.projectModelTableCheck(inProjectTmCheckVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/project/tm/checkall/group"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> projectModelTableCheckGroup(@RequestBody ProjectTmCheckVO inProjectTmCheckVo) {
        inProjectTmCheckVo.setOperUserid(this.getUserInfo().getUserId());
        int outputVo = this.projectTmCheckService.projectModelTableCheckGroup(inProjectTmCheckVo);
        return this.getResponseData(outputVo);
    }
}

